/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.athena.transform.QueryExecutionStatisticsMarshaller;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class QueryExecutionStatistics
implements StructuredPojo,
ToCopyableBuilder<Builder, QueryExecutionStatistics> {
    private final Long engineExecutionTimeInMillis;
    private final Long dataScannedInBytes;

    private QueryExecutionStatistics(BuilderImpl builder) {
        this.engineExecutionTimeInMillis = builder.engineExecutionTimeInMillis;
        this.dataScannedInBytes = builder.dataScannedInBytes;
    }

    public Long engineExecutionTimeInMillis() {
        return this.engineExecutionTimeInMillis;
    }

    public Long dataScannedInBytes() {
        return this.dataScannedInBytes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.engineExecutionTimeInMillis());
        hashCode = 31 * hashCode + Objects.hashCode(this.dataScannedInBytes());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueryExecutionStatistics)) {
            return false;
        }
        QueryExecutionStatistics other = (QueryExecutionStatistics)obj;
        return Objects.equals(this.engineExecutionTimeInMillis(), other.engineExecutionTimeInMillis()) && Objects.equals(this.dataScannedInBytes(), other.dataScannedInBytes());
    }

    public String toString() {
        return ToString.builder((String)"QueryExecutionStatistics").add("EngineExecutionTimeInMillis", (Object)this.engineExecutionTimeInMillis()).add("DataScannedInBytes", (Object)this.dataScannedInBytes()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "EngineExecutionTimeInMillis": {
                return Optional.ofNullable(clazz.cast(this.engineExecutionTimeInMillis()));
            }
            case "DataScannedInBytes": {
                return Optional.ofNullable(clazz.cast(this.dataScannedInBytes()));
            }
        }
        return Optional.empty();
    }

    @SdkInternalApi
    public void marshall(ProtocolMarshaller protocolMarshaller) {
        QueryExecutionStatisticsMarshaller.getInstance().marshall(this, protocolMarshaller);
    }

    static final class BuilderImpl
    implements Builder {
        private Long engineExecutionTimeInMillis;
        private Long dataScannedInBytes;

        private BuilderImpl() {
        }

        private BuilderImpl(QueryExecutionStatistics model) {
            this.engineExecutionTimeInMillis(model.engineExecutionTimeInMillis);
            this.dataScannedInBytes(model.dataScannedInBytes);
        }

        public final Long getEngineExecutionTimeInMillis() {
            return this.engineExecutionTimeInMillis;
        }

        @Override
        public final Builder engineExecutionTimeInMillis(Long engineExecutionTimeInMillis) {
            this.engineExecutionTimeInMillis = engineExecutionTimeInMillis;
            return this;
        }

        public final void setEngineExecutionTimeInMillis(Long engineExecutionTimeInMillis) {
            this.engineExecutionTimeInMillis = engineExecutionTimeInMillis;
        }

        public final Long getDataScannedInBytes() {
            return this.dataScannedInBytes;
        }

        @Override
        public final Builder dataScannedInBytes(Long dataScannedInBytes) {
            this.dataScannedInBytes = dataScannedInBytes;
            return this;
        }

        public final void setDataScannedInBytes(Long dataScannedInBytes) {
            this.dataScannedInBytes = dataScannedInBytes;
        }

        public QueryExecutionStatistics build() {
            return new QueryExecutionStatistics(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, QueryExecutionStatistics> {
        public Builder engineExecutionTimeInMillis(Long var1);

        public Builder dataScannedInBytes(Long var1);
    }
}

