/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.services.athena.model.AthenaResponse;
import software.amazon.awssdk.services.athena.model.QueryExecutionIdListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListQueryExecutionsResponse
extends AthenaResponse
implements ToCopyableBuilder<Builder, ListQueryExecutionsResponse> {
    private final List<String> queryExecutionIds;
    private final String nextToken;

    private ListQueryExecutionsResponse(BuilderImpl builder) {
        super(builder);
        this.queryExecutionIds = builder.queryExecutionIds;
        this.nextToken = builder.nextToken;
    }

    public List<String> queryExecutionIds() {
        return this.queryExecutionIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queryExecutionIds());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueryExecutionsResponse)) {
            return false;
        }
        ListQueryExecutionsResponse other = (ListQueryExecutionsResponse)((Object)obj);
        return Objects.equals(this.queryExecutionIds(), other.queryExecutionIds()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public String toString() {
        return ToString.builder((String)"ListQueryExecutionsResponse").add("QueryExecutionIds", this.queryExecutionIds()).add("NextToken", (Object)this.nextToken()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryExecutionIds": {
                return Optional.ofNullable(clazz.cast(this.queryExecutionIds()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AthenaResponse.BuilderImpl
    implements Builder {
        private List<String> queryExecutionIds = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueryExecutionsResponse model) {
            super(model);
            this.queryExecutionIds(model.queryExecutionIds);
            this.nextToken(model.nextToken);
        }

        public final Collection<String> getQueryExecutionIds() {
            return this.queryExecutionIds;
        }

        @Override
        public final Builder queryExecutionIds(Collection<String> queryExecutionIds) {
            this.queryExecutionIds = QueryExecutionIdListCopier.copy(queryExecutionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryExecutionIds(String ... queryExecutionIds) {
            this.queryExecutionIds(Arrays.asList(queryExecutionIds));
            return this;
        }

        public final void setQueryExecutionIds(Collection<String> queryExecutionIds) {
            this.queryExecutionIds = QueryExecutionIdListCopier.copy(queryExecutionIds);
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public ListQueryExecutionsResponse build() {
            return new ListQueryExecutionsResponse(this);
        }
    }

    public static interface Builder
    extends AthenaResponse.Builder,
    CopyableBuilder<Builder, ListQueryExecutionsResponse> {
        public Builder queryExecutionIds(Collection<String> var1);

        public Builder queryExecutionIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

