/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.services.athena.model.UnprocessedQueryExecutionId;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class UnprocessedQueryExecutionIdMarshaller {
    private static final MarshallingInfo<String> QUERYEXECUTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QueryExecutionId").isBinary(false).build();
    private static final MarshallingInfo<String> ERRORCODE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorCode").isBinary(false).build();
    private static final MarshallingInfo<String> ERRORMESSAGE_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ErrorMessage").isBinary(false).build();
    private static final UnprocessedQueryExecutionIdMarshaller INSTANCE = new UnprocessedQueryExecutionIdMarshaller();

    private UnprocessedQueryExecutionIdMarshaller() {
    }

    public static UnprocessedQueryExecutionIdMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(UnprocessedQueryExecutionId unprocessedQueryExecutionId, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)unprocessedQueryExecutionId, (String)"unprocessedQueryExecutionId");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)unprocessedQueryExecutionId.queryExecutionId(), QUERYEXECUTIONID_BINDING);
            protocolMarshaller.marshall((Object)unprocessedQueryExecutionId.errorCode(), ERRORCODE_BINDING);
            protocolMarshaller.marshall((Object)unprocessedQueryExecutionId.errorMessage(), ERRORMESSAGE_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

