/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.transform;

import java.util.List;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.athena.model.ResultSet;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class ResultSetMarshaller {
    private static final MarshallingInfo<List> ROWS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.LIST).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Rows").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RESULTSETMETADATA_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResultSetMetadata").isBinary(false).build();
    private static final ResultSetMarshaller INSTANCE = new ResultSetMarshaller();

    private ResultSetMarshaller() {
    }

    public static ResultSetMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(ResultSet resultSet, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)resultSet, (String)"resultSet");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall(resultSet.rows(), ROWS_BINDING);
            protocolMarshaller.marshall((Object)resultSet.resultSetMetadata(), RESULTSETMETADATA_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

