/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingInfo;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.StructuredPojo;
import software.amazon.awssdk.services.athena.model.QueryExecution;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class QueryExecutionMarshaller {
    private static final MarshallingInfo<String> QUERYEXECUTIONID_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QueryExecutionId").isBinary(false).build();
    private static final MarshallingInfo<String> QUERY_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRING).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Query").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> RESULTCONFIGURATION_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("ResultConfiguration").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> QUERYEXECUTIONCONTEXT_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("QueryExecutionContext").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STATUS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Status").isBinary(false).build();
    private static final MarshallingInfo<StructuredPojo> STATISTICS_BINDING = MarshallingInfo.builder((MarshallingType)MarshallingType.STRUCTURED).marshallLocation(MarshallLocation.PAYLOAD).marshallLocationName("Statistics").isBinary(false).build();
    private static final QueryExecutionMarshaller INSTANCE = new QueryExecutionMarshaller();

    private QueryExecutionMarshaller() {
    }

    public static QueryExecutionMarshaller getInstance() {
        return INSTANCE;
    }

    public void marshall(QueryExecution queryExecution, ProtocolMarshaller protocolMarshaller) {
        Validate.paramNotNull((Object)queryExecution, (String)"queryExecution");
        Validate.paramNotNull((Object)protocolMarshaller, (String)"protocolMarshaller");
        try {
            protocolMarshaller.marshall((Object)queryExecution.queryExecutionId(), QUERYEXECUTIONID_BINDING);
            protocolMarshaller.marshall((Object)queryExecution.query(), QUERY_BINDING);
            protocolMarshaller.marshall((Object)queryExecution.resultConfiguration(), RESULTCONFIGURATION_BINDING);
            protocolMarshaller.marshall((Object)queryExecution.queryExecutionContext(), QUERYEXECUTIONCONTEXT_BINDING);
            protocolMarshaller.marshall((Object)queryExecution.status(), STATUS_BINDING);
            protocolMarshaller.marshall((Object)queryExecution.statistics(), STATISTICS_BINDING);
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

