/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.transform;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.protocol.json.AwsJsonProtocolFactory;
import software.amazon.awssdk.core.Request;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.http.HttpMethodName;
import software.amazon.awssdk.core.protocol.OperationInfo;
import software.amazon.awssdk.core.protocol.ProtocolMarshaller;
import software.amazon.awssdk.core.protocol.ProtocolRequestMarshaller;
import software.amazon.awssdk.core.runtime.transform.Marshaller;
import software.amazon.awssdk.services.athena.model.CreateNamedQueryRequest;
import software.amazon.awssdk.services.athena.transform.CreateNamedQueryRequestModelMarshaller;
import software.amazon.awssdk.utils.Validate;

@SdkInternalApi
public class CreateNamedQueryRequestMarshaller
implements Marshaller<Request<CreateNamedQueryRequest>, CreateNamedQueryRequest> {
    private static final OperationInfo SDK_OPERATION_BINDING = OperationInfo.builder().requestUri("/").httpMethodName(HttpMethodName.POST).hasExplicitPayloadMember(false).hasPayloadMembers(true).operationIdentifier("AmazonAthena.CreateNamedQuery").serviceName("Amazon Athena").build();
    private final AwsJsonProtocolFactory protocolFactory;

    public CreateNamedQueryRequestMarshaller(AwsJsonProtocolFactory protocolFactory) {
        this.protocolFactory = protocolFactory;
    }

    public Request<CreateNamedQueryRequest> marshall(CreateNamedQueryRequest createNamedQueryRequest) {
        Validate.paramNotNull((Object)((Object)createNamedQueryRequest), (String)"createNamedQueryRequest");
        try {
            ProtocolRequestMarshaller protocolMarshaller = this.protocolFactory.createProtocolMarshaller(SDK_OPERATION_BINDING, (SdkRequest)createNamedQueryRequest);
            protocolMarshaller.startMarshalling();
            CreateNamedQueryRequestModelMarshaller.getInstance().marshall(createNamedQueryRequest, (ProtocolMarshaller)protocolMarshaller);
            return protocolMarshaller.finishMarshalling();
        }
        catch (Exception e) {
            throw new SdkClientException("Unable to marshall request to JSON: " + e.getMessage(), (Throwable)e);
        }
    }
}

