/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest;
import software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse;

public class ListNamedQueriesPublisher
implements SdkPublisher<ListNamedQueriesResponse> {
    private final AthenaAsyncClient client;
    private final ListNamedQueriesRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListNamedQueriesPublisher(AthenaAsyncClient client, ListNamedQueriesRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListNamedQueriesPublisher(AthenaAsyncClient client, ListNamedQueriesRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListNamedQueriesResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListNamedQueriesResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final ListNamedQueriesPublisher resume(ListNamedQueriesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListNamedQueriesPublisher(this.client, (ListNamedQueriesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListNamedQueriesPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super ListNamedQueriesResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class ListNamedQueriesResponseFetcher
    implements AsyncPageFetcher<ListNamedQueriesResponse> {
        private ListNamedQueriesResponseFetcher() {
        }

        public boolean hasNextPage(ListNamedQueriesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<ListNamedQueriesResponse> nextPage(ListNamedQueriesResponse previousPage) {
            if (previousPage == null) {
                return ListNamedQueriesPublisher.this.client.listNamedQueries(ListNamedQueriesPublisher.this.firstRequest);
            }
            return ListNamedQueriesPublisher.this.client.listNamedQueries((ListNamedQueriesRequest)((Object)ListNamedQueriesPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

