/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.model.ListNamedQueriesRequest;
import software.amazon.awssdk.services.athena.model.ListNamedQueriesResponse;

public class ListNamedQueriesIterable
implements SdkIterable<ListNamedQueriesResponse> {
    private final AthenaClient client;
    private final ListNamedQueriesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListNamedQueriesIterable(AthenaClient client, ListNamedQueriesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListNamedQueriesResponseFetcher();
    }

    public Iterator<ListNamedQueriesResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final ListNamedQueriesIterable resume(ListNamedQueriesResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new ListNamedQueriesIterable(this.client, (ListNamedQueriesRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new ListNamedQueriesIterable(this.client, this.firstRequest){

            @Override
            public Iterator<ListNamedQueriesResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class ListNamedQueriesResponseFetcher
    implements SyncPageFetcher<ListNamedQueriesResponse> {
        private ListNamedQueriesResponseFetcher() {
        }

        public boolean hasNextPage(ListNamedQueriesResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public ListNamedQueriesResponse nextPage(ListNamedQueriesResponse previousPage) {
            if (previousPage == null) {
                return ListNamedQueriesIterable.this.client.listNamedQueries(ListNamedQueriesIterable.this.firstRequest);
            }
            return ListNamedQueriesIterable.this.client.listNamedQueries((ListNamedQueriesRequest)((Object)ListNamedQueriesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

