/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.concurrent.CompletableFuture;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.EmptySubscription;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.pagination.async.SdkPublisher;
import software.amazon.awssdk.services.athena.AthenaAsyncClient;
import software.amazon.awssdk.services.athena.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.athena.model.GetQueryResultsResponse;

public class GetQueryResultsPublisher
implements SdkPublisher<GetQueryResultsResponse> {
    private final AthenaAsyncClient client;
    private final GetQueryResultsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public GetQueryResultsPublisher(AthenaAsyncClient client, GetQueryResultsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private GetQueryResultsPublisher(AthenaAsyncClient client, GetQueryResultsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new GetQueryResultsResponseFetcher();
    }

    public void subscribe(Subscriber<? super GetQueryResultsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)new ResponsesSubscription(subscriber, this.nextPageFetcher));
    }

    public final GetQueryResultsPublisher resume(GetQueryResultsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetQueryResultsPublisher(this.client, (GetQueryResultsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetQueryResultsPublisher(this.client, this.firstRequest, true){

            @Override
            public void subscribe(Subscriber<? super GetQueryResultsResponse> subscriber) {
                subscriber.onSubscribe((Subscription)new EmptySubscription(subscriber));
            }
        };
    }

    private class GetQueryResultsResponseFetcher
    implements AsyncPageFetcher<GetQueryResultsResponse> {
        private GetQueryResultsResponseFetcher() {
        }

        public boolean hasNextPage(GetQueryResultsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public CompletableFuture<GetQueryResultsResponse> nextPage(GetQueryResultsResponse previousPage) {
            if (previousPage == null) {
                return GetQueryResultsPublisher.this.client.getQueryResults(GetQueryResultsPublisher.this.firstRequest);
            }
            return GetQueryResultsPublisher.this.client.getQueryResults((GetQueryResultsRequest)((Object)GetQueryResultsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

