/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.paginators;

import java.util.Collections;
import java.util.Iterator;
import software.amazon.awssdk.core.pagination.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.SdkIterable;
import software.amazon.awssdk.core.pagination.SyncPageFetcher;
import software.amazon.awssdk.services.athena.AthenaClient;
import software.amazon.awssdk.services.athena.model.GetQueryResultsRequest;
import software.amazon.awssdk.services.athena.model.GetQueryResultsResponse;

public class GetQueryResultsIterable
implements SdkIterable<GetQueryResultsResponse> {
    private final AthenaClient client;
    private final GetQueryResultsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public GetQueryResultsIterable(AthenaClient client, GetQueryResultsRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new GetQueryResultsResponseFetcher();
    }

    public Iterator<GetQueryResultsResponse> iterator() {
        return new PaginatedResponsesIterator(this.nextPageFetcher);
    }

    public final GetQueryResultsIterable resume(GetQueryResultsResponse lastSuccessfulPage) {
        if (this.nextPageFetcher.hasNextPage((Object)lastSuccessfulPage)) {
            return new GetQueryResultsIterable(this.client, (GetQueryResultsRequest)((Object)this.firstRequest.toBuilder().nextToken(lastSuccessfulPage.nextToken()).build()));
        }
        return new GetQueryResultsIterable(this.client, this.firstRequest){

            @Override
            public Iterator<GetQueryResultsResponse> iterator() {
                return Collections.emptyIterator();
            }
        };
    }

    private class GetQueryResultsResponseFetcher
    implements SyncPageFetcher<GetQueryResultsResponse> {
        private GetQueryResultsResponseFetcher() {
        }

        public boolean hasNextPage(GetQueryResultsResponse previousPage) {
            return previousPage.nextToken() != null;
        }

        public GetQueryResultsResponse nextPage(GetQueryResultsResponse previousPage) {
            if (previousPage == null) {
                return GetQueryResultsIterable.this.client.getQueryResults(GetQueryResultsIterable.this.firstRequest);
            }
            return GetQueryResultsIterable.this.client.getQueryResults((GetQueryResultsRequest)((Object)GetQueryResultsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

