/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfig;
import software.amazon.awssdk.services.athena.model.AthenaRequest;
import software.amazon.awssdk.services.athena.model.QueryExecutionContext;
import software.amazon.awssdk.services.athena.model.ResultConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class StartQueryExecutionRequest
extends AthenaRequest
implements ToCopyableBuilder<Builder, StartQueryExecutionRequest> {
    private final String queryString;
    private final String clientRequestToken;
    private final QueryExecutionContext queryExecutionContext;
    private final ResultConfiguration resultConfiguration;

    private StartQueryExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.queryString = builder.queryString;
        this.clientRequestToken = builder.clientRequestToken;
        this.queryExecutionContext = builder.queryExecutionContext;
        this.resultConfiguration = builder.resultConfiguration;
    }

    public String queryString() {
        return this.queryString;
    }

    public String clientRequestToken() {
        return this.clientRequestToken;
    }

    public QueryExecutionContext queryExecutionContext() {
        return this.queryExecutionContext;
    }

    public ResultConfiguration resultConfiguration() {
        return this.resultConfiguration;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.queryString());
        hashCode = 31 * hashCode + Objects.hashCode(this.clientRequestToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.queryExecutionContext());
        hashCode = 31 * hashCode + Objects.hashCode(this.resultConfiguration());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartQueryExecutionRequest)) {
            return false;
        }
        StartQueryExecutionRequest other = (StartQueryExecutionRequest)((Object)obj);
        return Objects.equals(this.queryString(), other.queryString()) && Objects.equals(this.clientRequestToken(), other.clientRequestToken()) && Objects.equals(this.queryExecutionContext(), other.queryExecutionContext()) && Objects.equals(this.resultConfiguration(), other.resultConfiguration());
    }

    public String toString() {
        return ToString.builder((String)"StartQueryExecutionRequest").add("QueryString", (Object)this.queryString()).add("ClientRequestToken", (Object)this.clientRequestToken()).add("QueryExecutionContext", (Object)this.queryExecutionContext()).add("ResultConfiguration", (Object)this.resultConfiguration()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "QueryString": {
                return Optional.of(clazz.cast(this.queryString()));
            }
            case "ClientRequestToken": {
                return Optional.of(clazz.cast(this.clientRequestToken()));
            }
            case "QueryExecutionContext": {
                return Optional.of(clazz.cast(this.queryExecutionContext()));
            }
            case "ResultConfiguration": {
                return Optional.of(clazz.cast(this.resultConfiguration()));
            }
        }
        return Optional.empty();
    }

    static final class BuilderImpl
    extends AthenaRequest.BuilderImpl
    implements Builder {
        private String queryString;
        private String clientRequestToken;
        private QueryExecutionContext queryExecutionContext;
        private ResultConfiguration resultConfiguration;

        private BuilderImpl() {
        }

        private BuilderImpl(StartQueryExecutionRequest model) {
            super(model);
            this.queryString(model.queryString);
            this.clientRequestToken(model.clientRequestToken);
            this.queryExecutionContext(model.queryExecutionContext);
            this.resultConfiguration(model.resultConfiguration);
        }

        public final String getQueryString() {
            return this.queryString;
        }

        @Override
        public final Builder queryString(String queryString) {
            this.queryString = queryString;
            return this;
        }

        public final void setQueryString(String queryString) {
            this.queryString = queryString;
        }

        public final String getClientRequestToken() {
            return this.clientRequestToken;
        }

        @Override
        public final Builder clientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
            return this;
        }

        public final void setClientRequestToken(String clientRequestToken) {
            this.clientRequestToken = clientRequestToken;
        }

        public final QueryExecutionContext.Builder getQueryExecutionContext() {
            return this.queryExecutionContext != null ? this.queryExecutionContext.toBuilder() : null;
        }

        @Override
        public final Builder queryExecutionContext(QueryExecutionContext queryExecutionContext) {
            this.queryExecutionContext = queryExecutionContext;
            return this;
        }

        public final void setQueryExecutionContext(QueryExecutionContext.BuilderImpl queryExecutionContext) {
            this.queryExecutionContext = queryExecutionContext != null ? queryExecutionContext.build() : null;
        }

        public final ResultConfiguration.Builder getResultConfiguration() {
            return this.resultConfiguration != null ? this.resultConfiguration.toBuilder() : null;
        }

        @Override
        public final Builder resultConfiguration(ResultConfiguration resultConfiguration) {
            this.resultConfiguration = resultConfiguration;
            return this;
        }

        public final void setResultConfiguration(ResultConfiguration.BuilderImpl resultConfiguration) {
            this.resultConfiguration = resultConfiguration != null ? resultConfiguration.build() : null;
        }

        @Override
        public Builder requestOverrideConfig(AwsRequestOverrideConfig awsRequestOverrideConfig) {
            super.requestOverrideConfig(awsRequestOverrideConfig);
            return this;
        }

        @Override
        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> builderConsumer) {
            super.requestOverrideConfig(builderConsumer);
            return this;
        }

        @Override
        public StartQueryExecutionRequest build() {
            return new StartQueryExecutionRequest(this);
        }
    }

    public static interface Builder
    extends AthenaRequest.Builder,
    CopyableBuilder<Builder, StartQueryExecutionRequest> {
        public Builder queryString(String var1);

        public Builder clientRequestToken(String var1);

        public Builder queryExecutionContext(QueryExecutionContext var1);

        default public Builder queryExecutionContext(Consumer<QueryExecutionContext.Builder> queryExecutionContext) {
            return this.queryExecutionContext((QueryExecutionContext)((QueryExecutionContext.Builder)QueryExecutionContext.builder().apply(queryExecutionContext)).build());
        }

        public Builder resultConfiguration(ResultConfiguration var1);

        default public Builder resultConfiguration(Consumer<ResultConfiguration.Builder> resultConfiguration) {
            return this.resultConfiguration((ResultConfiguration)((ResultConfiguration.Builder)ResultConfiguration.builder().apply(resultConfiguration)).build());
        }

        public Builder requestOverrideConfig(AwsRequestOverrideConfig var1);

        public Builder requestOverrideConfig(Consumer<AwsRequestOverrideConfig.Builder> var1);
    }
}

