/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.auth.signer.Aws4Signer;
import software.amazon.awssdk.auth.signer.StaticSignerProvider;
import software.amazon.awssdk.awscore.client.builder.AwsDefaultClientBuilder;
import software.amazon.awssdk.awscore.config.defaults.AwsClientConfigurationDefaults;
import software.amazon.awssdk.awscore.config.defaults.ServiceBuilderConfigurationDefaults;
import software.amazon.awssdk.core.runtime.auth.Signer;
import software.amazon.awssdk.core.runtime.auth.SignerProvider;
import software.amazon.awssdk.services.athena.AthenaBaseClientBuilder;

@SdkInternalApi
abstract class DefaultAthenaBaseClientBuilder<B extends AthenaBaseClientBuilder<B, C>, C>
extends AwsDefaultClientBuilder<B, C> {
    DefaultAthenaBaseClientBuilder() {
    }

    protected final String serviceEndpointPrefix() {
        return "athena";
    }

    protected final AwsClientConfigurationDefaults serviceDefaults() {
        return ServiceBuilderConfigurationDefaults.builder().defaultSignerProvider(this::defaultSignerProvider).addRequestHandlerPath("software/amazon/awssdk/services/athena/execution.interceptors").crc32FromCompressedDataEnabled(Boolean.valueOf(false)).build();
    }

    private SignerProvider defaultSignerProvider() {
        Aws4Signer signer = new Aws4Signer();
        signer.setServiceName("athena");
        signer.setRegionName(this.signingRegion().value());
        return StaticSignerProvider.create((Signer)signer);
    }
}

