/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.transform;

import com.fasterxml.jackson.core.JsonToken;
import software.amazon.awssdk.runtime.transform.JsonUnmarshallerContext;
import software.amazon.awssdk.runtime.transform.ListUnmarshaller;
import software.amazon.awssdk.runtime.transform.Unmarshaller;
import software.amazon.awssdk.services.athena.model.ResultSet;
import software.amazon.awssdk.services.athena.transform.ResultSetMetadataUnmarshaller;
import software.amazon.awssdk.services.athena.transform.RowUnmarshaller;

public class ResultSetUnmarshaller
implements Unmarshaller<ResultSet, JsonUnmarshallerContext> {
    private static ResultSetUnmarshaller INSTANCE;

    public ResultSet unmarshall(JsonUnmarshallerContext context) throws Exception {
        ResultSet.Builder resultSetBuilder = ResultSet.builder();
        int originalDepth = context.getCurrentDepth();
        String currentParentElement = context.getCurrentParentElement();
        int targetDepth = originalDepth + 1;
        JsonToken token = context.getCurrentToken();
        if (token == null) {
            token = context.nextToken();
        }
        if (token == JsonToken.VALUE_NULL) {
            return null;
        }
        while (token != null) {
            if (token == JsonToken.FIELD_NAME || token == JsonToken.START_OBJECT) {
                if (context.testExpression("Rows", targetDepth)) {
                    context.nextToken();
                    resultSetBuilder.rows(new ListUnmarshaller((Unmarshaller)RowUnmarshaller.getInstance()).unmarshall(context));
                }
                if (context.testExpression("ResultSetMetadata", targetDepth)) {
                    context.nextToken();
                    resultSetBuilder.resultSetMetadata(ResultSetMetadataUnmarshaller.getInstance().unmarshall(context));
                }
            } else if (!(token != JsonToken.END_ARRAY && token != JsonToken.END_OBJECT || context.getLastParsedParentElement() != null && !context.getLastParsedParentElement().equals(currentParentElement) || context.getCurrentDepth() > originalDepth)) break;
            token = context.nextToken();
        }
        return (ResultSet)resultSetBuilder.build();
    }

    public static ResultSetUnmarshaller getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ResultSetUnmarshaller();
        }
        return INSTANCE;
    }
}

