/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.athena.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import software.amazon.awssdk.AmazonWebServiceResult;
import software.amazon.awssdk.ResponseMetadata;
import software.amazon.awssdk.services.athena.model.QueryExecutionIdListCopier;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public class ListQueryExecutionsResponse
extends AmazonWebServiceResult<ResponseMetadata>
implements ToCopyableBuilder<Builder, ListQueryExecutionsResponse> {
    private final List<String> queryExecutionIds;
    private final String nextToken;

    private ListQueryExecutionsResponse(BuilderImpl builder) {
        this.queryExecutionIds = builder.queryExecutionIds;
        this.nextToken = builder.nextToken;
    }

    public List<String> queryExecutionIds() {
        return this.queryExecutionIds;
    }

    public String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.queryExecutionIds() == null ? 0 : this.queryExecutionIds().hashCode());
        hashCode = 31 * hashCode + (this.nextToken() == null ? 0 : this.nextToken().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueryExecutionsResponse)) {
            return false;
        }
        ListQueryExecutionsResponse other = (ListQueryExecutionsResponse)((Object)obj);
        if (other.queryExecutionIds() == null ^ this.queryExecutionIds() == null) {
            return false;
        }
        if (other.queryExecutionIds() != null && !other.queryExecutionIds().equals(this.queryExecutionIds())) {
            return false;
        }
        if (other.nextToken() == null ^ this.nextToken() == null) {
            return false;
        }
        return other.nextToken() == null || other.nextToken().equals(this.nextToken());
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.queryExecutionIds() != null) {
            sb.append("QueryExecutionIds: ").append(this.queryExecutionIds()).append(",");
        }
        if (this.nextToken() != null) {
            sb.append("NextToken: ").append(this.nextToken()).append(",");
        }
        sb.append("}");
        return sb.toString();
    }

    private static final class BuilderImpl
    implements Builder {
        private List<String> queryExecutionIds;
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueryExecutionsResponse model) {
            this.setQueryExecutionIds(model.queryExecutionIds);
            this.setNextToken(model.nextToken);
        }

        public final Collection<String> getQueryExecutionIds() {
            return this.queryExecutionIds;
        }

        @Override
        public final Builder queryExecutionIds(Collection<String> queryExecutionIds) {
            this.queryExecutionIds = QueryExecutionIdListCopier.copy(queryExecutionIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queryExecutionIds(String ... queryExecutionIds) {
            if (this.queryExecutionIds == null) {
                this.queryExecutionIds = new ArrayList<String>(queryExecutionIds.length);
            }
            for (String e : queryExecutionIds) {
                this.queryExecutionIds.add(e);
            }
            return this;
        }

        public final void setQueryExecutionIds(Collection<String> queryExecutionIds) {
            this.queryExecutionIds = QueryExecutionIdListCopier.copy(queryExecutionIds);
        }

        @SafeVarargs
        public final void setQueryExecutionIds(String ... queryExecutionIds) {
            if (this.queryExecutionIds == null) {
                this.queryExecutionIds = new ArrayList<String>(queryExecutionIds.length);
            }
            for (String e : queryExecutionIds) {
                this.queryExecutionIds.add(e);
            }
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        public ListQueryExecutionsResponse build() {
            return new ListQueryExecutionsResponse(this);
        }
    }

    public static interface Builder
    extends CopyableBuilder<Builder, ListQueryExecutionsResponse> {
        public Builder queryExecutionIds(Collection<String> var1);

        public Builder queryExecutionIds(String ... var1);

        public Builder nextToken(String var1);
    }
}

