/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arczonalshift.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.arczonalshift.model.AllowedWindowsCopier;
import software.amazon.awssdk.services.arczonalshift.model.ArcZonalShiftRequest;
import software.amazon.awssdk.services.arczonalshift.model.BlockedDatesCopier;
import software.amazon.awssdk.services.arczonalshift.model.BlockedWindowsCopier;
import software.amazon.awssdk.services.arczonalshift.model.BlockingAlarmsCopier;
import software.amazon.awssdk.services.arczonalshift.model.ControlCondition;
import software.amazon.awssdk.services.arczonalshift.model.OutcomeAlarmsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdatePracticeRunConfigurationRequest
extends ArcZonalShiftRequest
implements ToCopyableBuilder<Builder, UpdatePracticeRunConfigurationRequest> {
    private static final SdkField<String> RESOURCE_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceIdentifier").getter(UpdatePracticeRunConfigurationRequest.getter(UpdatePracticeRunConfigurationRequest::resourceIdentifier)).setter(UpdatePracticeRunConfigurationRequest.setter(Builder::resourceIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("resourceIdentifier").build()}).build();
    private static final SdkField<List<String>> BLOCKED_WINDOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("blockedWindows").getter(UpdatePracticeRunConfigurationRequest.getter(UpdatePracticeRunConfigurationRequest::blockedWindows)).setter(UpdatePracticeRunConfigurationRequest.setter(Builder::blockedWindows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedWindows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> BLOCKED_DATES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("blockedDates").getter(UpdatePracticeRunConfigurationRequest.getter(UpdatePracticeRunConfigurationRequest::blockedDates)).setter(UpdatePracticeRunConfigurationRequest.setter(Builder::blockedDates)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockedDates").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ControlCondition>> BLOCKING_ALARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("blockingAlarms").getter(UpdatePracticeRunConfigurationRequest.getter(UpdatePracticeRunConfigurationRequest::blockingAlarms)).setter(UpdatePracticeRunConfigurationRequest.setter(Builder::blockingAlarms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("blockingAlarms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ControlCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> ALLOWED_WINDOWS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedWindows").getter(UpdatePracticeRunConfigurationRequest.getter(UpdatePracticeRunConfigurationRequest::allowedWindows)).setter(UpdatePracticeRunConfigurationRequest.setter(Builder::allowedWindows)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedWindows").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<ControlCondition>> OUTCOME_ALARMS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("outcomeAlarms").getter(UpdatePracticeRunConfigurationRequest.getter(UpdatePracticeRunConfigurationRequest::outcomeAlarms)).setter(UpdatePracticeRunConfigurationRequest.setter(Builder::outcomeAlarms)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outcomeAlarms").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(ControlCondition::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RESOURCE_IDENTIFIER_FIELD, BLOCKED_WINDOWS_FIELD, BLOCKED_DATES_FIELD, BLOCKING_ALARMS_FIELD, ALLOWED_WINDOWS_FIELD, OUTCOME_ALARMS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdatePracticeRunConfigurationRequest.memberNameToFieldInitializer();
    private final String resourceIdentifier;
    private final List<String> blockedWindows;
    private final List<String> blockedDates;
    private final List<ControlCondition> blockingAlarms;
    private final List<String> allowedWindows;
    private final List<ControlCondition> outcomeAlarms;

    private UpdatePracticeRunConfigurationRequest(BuilderImpl builder) {
        super(builder);
        this.resourceIdentifier = builder.resourceIdentifier;
        this.blockedWindows = builder.blockedWindows;
        this.blockedDates = builder.blockedDates;
        this.blockingAlarms = builder.blockingAlarms;
        this.allowedWindows = builder.allowedWindows;
        this.outcomeAlarms = builder.outcomeAlarms;
    }

    public final String resourceIdentifier() {
        return this.resourceIdentifier;
    }

    public final boolean hasBlockedWindows() {
        return this.blockedWindows != null && !(this.blockedWindows instanceof SdkAutoConstructList);
    }

    public final List<String> blockedWindows() {
        return this.blockedWindows;
    }

    public final boolean hasBlockedDates() {
        return this.blockedDates != null && !(this.blockedDates instanceof SdkAutoConstructList);
    }

    public final List<String> blockedDates() {
        return this.blockedDates;
    }

    public final boolean hasBlockingAlarms() {
        return this.blockingAlarms != null && !(this.blockingAlarms instanceof SdkAutoConstructList);
    }

    public final List<ControlCondition> blockingAlarms() {
        return this.blockingAlarms;
    }

    public final boolean hasAllowedWindows() {
        return this.allowedWindows != null && !(this.allowedWindows instanceof SdkAutoConstructList);
    }

    public final List<String> allowedWindows() {
        return this.allowedWindows;
    }

    public final boolean hasOutcomeAlarms() {
        return this.outcomeAlarms != null && !(this.outcomeAlarms instanceof SdkAutoConstructList);
    }

    public final List<ControlCondition> outcomeAlarms() {
        return this.outcomeAlarms;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockedWindows() ? this.blockedWindows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockedDates() ? this.blockedDates() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBlockingAlarms() ? this.blockingAlarms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedWindows() ? this.allowedWindows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasOutcomeAlarms() ? this.outcomeAlarms() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdatePracticeRunConfigurationRequest)) {
            return false;
        }
        UpdatePracticeRunConfigurationRequest other = (UpdatePracticeRunConfigurationRequest)((Object)obj);
        return Objects.equals(this.resourceIdentifier(), other.resourceIdentifier()) && this.hasBlockedWindows() == other.hasBlockedWindows() && Objects.equals(this.blockedWindows(), other.blockedWindows()) && this.hasBlockedDates() == other.hasBlockedDates() && Objects.equals(this.blockedDates(), other.blockedDates()) && this.hasBlockingAlarms() == other.hasBlockingAlarms() && Objects.equals(this.blockingAlarms(), other.blockingAlarms()) && this.hasAllowedWindows() == other.hasAllowedWindows() && Objects.equals(this.allowedWindows(), other.allowedWindows()) && this.hasOutcomeAlarms() == other.hasOutcomeAlarms() && Objects.equals(this.outcomeAlarms(), other.outcomeAlarms());
    }

    public final String toString() {
        return ToString.builder((String)"UpdatePracticeRunConfigurationRequest").add("ResourceIdentifier", (Object)this.resourceIdentifier()).add("BlockedWindows", this.hasBlockedWindows() ? this.blockedWindows() : null).add("BlockedDates", this.hasBlockedDates() ? this.blockedDates() : null).add("BlockingAlarms", this.hasBlockingAlarms() ? this.blockingAlarms() : null).add("AllowedWindows", this.hasAllowedWindows() ? this.allowedWindows() : null).add("OutcomeAlarms", this.hasOutcomeAlarms() ? this.outcomeAlarms() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "resourceIdentifier": {
                return Optional.ofNullable(clazz.cast(this.resourceIdentifier()));
            }
            case "blockedWindows": {
                return Optional.ofNullable(clazz.cast(this.blockedWindows()));
            }
            case "blockedDates": {
                return Optional.ofNullable(clazz.cast(this.blockedDates()));
            }
            case "blockingAlarms": {
                return Optional.ofNullable(clazz.cast(this.blockingAlarms()));
            }
            case "allowedWindows": {
                return Optional.ofNullable(clazz.cast(this.allowedWindows()));
            }
            case "outcomeAlarms": {
                return Optional.ofNullable(clazz.cast(this.outcomeAlarms()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("resourceIdentifier", RESOURCE_IDENTIFIER_FIELD);
        map.put("blockedWindows", BLOCKED_WINDOWS_FIELD);
        map.put("blockedDates", BLOCKED_DATES_FIELD);
        map.put("blockingAlarms", BLOCKING_ALARMS_FIELD);
        map.put("allowedWindows", ALLOWED_WINDOWS_FIELD);
        map.put("outcomeAlarms", OUTCOME_ALARMS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdatePracticeRunConfigurationRequest, T> g) {
        return obj -> g.apply((UpdatePracticeRunConfigurationRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ArcZonalShiftRequest.BuilderImpl
    implements Builder {
        private String resourceIdentifier;
        private List<String> blockedWindows = DefaultSdkAutoConstructList.getInstance();
        private List<String> blockedDates = DefaultSdkAutoConstructList.getInstance();
        private List<ControlCondition> blockingAlarms = DefaultSdkAutoConstructList.getInstance();
        private List<String> allowedWindows = DefaultSdkAutoConstructList.getInstance();
        private List<ControlCondition> outcomeAlarms = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(UpdatePracticeRunConfigurationRequest model) {
            super(model);
            this.resourceIdentifier(model.resourceIdentifier);
            this.blockedWindows(model.blockedWindows);
            this.blockedDates(model.blockedDates);
            this.blockingAlarms(model.blockingAlarms);
            this.allowedWindows(model.allowedWindows);
            this.outcomeAlarms(model.outcomeAlarms);
        }

        public final String getResourceIdentifier() {
            return this.resourceIdentifier;
        }

        public final void setResourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
        }

        @Override
        public final Builder resourceIdentifier(String resourceIdentifier) {
            this.resourceIdentifier = resourceIdentifier;
            return this;
        }

        public final Collection<String> getBlockedWindows() {
            if (this.blockedWindows instanceof SdkAutoConstructList) {
                return null;
            }
            return this.blockedWindows;
        }

        public final void setBlockedWindows(Collection<String> blockedWindows) {
            this.blockedWindows = BlockedWindowsCopier.copy(blockedWindows);
        }

        @Override
        public final Builder blockedWindows(Collection<String> blockedWindows) {
            this.blockedWindows = BlockedWindowsCopier.copy(blockedWindows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockedWindows(String ... blockedWindows) {
            this.blockedWindows(Arrays.asList(blockedWindows));
            return this;
        }

        public final Collection<String> getBlockedDates() {
            if (this.blockedDates instanceof SdkAutoConstructList) {
                return null;
            }
            return this.blockedDates;
        }

        public final void setBlockedDates(Collection<String> blockedDates) {
            this.blockedDates = BlockedDatesCopier.copy(blockedDates);
        }

        @Override
        public final Builder blockedDates(Collection<String> blockedDates) {
            this.blockedDates = BlockedDatesCopier.copy(blockedDates);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockedDates(String ... blockedDates) {
            this.blockedDates(Arrays.asList(blockedDates));
            return this;
        }

        public final List<ControlCondition.Builder> getBlockingAlarms() {
            List<ControlCondition.Builder> result = BlockingAlarmsCopier.copyToBuilder(this.blockingAlarms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBlockingAlarms(Collection<ControlCondition.BuilderImpl> blockingAlarms) {
            this.blockingAlarms = BlockingAlarmsCopier.copyFromBuilder(blockingAlarms);
        }

        @Override
        public final Builder blockingAlarms(Collection<ControlCondition> blockingAlarms) {
            this.blockingAlarms = BlockingAlarmsCopier.copy(blockingAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockingAlarms(ControlCondition ... blockingAlarms) {
            this.blockingAlarms(Arrays.asList(blockingAlarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder blockingAlarms(Consumer<ControlCondition.Builder> ... blockingAlarms) {
            this.blockingAlarms(Stream.of(blockingAlarms).map(c -> (ControlCondition)((ControlCondition.Builder)ControlCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Collection<String> getAllowedWindows() {
            if (this.allowedWindows instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedWindows;
        }

        public final void setAllowedWindows(Collection<String> allowedWindows) {
            this.allowedWindows = AllowedWindowsCopier.copy(allowedWindows);
        }

        @Override
        public final Builder allowedWindows(Collection<String> allowedWindows) {
            this.allowedWindows = AllowedWindowsCopier.copy(allowedWindows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedWindows(String ... allowedWindows) {
            this.allowedWindows(Arrays.asList(allowedWindows));
            return this;
        }

        public final List<ControlCondition.Builder> getOutcomeAlarms() {
            List<ControlCondition.Builder> result = OutcomeAlarmsCopier.copyToBuilder(this.outcomeAlarms);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setOutcomeAlarms(Collection<ControlCondition.BuilderImpl> outcomeAlarms) {
            this.outcomeAlarms = OutcomeAlarmsCopier.copyFromBuilder(outcomeAlarms);
        }

        @Override
        public final Builder outcomeAlarms(Collection<ControlCondition> outcomeAlarms) {
            this.outcomeAlarms = OutcomeAlarmsCopier.copy(outcomeAlarms);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outcomeAlarms(ControlCondition ... outcomeAlarms) {
            this.outcomeAlarms(Arrays.asList(outcomeAlarms));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder outcomeAlarms(Consumer<ControlCondition.Builder> ... outcomeAlarms) {
            this.outcomeAlarms(Stream.of(outcomeAlarms).map(c -> (ControlCondition)((ControlCondition.Builder)ControlCondition.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdatePracticeRunConfigurationRequest build() {
            return new UpdatePracticeRunConfigurationRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ArcZonalShiftRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdatePracticeRunConfigurationRequest> {
        public Builder resourceIdentifier(String var1);

        public Builder blockedWindows(Collection<String> var1);

        public Builder blockedWindows(String ... var1);

        public Builder blockedDates(Collection<String> var1);

        public Builder blockedDates(String ... var1);

        public Builder blockingAlarms(Collection<ControlCondition> var1);

        public Builder blockingAlarms(ControlCondition ... var1);

        public Builder blockingAlarms(Consumer<ControlCondition.Builder> ... var1);

        public Builder allowedWindows(Collection<String> var1);

        public Builder allowedWindows(String ... var1);

        public Builder outcomeAlarms(Collection<ControlCondition> var1);

        public Builder outcomeAlarms(ControlCondition ... var1);

        public Builder outcomeAlarms(Consumer<ControlCondition.Builder> ... var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

