/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arczonalshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.arczonalshift.ArcZonalShiftAsyncClient;
import software.amazon.awssdk.services.arczonalshift.internal.UserAgentUtils;
import software.amazon.awssdk.services.arczonalshift.model.AutoshiftSummary;
import software.amazon.awssdk.services.arczonalshift.model.ListAutoshiftsRequest;
import software.amazon.awssdk.services.arczonalshift.model.ListAutoshiftsResponse;

public class ListAutoshiftsPublisher
implements SdkPublisher<ListAutoshiftsResponse> {
    private final ArcZonalShiftAsyncClient client;
    private final ListAutoshiftsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListAutoshiftsPublisher(ArcZonalShiftAsyncClient client, ListAutoshiftsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListAutoshiftsPublisher(ArcZonalShiftAsyncClient client, ListAutoshiftsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListAutoshiftsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListAutoshiftsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<AutoshiftSummary> items() {
        Function<ListAutoshiftsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListAutoshiftsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListAutoshiftsResponseFetcher
    implements AsyncPageFetcher<ListAutoshiftsResponse> {
        private ListAutoshiftsResponseFetcher() {
        }

        public boolean hasNextPage(ListAutoshiftsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListAutoshiftsResponse> nextPage(ListAutoshiftsResponse previousPage) {
            if (previousPage == null) {
                return ListAutoshiftsPublisher.this.client.listAutoshifts(ListAutoshiftsPublisher.this.firstRequest);
            }
            return ListAutoshiftsPublisher.this.client.listAutoshifts((ListAutoshiftsRequest)((Object)ListAutoshiftsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

