/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arczonalshift.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.arczonalshift.model.ControlConditionType;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ControlCondition
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ControlCondition> {
    private static final SdkField<String> ALARM_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("alarmIdentifier").getter(ControlCondition.getter(ControlCondition::alarmIdentifier)).setter(ControlCondition.setter(Builder::alarmIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("alarmIdentifier").build()}).build();
    private static final SdkField<String> TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("type").getter(ControlCondition.getter(ControlCondition::typeAsString)).setter(ControlCondition.setter(Builder::type)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("type").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ALARM_IDENTIFIER_FIELD, TYPE_FIELD));
    private static final long serialVersionUID = 1L;
    private final String alarmIdentifier;
    private final String type;

    private ControlCondition(BuilderImpl builder) {
        this.alarmIdentifier = builder.alarmIdentifier;
        this.type = builder.type;
    }

    public final String alarmIdentifier() {
        return this.alarmIdentifier;
    }

    public final ControlConditionType type() {
        return ControlConditionType.fromValue(this.type);
    }

    public final String typeAsString() {
        return this.type;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.alarmIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.typeAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ControlCondition)) {
            return false;
        }
        ControlCondition other = (ControlCondition)obj;
        return Objects.equals(this.alarmIdentifier(), other.alarmIdentifier()) && Objects.equals(this.typeAsString(), other.typeAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ControlCondition").add("AlarmIdentifier", (Object)this.alarmIdentifier()).add("Type", (Object)this.typeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "alarmIdentifier": {
                return Optional.ofNullable(clazz.cast(this.alarmIdentifier()));
            }
            case "type": {
                return Optional.ofNullable(clazz.cast(this.typeAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ControlCondition, T> g) {
        return obj -> g.apply((ControlCondition)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String alarmIdentifier;
        private String type;

        private BuilderImpl() {
        }

        private BuilderImpl(ControlCondition model) {
            this.alarmIdentifier(model.alarmIdentifier);
            this.type(model.type);
        }

        public final String getAlarmIdentifier() {
            return this.alarmIdentifier;
        }

        public final void setAlarmIdentifier(String alarmIdentifier) {
            this.alarmIdentifier = alarmIdentifier;
        }

        @Override
        public final Builder alarmIdentifier(String alarmIdentifier) {
            this.alarmIdentifier = alarmIdentifier;
            return this;
        }

        public final String getType() {
            return this.type;
        }

        public final void setType(String type) {
            this.type = type;
        }

        @Override
        public final Builder type(String type) {
            this.type = type;
            return this;
        }

        @Override
        public final Builder type(ControlConditionType type) {
            this.type(type == null ? null : type.toString());
            return this;
        }

        public ControlCondition build() {
            return new ControlCondition(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ControlCondition> {
        public Builder alarmIdentifier(String var1);

        public Builder type(String var1);

        public Builder type(ControlConditionType var1);
    }
}

