/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arczonalshift.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListZonalShiftsRequest extends ArcZonalShiftRequest implements
        ToCopyableBuilder<ListZonalShiftsRequest.Builder, ListZonalShiftsRequest> {
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxResults").getter(getter(ListZonalShiftsRequest::maxResults)).setter(setter(Builder::maxResults))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("maxResults").build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListZonalShiftsRequest::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("nextToken").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(ListZonalShiftsRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.QUERY_PARAM).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MAX_RESULTS_FIELD,
            NEXT_TOKEN_FIELD, STATUS_FIELD));

    private final Integer maxResults;

    private final String nextToken;

    private final String status;

    private ListZonalShiftsRequest(BuilderImpl builder) {
        super(builder);
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.status = builder.status;
    }

    /**
     * <p>
     * The number of objects that you want to return with this call.
     * </p>
     * 
     * @return The number of objects that you want to return with this call.
     */
    public final Integer maxResults() {
        return maxResults;
    }

    /**
     * <p>
     * Specifies that you want to receive the next page of results. Valid only if you received a <code>NextToken</code>
     * response in the previous request. If you did, it indicates that more output is available. Set this parameter to
     * the value provided by the previous call's <code>NextToken</code> response to request the next page of results.
     * </p>
     * 
     * @return Specifies that you want to receive the next page of results. Valid only if you received a
     *         <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
     *         available. Set this parameter to the value provided by the previous call's <code>NextToken</code>
     *         response to request the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    /**
     * <p>
     * A status for a zonal shift.
     * </p>
     * <p>
     * The <code>Status</code> for a zonal shift can have one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ACTIVE</b>: The zonal shift is started and active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>EXPIRED</b>: The zonal shift has expired (the expiry time was exceeded).
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CANCELED</b>: The zonal shift was canceled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ZonalShiftStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return A status for a zonal shift.</p>
     *         <p>
     *         The <code>Status</code> for a zonal shift can have one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>ACTIVE</b>: The zonal shift is started and active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>EXPIRED</b>: The zonal shift has expired (the expiry time was exceeded).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CANCELED</b>: The zonal shift was canceled.
     *         </p>
     *         </li>
     * @see ZonalShiftStatus
     */
    public final ZonalShiftStatus status() {
        return ZonalShiftStatus.fromValue(status);
    }

    /**
     * <p>
     * A status for a zonal shift.
     * </p>
     * <p>
     * The <code>Status</code> for a zonal shift can have one of the following values:
     * </p>
     * <ul>
     * <li>
     * <p>
     * <b>ACTIVE</b>: The zonal shift is started and active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>EXPIRED</b>: The zonal shift has expired (the expiry time was exceeded).
     * </p>
     * </li>
     * <li>
     * <p>
     * <b>CANCELED</b>: The zonal shift was canceled.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link ZonalShiftStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return A status for a zonal shift.</p>
     *         <p>
     *         The <code>Status</code> for a zonal shift can have one of the following values:
     *         </p>
     *         <ul>
     *         <li>
     *         <p>
     *         <b>ACTIVE</b>: The zonal shift is started and active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>EXPIRED</b>: The zonal shift has expired (the expiry time was exceeded).
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <b>CANCELED</b>: The zonal shift was canceled.
     *         </p>
     *         </li>
     * @see ZonalShiftStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListZonalShiftsRequest)) {
            return false;
        }
        ListZonalShiftsRequest other = (ListZonalShiftsRequest) obj;
        return Objects.equals(maxResults(), other.maxResults()) && Objects.equals(nextToken(), other.nextToken())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListZonalShiftsRequest").add("MaxResults", maxResults()).add("NextToken", nextToken())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "maxResults":
            return Optional.ofNullable(clazz.cast(maxResults()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<ListZonalShiftsRequest, T> g) {
        return obj -> g.apply((ListZonalShiftsRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends ArcZonalShiftRequest.Builder, SdkPojo, CopyableBuilder<Builder, ListZonalShiftsRequest> {
        /**
         * <p>
         * The number of objects that you want to return with this call.
         * </p>
         * 
         * @param maxResults
         *        The number of objects that you want to return with this call.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxResults(Integer maxResults);

        /**
         * <p>
         * Specifies that you want to receive the next page of results. Valid only if you received a
         * <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
         * available. Set this parameter to the value provided by the previous call's <code>NextToken</code> response to
         * request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specifies that you want to receive the next page of results. Valid only if you received a
         *        <code>NextToken</code> response in the previous request. If you did, it indicates that more output is
         *        available. Set this parameter to the value provided by the previous call's <code>NextToken</code>
         *        response to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);

        /**
         * <p>
         * A status for a zonal shift.
         * </p>
         * <p>
         * The <code>Status</code> for a zonal shift can have one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>ACTIVE</b>: The zonal shift is started and active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>EXPIRED</b>: The zonal shift has expired (the expiry time was exceeded).
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CANCELED</b>: The zonal shift was canceled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        A status for a zonal shift.</p>
         *        <p>
         *        The <code>Status</code> for a zonal shift can have one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>ACTIVE</b>: The zonal shift is started and active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>EXPIRED</b>: The zonal shift has expired (the expiry time was exceeded).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CANCELED</b>: The zonal shift was canceled.
         *        </p>
         *        </li>
         * @see ZonalShiftStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ZonalShiftStatus
         */
        Builder status(String status);

        /**
         * <p>
         * A status for a zonal shift.
         * </p>
         * <p>
         * The <code>Status</code> for a zonal shift can have one of the following values:
         * </p>
         * <ul>
         * <li>
         * <p>
         * <b>ACTIVE</b>: The zonal shift is started and active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>EXPIRED</b>: The zonal shift has expired (the expiry time was exceeded).
         * </p>
         * </li>
         * <li>
         * <p>
         * <b>CANCELED</b>: The zonal shift was canceled.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        A status for a zonal shift.</p>
         *        <p>
         *        The <code>Status</code> for a zonal shift can have one of the following values:
         *        </p>
         *        <ul>
         *        <li>
         *        <p>
         *        <b>ACTIVE</b>: The zonal shift is started and active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>EXPIRED</b>: The zonal shift has expired (the expiry time was exceeded).
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <b>CANCELED</b>: The zonal shift was canceled.
         *        </p>
         *        </li>
         * @see ZonalShiftStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ZonalShiftStatus
         */
        Builder status(ZonalShiftStatus status);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ArcZonalShiftRequest.BuilderImpl implements Builder {
        private Integer maxResults;

        private String nextToken;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(ListZonalShiftsRequest model) {
            super(model);
            maxResults(model.maxResults);
            nextToken(model.nextToken);
            status(model.status);
        }

        public final Integer getMaxResults() {
            return maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(ZonalShiftStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListZonalShiftsRequest build() {
            return new ListZonalShiftsRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }
}
