/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arczonalshift.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.arczonalshift.ArcZonalShiftClient;
import software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesRequest;
import software.amazon.awssdk.services.arczonalshift.model.ListManagedResourcesResponse;
import software.amazon.awssdk.services.arczonalshift.model.ManagedResourceSummary;

public class ListManagedResourcesIterable
implements SdkIterable<ListManagedResourcesResponse> {
    private final ArcZonalShiftClient client;
    private final ListManagedResourcesRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListManagedResourcesIterable(ArcZonalShiftClient client, ListManagedResourcesRequest firstRequest) {
        this.client = client;
        this.firstRequest = firstRequest;
        this.nextPageFetcher = new ListManagedResourcesResponseFetcher();
    }

    public Iterator<ListManagedResourcesResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ManagedResourceSummary> items() {
        Function<ListManagedResourcesResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListManagedResourcesResponseFetcher
    implements SyncPageFetcher<ListManagedResourcesResponse> {
        private ListManagedResourcesResponseFetcher() {
        }

        public boolean hasNextPage(ListManagedResourcesResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListManagedResourcesResponse nextPage(ListManagedResourcesResponse previousPage) {
            if (previousPage == null) {
                return ListManagedResourcesIterable.this.client.listManagedResources(ListManagedResourcesIterable.this.firstRequest);
            }
            return ListManagedResourcesIterable.this.client.listManagedResources((ListManagedResourcesRequest)((Object)ListManagedResourcesIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

