/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.arcregionswitch.ArcRegionSwitchClient;
import software.amazon.awssdk.services.arcregionswitch.internal.UserAgentUtils;
import software.amazon.awssdk.services.arcregionswitch.model.ListRoute53HealthChecksInRegionRequest;
import software.amazon.awssdk.services.arcregionswitch.model.ListRoute53HealthChecksInRegionResponse;
import software.amazon.awssdk.services.arcregionswitch.model.Route53HealthCheck;

public class ListRoute53HealthChecksInRegionIterable
implements SdkIterable<ListRoute53HealthChecksInRegionResponse> {
    private final ArcRegionSwitchClient client;
    private final ListRoute53HealthChecksInRegionRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListRoute53HealthChecksInRegionIterable(ArcRegionSwitchClient client, ListRoute53HealthChecksInRegionRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListRoute53HealthChecksInRegionResponseFetcher();
    }

    public Iterator<ListRoute53HealthChecksInRegionResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<Route53HealthCheck> healthChecks() {
        Function<ListRoute53HealthChecksInRegionResponse, Iterator> getIterator = response -> {
            if (response != null && response.healthChecks() != null) {
                return response.healthChecks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListRoute53HealthChecksInRegionResponseFetcher
    implements SyncPageFetcher<ListRoute53HealthChecksInRegionResponse> {
        private ListRoute53HealthChecksInRegionResponseFetcher() {
        }

        public boolean hasNextPage(ListRoute53HealthChecksInRegionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListRoute53HealthChecksInRegionResponse nextPage(ListRoute53HealthChecksInRegionResponse previousPage) {
            if (previousPage == null) {
                return ListRoute53HealthChecksInRegionIterable.this.client.listRoute53HealthChecksInRegion(ListRoute53HealthChecksInRegionIterable.this.firstRequest);
            }
            return ListRoute53HealthChecksInRegionIterable.this.client.listRoute53HealthChecksInRegion((ListRoute53HealthChecksInRegionRequest)((Object)ListRoute53HealthChecksInRegionIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

