/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.arcregionswitch.model.Approval;
import software.amazon.awssdk.services.arcregionswitch.model.ArcRegionSwitchRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ApprovePlanExecutionStepRequest
extends ArcRegionSwitchRequest
implements ToCopyableBuilder<Builder, ApprovePlanExecutionStepRequest> {
    private static final SdkField<String> PLAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("planArn").getter(ApprovePlanExecutionStepRequest.getter(ApprovePlanExecutionStepRequest::planArn)).setter(ApprovePlanExecutionStepRequest.setter(Builder::planArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planArn").build()}).build();
    private static final SdkField<String> EXECUTION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("executionId").getter(ApprovePlanExecutionStepRequest.getter(ApprovePlanExecutionStepRequest::executionId)).setter(ApprovePlanExecutionStepRequest.setter(Builder::executionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionId").build()}).build();
    private static final SdkField<String> STEP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepName").getter(ApprovePlanExecutionStepRequest.getter(ApprovePlanExecutionStepRequest::stepName)).setter(ApprovePlanExecutionStepRequest.setter(Builder::stepName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepName").build()}).build();
    private static final SdkField<String> APPROVAL_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("approval").getter(ApprovePlanExecutionStepRequest.getter(ApprovePlanExecutionStepRequest::approvalAsString)).setter(ApprovePlanExecutionStepRequest.setter(Builder::approval)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approval").build()}).build();
    private static final SdkField<String> COMMENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("comment").getter(ApprovePlanExecutionStepRequest.getter(ApprovePlanExecutionStepRequest::comment)).setter(ApprovePlanExecutionStepRequest.setter(Builder::comment)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAN_ARN_FIELD, EXECUTION_ID_FIELD, STEP_NAME_FIELD, APPROVAL_FIELD, COMMENT_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ApprovePlanExecutionStepRequest.memberNameToFieldInitializer();
    private final String planArn;
    private final String executionId;
    private final String stepName;
    private final String approval;
    private final String comment;

    private ApprovePlanExecutionStepRequest(BuilderImpl builder) {
        super(builder);
        this.planArn = builder.planArn;
        this.executionId = builder.executionId;
        this.stepName = builder.stepName;
        this.approval = builder.approval;
        this.comment = builder.comment;
    }

    public final String planArn() {
        return this.planArn;
    }

    public final String executionId() {
        return this.executionId;
    }

    public final String stepName() {
        return this.stepName;
    }

    public final Approval approval() {
        return Approval.fromValue(this.approval);
    }

    public final String approvalAsString() {
        return this.approval;
    }

    public final String comment() {
        return this.comment;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.planArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepName());
        hashCode = 31 * hashCode + Objects.hashCode(this.approvalAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.comment());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ApprovePlanExecutionStepRequest)) {
            return false;
        }
        ApprovePlanExecutionStepRequest other = (ApprovePlanExecutionStepRequest)((Object)obj);
        return Objects.equals(this.planArn(), other.planArn()) && Objects.equals(this.executionId(), other.executionId()) && Objects.equals(this.stepName(), other.stepName()) && Objects.equals(this.approvalAsString(), other.approvalAsString()) && Objects.equals(this.comment(), other.comment());
    }

    public final String toString() {
        return ToString.builder((String)"ApprovePlanExecutionStepRequest").add("PlanArn", (Object)this.planArn()).add("ExecutionId", (Object)this.executionId()).add("StepName", (Object)this.stepName()).add("Approval", (Object)this.approvalAsString()).add("Comment", (Object)this.comment()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "planArn": {
                return Optional.ofNullable(clazz.cast(this.planArn()));
            }
            case "executionId": {
                return Optional.ofNullable(clazz.cast(this.executionId()));
            }
            case "stepName": {
                return Optional.ofNullable(clazz.cast(this.stepName()));
            }
            case "approval": {
                return Optional.ofNullable(clazz.cast(this.approvalAsString()));
            }
            case "comment": {
                return Optional.ofNullable(clazz.cast(this.comment()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("planArn", PLAN_ARN_FIELD);
        map.put("executionId", EXECUTION_ID_FIELD);
        map.put("stepName", STEP_NAME_FIELD);
        map.put("approval", APPROVAL_FIELD);
        map.put("comment", COMMENT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ApprovePlanExecutionStepRequest, T> g) {
        return obj -> g.apply((ApprovePlanExecutionStepRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ArcRegionSwitchRequest.BuilderImpl
    implements Builder {
        private String planArn;
        private String executionId;
        private String stepName;
        private String approval;
        private String comment;

        private BuilderImpl() {
        }

        private BuilderImpl(ApprovePlanExecutionStepRequest model) {
            super(model);
            this.planArn(model.planArn);
            this.executionId(model.executionId);
            this.stepName(model.stepName);
            this.approval(model.approval);
            this.comment(model.comment);
        }

        public final String getPlanArn() {
            return this.planArn;
        }

        public final void setPlanArn(String planArn) {
            this.planArn = planArn;
        }

        @Override
        public final Builder planArn(String planArn) {
            this.planArn = planArn;
            return this;
        }

        public final String getExecutionId() {
            return this.executionId;
        }

        public final void setExecutionId(String executionId) {
            this.executionId = executionId;
        }

        @Override
        public final Builder executionId(String executionId) {
            this.executionId = executionId;
            return this;
        }

        public final String getStepName() {
            return this.stepName;
        }

        public final void setStepName(String stepName) {
            this.stepName = stepName;
        }

        @Override
        public final Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public final String getApproval() {
            return this.approval;
        }

        public final void setApproval(String approval) {
            this.approval = approval;
        }

        @Override
        public final Builder approval(String approval) {
            this.approval = approval;
            return this;
        }

        @Override
        public final Builder approval(Approval approval) {
            this.approval(approval == null ? null : approval.toString());
            return this;
        }

        public final String getComment() {
            return this.comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ApprovePlanExecutionStepRequest build() {
            return new ApprovePlanExecutionStepRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ArcRegionSwitchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ApprovePlanExecutionStepRequest> {
        public Builder planArn(String var1);

        public Builder executionId(String var1);

        public Builder stepName(String var1);

        public Builder approval(String var1);

        public Builder approval(Approval var1);

        public Builder comment(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

