/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.waiters;

import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.AsyncWaiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.arcregionswitch.ArcRegionSwitchAsyncClient;
import software.amazon.awssdk.services.arcregionswitch.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.arcregionswitch.model.ArcRegionSwitchRequest;
import software.amazon.awssdk.services.arcregionswitch.model.GetPlanEvaluationStatusRequest;
import software.amazon.awssdk.services.arcregionswitch.model.GetPlanEvaluationStatusResponse;
import software.amazon.awssdk.services.arcregionswitch.model.GetPlanExecutionRequest;
import software.amazon.awssdk.services.arcregionswitch.model.GetPlanExecutionResponse;
import software.amazon.awssdk.services.arcregionswitch.waiters.ArcRegionSwitchAsyncWaiter;
import software.amazon.awssdk.services.arcregionswitch.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;
import software.amazon.awssdk.utils.ThreadFactoryBuilder;

@SdkInternalApi
@ThreadSafe
final class DefaultArcRegionSwitchAsyncWaiter
implements ArcRegionSwitchAsyncWaiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private static final WaiterAttribute<ScheduledExecutorService> SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE = new WaiterAttribute(ScheduledExecutorService.class);
    private final ArcRegionSwitchAsyncClient client;
    private final AttributeMap managedResources;
    private final AsyncWaiter<GetPlanEvaluationStatusResponse> planEvaluationStatusPassedWaiter;
    private final AsyncWaiter<GetPlanExecutionResponse> planExecutionCompletedWaiter;
    private final ScheduledExecutorService executorService;

    private DefaultArcRegionSwitchAsyncWaiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (ArcRegionSwitchAsyncClient)ArcRegionSwitchAsyncClient.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        if (builder.executorService == null) {
            this.executorService = Executors.newScheduledThreadPool(1, new ThreadFactoryBuilder().threadNamePrefix("waiters-ScheduledExecutor").build());
            attributeMapBuilder.put(SCHEDULED_EXECUTOR_SERVICE_ATTRIBUTE, (Object)this.executorService);
        } else {
            this.executorService = builder.executorService;
        }
        this.managedResources = attributeMapBuilder.build();
        this.planEvaluationStatusPassedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetPlanEvaluationStatusResponse.class).acceptors(DefaultArcRegionSwitchAsyncWaiter.planEvaluationStatusPassedWaiterAcceptors())).overrideConfiguration(DefaultArcRegionSwitchAsyncWaiter.planEvaluationStatusPassedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
        this.planExecutionCompletedWaiter = ((AsyncWaiter.Builder)((AsyncWaiter.Builder)AsyncWaiter.builder(GetPlanExecutionResponse.class).acceptors(DefaultArcRegionSwitchAsyncWaiter.planExecutionCompletedWaiterAcceptors())).overrideConfiguration(DefaultArcRegionSwitchAsyncWaiter.planExecutionCompletedWaiterConfig(builder.overrideConfiguration))).scheduledExecutorService(this.executorService).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public CompletableFuture<WaiterResponse<GetPlanEvaluationStatusResponse>> waitUntilPlanEvaluationStatusPassed(GetPlanEvaluationStatusRequest getPlanEvaluationStatusRequest) {
        return this.planEvaluationStatusPassedWaiter.runAsync(() -> this.client.getPlanEvaluationStatus(this.applyWaitersUserAgent(getPlanEvaluationStatusRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetPlanEvaluationStatusResponse>> waitUntilPlanEvaluationStatusPassed(GetPlanEvaluationStatusRequest getPlanEvaluationStatusRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.planEvaluationStatusPassedWaiter.runAsync(() -> this.client.getPlanEvaluationStatus(this.applyWaitersUserAgent(getPlanEvaluationStatusRequest)), DefaultArcRegionSwitchAsyncWaiter.planEvaluationStatusPassedWaiterConfig(overrideConfig));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetPlanExecutionResponse>> waitUntilPlanExecutionCompleted(GetPlanExecutionRequest getPlanExecutionRequest) {
        return this.planExecutionCompletedWaiter.runAsync(() -> this.client.getPlanExecution(this.applyWaitersUserAgent(getPlanExecutionRequest)));
    }

    @Override
    public CompletableFuture<WaiterResponse<GetPlanExecutionResponse>> waitUntilPlanExecutionCompleted(GetPlanExecutionRequest getPlanExecutionRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.planExecutionCompletedWaiter.runAsync(() -> this.client.getPlanExecution(this.applyWaitersUserAgent(getPlanExecutionRequest)), DefaultArcRegionSwitchAsyncWaiter.planExecutionCompletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super GetPlanEvaluationStatusResponse>> planEvaluationStatusPassedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetPlanEvaluationStatusResponse>> result = new ArrayList<WaiterAcceptor<? super GetPlanEvaluationStatusResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("evaluationState").value(), "passed");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("evaluationState").value(), "actionRequired");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (evaluationState=actionRequired) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("evaluationState").value(), "pendingEvaluation");
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetPlanExecutionResponse>> planExecutionCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetPlanExecutionResponse>> result = new ArrayList<WaiterAcceptor<? super GetPlanExecutionResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("executionState").value(), "completed");
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("executionState").value(), "completedWithExceptions");
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("executionState").value(), "failed");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (executionState=failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("executionState").value(), "canceled");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (executionState=canceled) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("executionState").value(), "planExecutionTimedOut");
        }, (String)"A waiter acceptor with the matcher (path) was matched on parameter (executionState=planExecutionTimedOut) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration planEvaluationStatusPassedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration planExecutionCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(30L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static ArcRegionSwitchAsyncWaiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends ArcRegionSwitchRequest> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((ArcRegionSwitchRequest)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements ArcRegionSwitchAsyncWaiter.Builder {
        private ArcRegionSwitchAsyncClient client;
        private WaiterOverrideConfiguration overrideConfiguration;
        private ScheduledExecutorService executorService;

        private DefaultBuilder() {
        }

        @Override
        public ArcRegionSwitchAsyncWaiter.Builder scheduledExecutorService(ScheduledExecutorService executorService) {
            this.executorService = executorService;
            return this;
        }

        @Override
        public ArcRegionSwitchAsyncWaiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public ArcRegionSwitchAsyncWaiter.Builder client(ArcRegionSwitchAsyncClient client) {
            this.client = client;
            return this;
        }

        @Override
        public ArcRegionSwitchAsyncWaiter build() {
            return new DefaultArcRegionSwitchAsyncWaiter(this);
        }
    }
}

