/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Route53ResourceRecordSet
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Route53ResourceRecordSet> {
    private static final SdkField<String> RECORD_SET_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("recordSetIdentifier").getter(Route53ResourceRecordSet.getter(Route53ResourceRecordSet::recordSetIdentifier)).setter(Route53ResourceRecordSet.setter(Builder::recordSetIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recordSetIdentifier").build()}).build();
    private static final SdkField<String> REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("region").getter(Route53ResourceRecordSet.getter(Route53ResourceRecordSet::region)).setter(Route53ResourceRecordSet.setter(Builder::region)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("region").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RECORD_SET_IDENTIFIER_FIELD, REGION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Route53ResourceRecordSet.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String recordSetIdentifier;
    private final String region;

    private Route53ResourceRecordSet(BuilderImpl builder) {
        this.recordSetIdentifier = builder.recordSetIdentifier;
        this.region = builder.region;
    }

    public final String recordSetIdentifier() {
        return this.recordSetIdentifier;
    }

    public final String region() {
        return this.region;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.recordSetIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.region());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Route53ResourceRecordSet)) {
            return false;
        }
        Route53ResourceRecordSet other = (Route53ResourceRecordSet)obj;
        return Objects.equals(this.recordSetIdentifier(), other.recordSetIdentifier()) && Objects.equals(this.region(), other.region());
    }

    public final String toString() {
        return ToString.builder((String)"Route53ResourceRecordSet").add("RecordSetIdentifier", (Object)this.recordSetIdentifier()).add("Region", (Object)this.region()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "recordSetIdentifier": {
                return Optional.ofNullable(clazz.cast(this.recordSetIdentifier()));
            }
            case "region": {
                return Optional.ofNullable(clazz.cast(this.region()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("recordSetIdentifier", RECORD_SET_IDENTIFIER_FIELD);
        map.put("region", REGION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Route53ResourceRecordSet, T> g) {
        return obj -> g.apply((Route53ResourceRecordSet)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String recordSetIdentifier;
        private String region;

        private BuilderImpl() {
        }

        private BuilderImpl(Route53ResourceRecordSet model) {
            this.recordSetIdentifier(model.recordSetIdentifier);
            this.region(model.region);
        }

        public final String getRecordSetIdentifier() {
            return this.recordSetIdentifier;
        }

        public final void setRecordSetIdentifier(String recordSetIdentifier) {
            this.recordSetIdentifier = recordSetIdentifier;
        }

        @Override
        public final Builder recordSetIdentifier(String recordSetIdentifier) {
            this.recordSetIdentifier = recordSetIdentifier;
            return this;
        }

        public final String getRegion() {
            return this.region;
        }

        public final void setRegion(String region) {
            this.region = region;
        }

        @Override
        public final Builder region(String region) {
            this.region = region;
            return this;
        }

        public Route53ResourceRecordSet build() {
            return new Route53ResourceRecordSet(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Route53ResourceRecordSet> {
        public Builder recordSetIdentifier(String var1);

        public Builder region(String var1);
    }
}

