/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.arcregionswitch.ArcRegionSwitchAsyncClient;
import software.amazon.awssdk.services.arcregionswitch.internal.UserAgentUtils;
import software.amazon.awssdk.services.arcregionswitch.model.ListRoute53HealthChecksInRegionRequest;
import software.amazon.awssdk.services.arcregionswitch.model.ListRoute53HealthChecksInRegionResponse;
import software.amazon.awssdk.services.arcregionswitch.model.Route53HealthCheck;

public class ListRoute53HealthChecksInRegionPublisher
implements SdkPublisher<ListRoute53HealthChecksInRegionResponse> {
    private final ArcRegionSwitchAsyncClient client;
    private final ListRoute53HealthChecksInRegionRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListRoute53HealthChecksInRegionPublisher(ArcRegionSwitchAsyncClient client, ListRoute53HealthChecksInRegionRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListRoute53HealthChecksInRegionPublisher(ArcRegionSwitchAsyncClient client, ListRoute53HealthChecksInRegionRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListRoute53HealthChecksInRegionResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListRoute53HealthChecksInRegionResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Route53HealthCheck> healthChecks() {
        Function<ListRoute53HealthChecksInRegionResponse, Iterator> getIterator = response -> {
            if (response != null && response.healthChecks() != null) {
                return response.healthChecks().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListRoute53HealthChecksInRegionResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListRoute53HealthChecksInRegionResponseFetcher
    implements AsyncPageFetcher<ListRoute53HealthChecksInRegionResponse> {
        private ListRoute53HealthChecksInRegionResponseFetcher() {
        }

        public boolean hasNextPage(ListRoute53HealthChecksInRegionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListRoute53HealthChecksInRegionResponse> nextPage(ListRoute53HealthChecksInRegionResponse previousPage) {
            if (previousPage == null) {
                return ListRoute53HealthChecksInRegionPublisher.this.client.listRoute53HealthChecksInRegion(ListRoute53HealthChecksInRegionPublisher.this.firstRequest);
            }
            return ListRoute53HealthChecksInRegionPublisher.this.client.listRoute53HealthChecksInRegion((ListRoute53HealthChecksInRegionRequest)((Object)ListRoute53HealthChecksInRegionPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

