/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.services.arcregionswitch.model.ArcRoutingControlConfiguration;
import software.amazon.awssdk.services.arcregionswitch.model.CustomActionLambdaConfiguration;
import software.amazon.awssdk.services.arcregionswitch.model.DocumentDbConfiguration;
import software.amazon.awssdk.services.arcregionswitch.model.Ec2AsgCapacityIncreaseConfiguration;
import software.amazon.awssdk.services.arcregionswitch.model.EcsCapacityIncreaseConfiguration;
import software.amazon.awssdk.services.arcregionswitch.model.EksResourceScalingConfiguration;
import software.amazon.awssdk.services.arcregionswitch.model.ExecutionApprovalConfiguration;
import software.amazon.awssdk.services.arcregionswitch.model.GlobalAuroraConfiguration;
import software.amazon.awssdk.services.arcregionswitch.model.ParallelExecutionBlockConfiguration;
import software.amazon.awssdk.services.arcregionswitch.model.RegionSwitchPlanConfiguration;
import software.amazon.awssdk.services.arcregionswitch.model.Route53HealthCheckConfiguration;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ExecutionBlockConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ExecutionBlockConfiguration> {
    private static final SdkField<CustomActionLambdaConfiguration> CUSTOM_ACTION_LAMBDA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("customActionLambdaConfig").getter(ExecutionBlockConfiguration.getter(ExecutionBlockConfiguration::customActionLambdaConfig)).setter(ExecutionBlockConfiguration.setter(Builder::customActionLambdaConfig)).constructor(CustomActionLambdaConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customActionLambdaConfig").build()}).build();
    private static final SdkField<Ec2AsgCapacityIncreaseConfiguration> EC2_ASG_CAPACITY_INCREASE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ec2AsgCapacityIncreaseConfig").getter(ExecutionBlockConfiguration.getter(ExecutionBlockConfiguration::ec2AsgCapacityIncreaseConfig)).setter(ExecutionBlockConfiguration.setter(Builder::ec2AsgCapacityIncreaseConfig)).constructor(Ec2AsgCapacityIncreaseConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2AsgCapacityIncreaseConfig").build()}).build();
    private static final SdkField<ExecutionApprovalConfiguration> EXECUTION_APPROVAL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("executionApprovalConfig").getter(ExecutionBlockConfiguration.getter(ExecutionBlockConfiguration::executionApprovalConfig)).setter(ExecutionBlockConfiguration.setter(Builder::executionApprovalConfig)).constructor(ExecutionApprovalConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionApprovalConfig").build()}).build();
    private static final SdkField<ArcRoutingControlConfiguration> ARC_ROUTING_CONTROL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("arcRoutingControlConfig").getter(ExecutionBlockConfiguration.getter(ExecutionBlockConfiguration::arcRoutingControlConfig)).setter(ExecutionBlockConfiguration.setter(Builder::arcRoutingControlConfig)).constructor(ArcRoutingControlConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arcRoutingControlConfig").build()}).build();
    private static final SdkField<GlobalAuroraConfiguration> GLOBAL_AURORA_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("globalAuroraConfig").getter(ExecutionBlockConfiguration.getter(ExecutionBlockConfiguration::globalAuroraConfig)).setter(ExecutionBlockConfiguration.setter(Builder::globalAuroraConfig)).constructor(GlobalAuroraConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("globalAuroraConfig").build()}).build();
    private static final SdkField<ParallelExecutionBlockConfiguration> PARALLEL_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("parallelConfig").getter(ExecutionBlockConfiguration.getter(ExecutionBlockConfiguration::parallelConfig)).setter(ExecutionBlockConfiguration.setter(Builder::parallelConfig)).constructor(ParallelExecutionBlockConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parallelConfig").build()}).build();
    private static final SdkField<RegionSwitchPlanConfiguration> REGION_SWITCH_PLAN_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("regionSwitchPlanConfig").getter(ExecutionBlockConfiguration.getter(ExecutionBlockConfiguration::regionSwitchPlanConfig)).setter(ExecutionBlockConfiguration.setter(Builder::regionSwitchPlanConfig)).constructor(RegionSwitchPlanConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionSwitchPlanConfig").build()}).build();
    private static final SdkField<EcsCapacityIncreaseConfiguration> ECS_CAPACITY_INCREASE_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ecsCapacityIncreaseConfig").getter(ExecutionBlockConfiguration.getter(ExecutionBlockConfiguration::ecsCapacityIncreaseConfig)).setter(ExecutionBlockConfiguration.setter(Builder::ecsCapacityIncreaseConfig)).constructor(EcsCapacityIncreaseConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecsCapacityIncreaseConfig").build()}).build();
    private static final SdkField<EksResourceScalingConfiguration> EKS_RESOURCE_SCALING_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("eksResourceScalingConfig").getter(ExecutionBlockConfiguration.getter(ExecutionBlockConfiguration::eksResourceScalingConfig)).setter(ExecutionBlockConfiguration.setter(Builder::eksResourceScalingConfig)).constructor(EksResourceScalingConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksResourceScalingConfig").build()}).build();
    private static final SdkField<Route53HealthCheckConfiguration> ROUTE53_HEALTH_CHECK_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("route53HealthCheckConfig").getter(ExecutionBlockConfiguration.getter(ExecutionBlockConfiguration::route53HealthCheckConfig)).setter(ExecutionBlockConfiguration.setter(Builder::route53HealthCheckConfig)).constructor(Route53HealthCheckConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("route53HealthCheckConfig").build()}).build();
    private static final SdkField<DocumentDbConfiguration> DOCUMENT_DB_CONFIG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("documentDbConfig").getter(ExecutionBlockConfiguration.getter(ExecutionBlockConfiguration::documentDbConfig)).setter(ExecutionBlockConfiguration.setter(Builder::documentDbConfig)).constructor(DocumentDbConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("documentDbConfig").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOM_ACTION_LAMBDA_CONFIG_FIELD, EC2_ASG_CAPACITY_INCREASE_CONFIG_FIELD, EXECUTION_APPROVAL_CONFIG_FIELD, ARC_ROUTING_CONTROL_CONFIG_FIELD, GLOBAL_AURORA_CONFIG_FIELD, PARALLEL_CONFIG_FIELD, REGION_SWITCH_PLAN_CONFIG_FIELD, ECS_CAPACITY_INCREASE_CONFIG_FIELD, EKS_RESOURCE_SCALING_CONFIG_FIELD, ROUTE53_HEALTH_CHECK_CONFIG_FIELD, DOCUMENT_DB_CONFIG_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ExecutionBlockConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final CustomActionLambdaConfiguration customActionLambdaConfig;
    private final Ec2AsgCapacityIncreaseConfiguration ec2AsgCapacityIncreaseConfig;
    private final ExecutionApprovalConfiguration executionApprovalConfig;
    private final ArcRoutingControlConfiguration arcRoutingControlConfig;
    private final GlobalAuroraConfiguration globalAuroraConfig;
    private final ParallelExecutionBlockConfiguration parallelConfig;
    private final RegionSwitchPlanConfiguration regionSwitchPlanConfig;
    private final EcsCapacityIncreaseConfiguration ecsCapacityIncreaseConfig;
    private final EksResourceScalingConfiguration eksResourceScalingConfig;
    private final Route53HealthCheckConfiguration route53HealthCheckConfig;
    private final DocumentDbConfiguration documentDbConfig;
    private final Type type;

    private ExecutionBlockConfiguration(BuilderImpl builder) {
        this.customActionLambdaConfig = builder.customActionLambdaConfig;
        this.ec2AsgCapacityIncreaseConfig = builder.ec2AsgCapacityIncreaseConfig;
        this.executionApprovalConfig = builder.executionApprovalConfig;
        this.arcRoutingControlConfig = builder.arcRoutingControlConfig;
        this.globalAuroraConfig = builder.globalAuroraConfig;
        this.parallelConfig = builder.parallelConfig;
        this.regionSwitchPlanConfig = builder.regionSwitchPlanConfig;
        this.ecsCapacityIncreaseConfig = builder.ecsCapacityIncreaseConfig;
        this.eksResourceScalingConfig = builder.eksResourceScalingConfig;
        this.route53HealthCheckConfig = builder.route53HealthCheckConfig;
        this.documentDbConfig = builder.documentDbConfig;
        this.type = builder.type;
    }

    public final CustomActionLambdaConfiguration customActionLambdaConfig() {
        return this.customActionLambdaConfig;
    }

    public final Ec2AsgCapacityIncreaseConfiguration ec2AsgCapacityIncreaseConfig() {
        return this.ec2AsgCapacityIncreaseConfig;
    }

    public final ExecutionApprovalConfiguration executionApprovalConfig() {
        return this.executionApprovalConfig;
    }

    public final ArcRoutingControlConfiguration arcRoutingControlConfig() {
        return this.arcRoutingControlConfig;
    }

    public final GlobalAuroraConfiguration globalAuroraConfig() {
        return this.globalAuroraConfig;
    }

    public final ParallelExecutionBlockConfiguration parallelConfig() {
        return this.parallelConfig;
    }

    public final RegionSwitchPlanConfiguration regionSwitchPlanConfig() {
        return this.regionSwitchPlanConfig;
    }

    public final EcsCapacityIncreaseConfiguration ecsCapacityIncreaseConfig() {
        return this.ecsCapacityIncreaseConfig;
    }

    public final EksResourceScalingConfiguration eksResourceScalingConfig() {
        return this.eksResourceScalingConfig;
    }

    public final Route53HealthCheckConfiguration route53HealthCheckConfig() {
        return this.route53HealthCheckConfig;
    }

    public final DocumentDbConfiguration documentDbConfig() {
        return this.documentDbConfig;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.customActionLambdaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.ec2AsgCapacityIncreaseConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.executionApprovalConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.arcRoutingControlConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.globalAuroraConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.parallelConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.regionSwitchPlanConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.ecsCapacityIncreaseConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.eksResourceScalingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.route53HealthCheckConfig());
        hashCode = 31 * hashCode + Objects.hashCode(this.documentDbConfig());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionBlockConfiguration)) {
            return false;
        }
        ExecutionBlockConfiguration other = (ExecutionBlockConfiguration)obj;
        return Objects.equals(this.customActionLambdaConfig(), other.customActionLambdaConfig()) && Objects.equals(this.ec2AsgCapacityIncreaseConfig(), other.ec2AsgCapacityIncreaseConfig()) && Objects.equals(this.executionApprovalConfig(), other.executionApprovalConfig()) && Objects.equals(this.arcRoutingControlConfig(), other.arcRoutingControlConfig()) && Objects.equals(this.globalAuroraConfig(), other.globalAuroraConfig()) && Objects.equals(this.parallelConfig(), other.parallelConfig()) && Objects.equals(this.regionSwitchPlanConfig(), other.regionSwitchPlanConfig()) && Objects.equals(this.ecsCapacityIncreaseConfig(), other.ecsCapacityIncreaseConfig()) && Objects.equals(this.eksResourceScalingConfig(), other.eksResourceScalingConfig()) && Objects.equals(this.route53HealthCheckConfig(), other.route53HealthCheckConfig()) && Objects.equals(this.documentDbConfig(), other.documentDbConfig());
    }

    public final String toString() {
        return ToString.builder((String)"ExecutionBlockConfiguration").add("CustomActionLambdaConfig", (Object)this.customActionLambdaConfig()).add("Ec2AsgCapacityIncreaseConfig", (Object)this.ec2AsgCapacityIncreaseConfig()).add("ExecutionApprovalConfig", (Object)this.executionApprovalConfig()).add("ArcRoutingControlConfig", (Object)this.arcRoutingControlConfig()).add("GlobalAuroraConfig", (Object)this.globalAuroraConfig()).add("ParallelConfig", (Object)this.parallelConfig()).add("RegionSwitchPlanConfig", (Object)this.regionSwitchPlanConfig()).add("EcsCapacityIncreaseConfig", (Object)this.ecsCapacityIncreaseConfig()).add("EksResourceScalingConfig", (Object)this.eksResourceScalingConfig()).add("Route53HealthCheckConfig", (Object)this.route53HealthCheckConfig()).add("DocumentDbConfig", (Object)this.documentDbConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "customActionLambdaConfig": {
                return Optional.ofNullable(clazz.cast(this.customActionLambdaConfig()));
            }
            case "ec2AsgCapacityIncreaseConfig": {
                return Optional.ofNullable(clazz.cast(this.ec2AsgCapacityIncreaseConfig()));
            }
            case "executionApprovalConfig": {
                return Optional.ofNullable(clazz.cast(this.executionApprovalConfig()));
            }
            case "arcRoutingControlConfig": {
                return Optional.ofNullable(clazz.cast(this.arcRoutingControlConfig()));
            }
            case "globalAuroraConfig": {
                return Optional.ofNullable(clazz.cast(this.globalAuroraConfig()));
            }
            case "parallelConfig": {
                return Optional.ofNullable(clazz.cast(this.parallelConfig()));
            }
            case "regionSwitchPlanConfig": {
                return Optional.ofNullable(clazz.cast(this.regionSwitchPlanConfig()));
            }
            case "ecsCapacityIncreaseConfig": {
                return Optional.ofNullable(clazz.cast(this.ecsCapacityIncreaseConfig()));
            }
            case "eksResourceScalingConfig": {
                return Optional.ofNullable(clazz.cast(this.eksResourceScalingConfig()));
            }
            case "route53HealthCheckConfig": {
                return Optional.ofNullable(clazz.cast(this.route53HealthCheckConfig()));
            }
            case "documentDbConfig": {
                return Optional.ofNullable(clazz.cast(this.documentDbConfig()));
            }
        }
        return Optional.empty();
    }

    public static ExecutionBlockConfiguration fromCustomActionLambdaConfig(CustomActionLambdaConfiguration customActionLambdaConfig) {
        return (ExecutionBlockConfiguration)ExecutionBlockConfiguration.builder().customActionLambdaConfig(customActionLambdaConfig).build();
    }

    public static ExecutionBlockConfiguration fromCustomActionLambdaConfig(Consumer<CustomActionLambdaConfiguration.Builder> customActionLambdaConfig) {
        CustomActionLambdaConfiguration.Builder builder = CustomActionLambdaConfiguration.builder();
        customActionLambdaConfig.accept(builder);
        return ExecutionBlockConfiguration.fromCustomActionLambdaConfig((CustomActionLambdaConfiguration)builder.build());
    }

    public static ExecutionBlockConfiguration fromEc2AsgCapacityIncreaseConfig(Ec2AsgCapacityIncreaseConfiguration ec2AsgCapacityIncreaseConfig) {
        return (ExecutionBlockConfiguration)ExecutionBlockConfiguration.builder().ec2AsgCapacityIncreaseConfig(ec2AsgCapacityIncreaseConfig).build();
    }

    public static ExecutionBlockConfiguration fromEc2AsgCapacityIncreaseConfig(Consumer<Ec2AsgCapacityIncreaseConfiguration.Builder> ec2AsgCapacityIncreaseConfig) {
        Ec2AsgCapacityIncreaseConfiguration.Builder builder = Ec2AsgCapacityIncreaseConfiguration.builder();
        ec2AsgCapacityIncreaseConfig.accept(builder);
        return ExecutionBlockConfiguration.fromEc2AsgCapacityIncreaseConfig((Ec2AsgCapacityIncreaseConfiguration)builder.build());
    }

    public static ExecutionBlockConfiguration fromExecutionApprovalConfig(ExecutionApprovalConfiguration executionApprovalConfig) {
        return (ExecutionBlockConfiguration)ExecutionBlockConfiguration.builder().executionApprovalConfig(executionApprovalConfig).build();
    }

    public static ExecutionBlockConfiguration fromExecutionApprovalConfig(Consumer<ExecutionApprovalConfiguration.Builder> executionApprovalConfig) {
        ExecutionApprovalConfiguration.Builder builder = ExecutionApprovalConfiguration.builder();
        executionApprovalConfig.accept(builder);
        return ExecutionBlockConfiguration.fromExecutionApprovalConfig((ExecutionApprovalConfiguration)builder.build());
    }

    public static ExecutionBlockConfiguration fromArcRoutingControlConfig(ArcRoutingControlConfiguration arcRoutingControlConfig) {
        return (ExecutionBlockConfiguration)ExecutionBlockConfiguration.builder().arcRoutingControlConfig(arcRoutingControlConfig).build();
    }

    public static ExecutionBlockConfiguration fromArcRoutingControlConfig(Consumer<ArcRoutingControlConfiguration.Builder> arcRoutingControlConfig) {
        ArcRoutingControlConfiguration.Builder builder = ArcRoutingControlConfiguration.builder();
        arcRoutingControlConfig.accept(builder);
        return ExecutionBlockConfiguration.fromArcRoutingControlConfig((ArcRoutingControlConfiguration)builder.build());
    }

    public static ExecutionBlockConfiguration fromGlobalAuroraConfig(GlobalAuroraConfiguration globalAuroraConfig) {
        return (ExecutionBlockConfiguration)ExecutionBlockConfiguration.builder().globalAuroraConfig(globalAuroraConfig).build();
    }

    public static ExecutionBlockConfiguration fromGlobalAuroraConfig(Consumer<GlobalAuroraConfiguration.Builder> globalAuroraConfig) {
        GlobalAuroraConfiguration.Builder builder = GlobalAuroraConfiguration.builder();
        globalAuroraConfig.accept(builder);
        return ExecutionBlockConfiguration.fromGlobalAuroraConfig((GlobalAuroraConfiguration)builder.build());
    }

    public static ExecutionBlockConfiguration fromParallelConfig(ParallelExecutionBlockConfiguration parallelConfig) {
        return (ExecutionBlockConfiguration)ExecutionBlockConfiguration.builder().parallelConfig(parallelConfig).build();
    }

    public static ExecutionBlockConfiguration fromParallelConfig(Consumer<ParallelExecutionBlockConfiguration.Builder> parallelConfig) {
        ParallelExecutionBlockConfiguration.Builder builder = ParallelExecutionBlockConfiguration.builder();
        parallelConfig.accept(builder);
        return ExecutionBlockConfiguration.fromParallelConfig((ParallelExecutionBlockConfiguration)builder.build());
    }

    public static ExecutionBlockConfiguration fromRegionSwitchPlanConfig(RegionSwitchPlanConfiguration regionSwitchPlanConfig) {
        return (ExecutionBlockConfiguration)ExecutionBlockConfiguration.builder().regionSwitchPlanConfig(regionSwitchPlanConfig).build();
    }

    public static ExecutionBlockConfiguration fromRegionSwitchPlanConfig(Consumer<RegionSwitchPlanConfiguration.Builder> regionSwitchPlanConfig) {
        RegionSwitchPlanConfiguration.Builder builder = RegionSwitchPlanConfiguration.builder();
        regionSwitchPlanConfig.accept(builder);
        return ExecutionBlockConfiguration.fromRegionSwitchPlanConfig((RegionSwitchPlanConfiguration)builder.build());
    }

    public static ExecutionBlockConfiguration fromEcsCapacityIncreaseConfig(EcsCapacityIncreaseConfiguration ecsCapacityIncreaseConfig) {
        return (ExecutionBlockConfiguration)ExecutionBlockConfiguration.builder().ecsCapacityIncreaseConfig(ecsCapacityIncreaseConfig).build();
    }

    public static ExecutionBlockConfiguration fromEcsCapacityIncreaseConfig(Consumer<EcsCapacityIncreaseConfiguration.Builder> ecsCapacityIncreaseConfig) {
        EcsCapacityIncreaseConfiguration.Builder builder = EcsCapacityIncreaseConfiguration.builder();
        ecsCapacityIncreaseConfig.accept(builder);
        return ExecutionBlockConfiguration.fromEcsCapacityIncreaseConfig((EcsCapacityIncreaseConfiguration)builder.build());
    }

    public static ExecutionBlockConfiguration fromEksResourceScalingConfig(EksResourceScalingConfiguration eksResourceScalingConfig) {
        return (ExecutionBlockConfiguration)ExecutionBlockConfiguration.builder().eksResourceScalingConfig(eksResourceScalingConfig).build();
    }

    public static ExecutionBlockConfiguration fromEksResourceScalingConfig(Consumer<EksResourceScalingConfiguration.Builder> eksResourceScalingConfig) {
        EksResourceScalingConfiguration.Builder builder = EksResourceScalingConfiguration.builder();
        eksResourceScalingConfig.accept(builder);
        return ExecutionBlockConfiguration.fromEksResourceScalingConfig((EksResourceScalingConfiguration)builder.build());
    }

    public static ExecutionBlockConfiguration fromRoute53HealthCheckConfig(Route53HealthCheckConfiguration route53HealthCheckConfig) {
        return (ExecutionBlockConfiguration)ExecutionBlockConfiguration.builder().route53HealthCheckConfig(route53HealthCheckConfig).build();
    }

    public static ExecutionBlockConfiguration fromRoute53HealthCheckConfig(Consumer<Route53HealthCheckConfiguration.Builder> route53HealthCheckConfig) {
        Route53HealthCheckConfiguration.Builder builder = Route53HealthCheckConfiguration.builder();
        route53HealthCheckConfig.accept(builder);
        return ExecutionBlockConfiguration.fromRoute53HealthCheckConfig((Route53HealthCheckConfiguration)builder.build());
    }

    public static ExecutionBlockConfiguration fromDocumentDbConfig(DocumentDbConfiguration documentDbConfig) {
        return (ExecutionBlockConfiguration)ExecutionBlockConfiguration.builder().documentDbConfig(documentDbConfig).build();
    }

    public static ExecutionBlockConfiguration fromDocumentDbConfig(Consumer<DocumentDbConfiguration.Builder> documentDbConfig) {
        DocumentDbConfiguration.Builder builder = DocumentDbConfiguration.builder();
        documentDbConfig.accept(builder);
        return ExecutionBlockConfiguration.fromDocumentDbConfig((DocumentDbConfiguration)builder.build());
    }

    public Type type() {
        return this.type;
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("customActionLambdaConfig", CUSTOM_ACTION_LAMBDA_CONFIG_FIELD);
        map.put("ec2AsgCapacityIncreaseConfig", EC2_ASG_CAPACITY_INCREASE_CONFIG_FIELD);
        map.put("executionApprovalConfig", EXECUTION_APPROVAL_CONFIG_FIELD);
        map.put("arcRoutingControlConfig", ARC_ROUTING_CONTROL_CONFIG_FIELD);
        map.put("globalAuroraConfig", GLOBAL_AURORA_CONFIG_FIELD);
        map.put("parallelConfig", PARALLEL_CONFIG_FIELD);
        map.put("regionSwitchPlanConfig", REGION_SWITCH_PLAN_CONFIG_FIELD);
        map.put("ecsCapacityIncreaseConfig", ECS_CAPACITY_INCREASE_CONFIG_FIELD);
        map.put("eksResourceScalingConfig", EKS_RESOURCE_SCALING_CONFIG_FIELD);
        map.put("route53HealthCheckConfig", ROUTE53_HEALTH_CHECK_CONFIG_FIELD);
        map.put("documentDbConfig", DOCUMENT_DB_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecutionBlockConfiguration, T> g) {
        return obj -> g.apply((ExecutionBlockConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    public static enum Type {
        CUSTOM_ACTION_LAMBDA_CONFIG,
        EC2_ASG_CAPACITY_INCREASE_CONFIG,
        EXECUTION_APPROVAL_CONFIG,
        ARC_ROUTING_CONTROL_CONFIG,
        GLOBAL_AURORA_CONFIG,
        PARALLEL_CONFIG,
        REGION_SWITCH_PLAN_CONFIG,
        ECS_CAPACITY_INCREASE_CONFIG,
        EKS_RESOURCE_SCALING_CONFIG,
        ROUTE53_HEALTH_CHECK_CONFIG,
        DOCUMENT_DB_CONFIG,
        UNKNOWN_TO_SDK_VERSION;

    }

    static final class BuilderImpl
    implements Builder {
        private CustomActionLambdaConfiguration customActionLambdaConfig;
        private Ec2AsgCapacityIncreaseConfiguration ec2AsgCapacityIncreaseConfig;
        private ExecutionApprovalConfiguration executionApprovalConfig;
        private ArcRoutingControlConfiguration arcRoutingControlConfig;
        private GlobalAuroraConfiguration globalAuroraConfig;
        private ParallelExecutionBlockConfiguration parallelConfig;
        private RegionSwitchPlanConfiguration regionSwitchPlanConfig;
        private EcsCapacityIncreaseConfiguration ecsCapacityIncreaseConfig;
        private EksResourceScalingConfiguration eksResourceScalingConfig;
        private Route53HealthCheckConfiguration route53HealthCheckConfig;
        private DocumentDbConfiguration documentDbConfig;
        private Type type = Type.UNKNOWN_TO_SDK_VERSION;
        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionBlockConfiguration model) {
            this.customActionLambdaConfig(model.customActionLambdaConfig);
            this.ec2AsgCapacityIncreaseConfig(model.ec2AsgCapacityIncreaseConfig);
            this.executionApprovalConfig(model.executionApprovalConfig);
            this.arcRoutingControlConfig(model.arcRoutingControlConfig);
            this.globalAuroraConfig(model.globalAuroraConfig);
            this.parallelConfig(model.parallelConfig);
            this.regionSwitchPlanConfig(model.regionSwitchPlanConfig);
            this.ecsCapacityIncreaseConfig(model.ecsCapacityIncreaseConfig);
            this.eksResourceScalingConfig(model.eksResourceScalingConfig);
            this.route53HealthCheckConfig(model.route53HealthCheckConfig);
            this.documentDbConfig(model.documentDbConfig);
        }

        public final CustomActionLambdaConfiguration.Builder getCustomActionLambdaConfig() {
            return this.customActionLambdaConfig != null ? this.customActionLambdaConfig.toBuilder() : null;
        }

        public final void setCustomActionLambdaConfig(CustomActionLambdaConfiguration.BuilderImpl customActionLambdaConfig) {
            CustomActionLambdaConfiguration oldValue = this.customActionLambdaConfig;
            this.customActionLambdaConfig = customActionLambdaConfig != null ? customActionLambdaConfig.build() : null;
            this.handleUnionValueChange(Type.CUSTOM_ACTION_LAMBDA_CONFIG, oldValue, this.customActionLambdaConfig);
        }

        @Override
        public final Builder customActionLambdaConfig(CustomActionLambdaConfiguration customActionLambdaConfig) {
            CustomActionLambdaConfiguration oldValue = this.customActionLambdaConfig;
            this.customActionLambdaConfig = customActionLambdaConfig;
            this.handleUnionValueChange(Type.CUSTOM_ACTION_LAMBDA_CONFIG, oldValue, this.customActionLambdaConfig);
            return this;
        }

        public final Ec2AsgCapacityIncreaseConfiguration.Builder getEc2AsgCapacityIncreaseConfig() {
            return this.ec2AsgCapacityIncreaseConfig != null ? this.ec2AsgCapacityIncreaseConfig.toBuilder() : null;
        }

        public final void setEc2AsgCapacityIncreaseConfig(Ec2AsgCapacityIncreaseConfiguration.BuilderImpl ec2AsgCapacityIncreaseConfig) {
            Ec2AsgCapacityIncreaseConfiguration oldValue = this.ec2AsgCapacityIncreaseConfig;
            this.ec2AsgCapacityIncreaseConfig = ec2AsgCapacityIncreaseConfig != null ? ec2AsgCapacityIncreaseConfig.build() : null;
            this.handleUnionValueChange(Type.EC2_ASG_CAPACITY_INCREASE_CONFIG, oldValue, this.ec2AsgCapacityIncreaseConfig);
        }

        @Override
        public final Builder ec2AsgCapacityIncreaseConfig(Ec2AsgCapacityIncreaseConfiguration ec2AsgCapacityIncreaseConfig) {
            Ec2AsgCapacityIncreaseConfiguration oldValue = this.ec2AsgCapacityIncreaseConfig;
            this.ec2AsgCapacityIncreaseConfig = ec2AsgCapacityIncreaseConfig;
            this.handleUnionValueChange(Type.EC2_ASG_CAPACITY_INCREASE_CONFIG, oldValue, this.ec2AsgCapacityIncreaseConfig);
            return this;
        }

        public final ExecutionApprovalConfiguration.Builder getExecutionApprovalConfig() {
            return this.executionApprovalConfig != null ? this.executionApprovalConfig.toBuilder() : null;
        }

        public final void setExecutionApprovalConfig(ExecutionApprovalConfiguration.BuilderImpl executionApprovalConfig) {
            ExecutionApprovalConfiguration oldValue = this.executionApprovalConfig;
            this.executionApprovalConfig = executionApprovalConfig != null ? executionApprovalConfig.build() : null;
            this.handleUnionValueChange(Type.EXECUTION_APPROVAL_CONFIG, oldValue, this.executionApprovalConfig);
        }

        @Override
        public final Builder executionApprovalConfig(ExecutionApprovalConfiguration executionApprovalConfig) {
            ExecutionApprovalConfiguration oldValue = this.executionApprovalConfig;
            this.executionApprovalConfig = executionApprovalConfig;
            this.handleUnionValueChange(Type.EXECUTION_APPROVAL_CONFIG, oldValue, this.executionApprovalConfig);
            return this;
        }

        public final ArcRoutingControlConfiguration.Builder getArcRoutingControlConfig() {
            return this.arcRoutingControlConfig != null ? this.arcRoutingControlConfig.toBuilder() : null;
        }

        public final void setArcRoutingControlConfig(ArcRoutingControlConfiguration.BuilderImpl arcRoutingControlConfig) {
            ArcRoutingControlConfiguration oldValue = this.arcRoutingControlConfig;
            this.arcRoutingControlConfig = arcRoutingControlConfig != null ? arcRoutingControlConfig.build() : null;
            this.handleUnionValueChange(Type.ARC_ROUTING_CONTROL_CONFIG, oldValue, this.arcRoutingControlConfig);
        }

        @Override
        public final Builder arcRoutingControlConfig(ArcRoutingControlConfiguration arcRoutingControlConfig) {
            ArcRoutingControlConfiguration oldValue = this.arcRoutingControlConfig;
            this.arcRoutingControlConfig = arcRoutingControlConfig;
            this.handleUnionValueChange(Type.ARC_ROUTING_CONTROL_CONFIG, oldValue, this.arcRoutingControlConfig);
            return this;
        }

        public final GlobalAuroraConfiguration.Builder getGlobalAuroraConfig() {
            return this.globalAuroraConfig != null ? this.globalAuroraConfig.toBuilder() : null;
        }

        public final void setGlobalAuroraConfig(GlobalAuroraConfiguration.BuilderImpl globalAuroraConfig) {
            GlobalAuroraConfiguration oldValue = this.globalAuroraConfig;
            this.globalAuroraConfig = globalAuroraConfig != null ? globalAuroraConfig.build() : null;
            this.handleUnionValueChange(Type.GLOBAL_AURORA_CONFIG, oldValue, this.globalAuroraConfig);
        }

        @Override
        public final Builder globalAuroraConfig(GlobalAuroraConfiguration globalAuroraConfig) {
            GlobalAuroraConfiguration oldValue = this.globalAuroraConfig;
            this.globalAuroraConfig = globalAuroraConfig;
            this.handleUnionValueChange(Type.GLOBAL_AURORA_CONFIG, oldValue, this.globalAuroraConfig);
            return this;
        }

        public final ParallelExecutionBlockConfiguration.Builder getParallelConfig() {
            return this.parallelConfig != null ? this.parallelConfig.toBuilder() : null;
        }

        public final void setParallelConfig(ParallelExecutionBlockConfiguration.BuilderImpl parallelConfig) {
            ParallelExecutionBlockConfiguration oldValue = this.parallelConfig;
            this.parallelConfig = parallelConfig != null ? parallelConfig.build() : null;
            this.handleUnionValueChange(Type.PARALLEL_CONFIG, oldValue, this.parallelConfig);
        }

        @Override
        public final Builder parallelConfig(ParallelExecutionBlockConfiguration parallelConfig) {
            ParallelExecutionBlockConfiguration oldValue = this.parallelConfig;
            this.parallelConfig = parallelConfig;
            this.handleUnionValueChange(Type.PARALLEL_CONFIG, oldValue, this.parallelConfig);
            return this;
        }

        public final RegionSwitchPlanConfiguration.Builder getRegionSwitchPlanConfig() {
            return this.regionSwitchPlanConfig != null ? this.regionSwitchPlanConfig.toBuilder() : null;
        }

        public final void setRegionSwitchPlanConfig(RegionSwitchPlanConfiguration.BuilderImpl regionSwitchPlanConfig) {
            RegionSwitchPlanConfiguration oldValue = this.regionSwitchPlanConfig;
            this.regionSwitchPlanConfig = regionSwitchPlanConfig != null ? regionSwitchPlanConfig.build() : null;
            this.handleUnionValueChange(Type.REGION_SWITCH_PLAN_CONFIG, oldValue, this.regionSwitchPlanConfig);
        }

        @Override
        public final Builder regionSwitchPlanConfig(RegionSwitchPlanConfiguration regionSwitchPlanConfig) {
            RegionSwitchPlanConfiguration oldValue = this.regionSwitchPlanConfig;
            this.regionSwitchPlanConfig = regionSwitchPlanConfig;
            this.handleUnionValueChange(Type.REGION_SWITCH_PLAN_CONFIG, oldValue, this.regionSwitchPlanConfig);
            return this;
        }

        public final EcsCapacityIncreaseConfiguration.Builder getEcsCapacityIncreaseConfig() {
            return this.ecsCapacityIncreaseConfig != null ? this.ecsCapacityIncreaseConfig.toBuilder() : null;
        }

        public final void setEcsCapacityIncreaseConfig(EcsCapacityIncreaseConfiguration.BuilderImpl ecsCapacityIncreaseConfig) {
            EcsCapacityIncreaseConfiguration oldValue = this.ecsCapacityIncreaseConfig;
            this.ecsCapacityIncreaseConfig = ecsCapacityIncreaseConfig != null ? ecsCapacityIncreaseConfig.build() : null;
            this.handleUnionValueChange(Type.ECS_CAPACITY_INCREASE_CONFIG, oldValue, this.ecsCapacityIncreaseConfig);
        }

        @Override
        public final Builder ecsCapacityIncreaseConfig(EcsCapacityIncreaseConfiguration ecsCapacityIncreaseConfig) {
            EcsCapacityIncreaseConfiguration oldValue = this.ecsCapacityIncreaseConfig;
            this.ecsCapacityIncreaseConfig = ecsCapacityIncreaseConfig;
            this.handleUnionValueChange(Type.ECS_CAPACITY_INCREASE_CONFIG, oldValue, this.ecsCapacityIncreaseConfig);
            return this;
        }

        public final EksResourceScalingConfiguration.Builder getEksResourceScalingConfig() {
            return this.eksResourceScalingConfig != null ? this.eksResourceScalingConfig.toBuilder() : null;
        }

        public final void setEksResourceScalingConfig(EksResourceScalingConfiguration.BuilderImpl eksResourceScalingConfig) {
            EksResourceScalingConfiguration oldValue = this.eksResourceScalingConfig;
            this.eksResourceScalingConfig = eksResourceScalingConfig != null ? eksResourceScalingConfig.build() : null;
            this.handleUnionValueChange(Type.EKS_RESOURCE_SCALING_CONFIG, oldValue, this.eksResourceScalingConfig);
        }

        @Override
        public final Builder eksResourceScalingConfig(EksResourceScalingConfiguration eksResourceScalingConfig) {
            EksResourceScalingConfiguration oldValue = this.eksResourceScalingConfig;
            this.eksResourceScalingConfig = eksResourceScalingConfig;
            this.handleUnionValueChange(Type.EKS_RESOURCE_SCALING_CONFIG, oldValue, this.eksResourceScalingConfig);
            return this;
        }

        public final Route53HealthCheckConfiguration.Builder getRoute53HealthCheckConfig() {
            return this.route53HealthCheckConfig != null ? this.route53HealthCheckConfig.toBuilder() : null;
        }

        public final void setRoute53HealthCheckConfig(Route53HealthCheckConfiguration.BuilderImpl route53HealthCheckConfig) {
            Route53HealthCheckConfiguration oldValue = this.route53HealthCheckConfig;
            this.route53HealthCheckConfig = route53HealthCheckConfig != null ? route53HealthCheckConfig.build() : null;
            this.handleUnionValueChange(Type.ROUTE53_HEALTH_CHECK_CONFIG, oldValue, this.route53HealthCheckConfig);
        }

        @Override
        public final Builder route53HealthCheckConfig(Route53HealthCheckConfiguration route53HealthCheckConfig) {
            Route53HealthCheckConfiguration oldValue = this.route53HealthCheckConfig;
            this.route53HealthCheckConfig = route53HealthCheckConfig;
            this.handleUnionValueChange(Type.ROUTE53_HEALTH_CHECK_CONFIG, oldValue, this.route53HealthCheckConfig);
            return this;
        }

        public final DocumentDbConfiguration.Builder getDocumentDbConfig() {
            return this.documentDbConfig != null ? this.documentDbConfig.toBuilder() : null;
        }

        public final void setDocumentDbConfig(DocumentDbConfiguration.BuilderImpl documentDbConfig) {
            DocumentDbConfiguration oldValue = this.documentDbConfig;
            this.documentDbConfig = documentDbConfig != null ? documentDbConfig.build() : null;
            this.handleUnionValueChange(Type.DOCUMENT_DB_CONFIG, oldValue, this.documentDbConfig);
        }

        @Override
        public final Builder documentDbConfig(DocumentDbConfiguration documentDbConfig) {
            DocumentDbConfiguration oldValue = this.documentDbConfig;
            this.documentDbConfig = documentDbConfig;
            this.handleUnionValueChange(Type.DOCUMENT_DB_CONFIG, oldValue, this.documentDbConfig);
            return this;
        }

        public ExecutionBlockConfiguration build() {
            return new ExecutionBlockConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                this.setTypes.remove((Object)type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                this.setTypes.add(type);
            }
            this.type = this.setTypes.size() == 1 ? this.setTypes.iterator().next() : (this.setTypes.isEmpty() ? Type.UNKNOWN_TO_SDK_VERSION : null);
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ExecutionBlockConfiguration> {
        public Builder customActionLambdaConfig(CustomActionLambdaConfiguration var1);

        default public Builder customActionLambdaConfig(Consumer<CustomActionLambdaConfiguration.Builder> customActionLambdaConfig) {
            return this.customActionLambdaConfig((CustomActionLambdaConfiguration)((CustomActionLambdaConfiguration.Builder)CustomActionLambdaConfiguration.builder().applyMutation(customActionLambdaConfig)).build());
        }

        public Builder ec2AsgCapacityIncreaseConfig(Ec2AsgCapacityIncreaseConfiguration var1);

        default public Builder ec2AsgCapacityIncreaseConfig(Consumer<Ec2AsgCapacityIncreaseConfiguration.Builder> ec2AsgCapacityIncreaseConfig) {
            return this.ec2AsgCapacityIncreaseConfig((Ec2AsgCapacityIncreaseConfiguration)((Ec2AsgCapacityIncreaseConfiguration.Builder)Ec2AsgCapacityIncreaseConfiguration.builder().applyMutation(ec2AsgCapacityIncreaseConfig)).build());
        }

        public Builder executionApprovalConfig(ExecutionApprovalConfiguration var1);

        default public Builder executionApprovalConfig(Consumer<ExecutionApprovalConfiguration.Builder> executionApprovalConfig) {
            return this.executionApprovalConfig((ExecutionApprovalConfiguration)((ExecutionApprovalConfiguration.Builder)ExecutionApprovalConfiguration.builder().applyMutation(executionApprovalConfig)).build());
        }

        public Builder arcRoutingControlConfig(ArcRoutingControlConfiguration var1);

        default public Builder arcRoutingControlConfig(Consumer<ArcRoutingControlConfiguration.Builder> arcRoutingControlConfig) {
            return this.arcRoutingControlConfig((ArcRoutingControlConfiguration)((ArcRoutingControlConfiguration.Builder)ArcRoutingControlConfiguration.builder().applyMutation(arcRoutingControlConfig)).build());
        }

        public Builder globalAuroraConfig(GlobalAuroraConfiguration var1);

        default public Builder globalAuroraConfig(Consumer<GlobalAuroraConfiguration.Builder> globalAuroraConfig) {
            return this.globalAuroraConfig((GlobalAuroraConfiguration)((GlobalAuroraConfiguration.Builder)GlobalAuroraConfiguration.builder().applyMutation(globalAuroraConfig)).build());
        }

        public Builder parallelConfig(ParallelExecutionBlockConfiguration var1);

        default public Builder parallelConfig(Consumer<ParallelExecutionBlockConfiguration.Builder> parallelConfig) {
            return this.parallelConfig((ParallelExecutionBlockConfiguration)((ParallelExecutionBlockConfiguration.Builder)ParallelExecutionBlockConfiguration.builder().applyMutation(parallelConfig)).build());
        }

        public Builder regionSwitchPlanConfig(RegionSwitchPlanConfiguration var1);

        default public Builder regionSwitchPlanConfig(Consumer<RegionSwitchPlanConfiguration.Builder> regionSwitchPlanConfig) {
            return this.regionSwitchPlanConfig((RegionSwitchPlanConfiguration)((RegionSwitchPlanConfiguration.Builder)RegionSwitchPlanConfiguration.builder().applyMutation(regionSwitchPlanConfig)).build());
        }

        public Builder ecsCapacityIncreaseConfig(EcsCapacityIncreaseConfiguration var1);

        default public Builder ecsCapacityIncreaseConfig(Consumer<EcsCapacityIncreaseConfiguration.Builder> ecsCapacityIncreaseConfig) {
            return this.ecsCapacityIncreaseConfig((EcsCapacityIncreaseConfiguration)((EcsCapacityIncreaseConfiguration.Builder)EcsCapacityIncreaseConfiguration.builder().applyMutation(ecsCapacityIncreaseConfig)).build());
        }

        public Builder eksResourceScalingConfig(EksResourceScalingConfiguration var1);

        default public Builder eksResourceScalingConfig(Consumer<EksResourceScalingConfiguration.Builder> eksResourceScalingConfig) {
            return this.eksResourceScalingConfig((EksResourceScalingConfiguration)((EksResourceScalingConfiguration.Builder)EksResourceScalingConfiguration.builder().applyMutation(eksResourceScalingConfig)).build());
        }

        public Builder route53HealthCheckConfig(Route53HealthCheckConfiguration var1);

        default public Builder route53HealthCheckConfig(Consumer<Route53HealthCheckConfiguration.Builder> route53HealthCheckConfig) {
            return this.route53HealthCheckConfig((Route53HealthCheckConfiguration)((Route53HealthCheckConfiguration.Builder)Route53HealthCheckConfiguration.builder().applyMutation(route53HealthCheckConfig)).build());
        }

        public Builder documentDbConfig(DocumentDbConfiguration var1);

        default public Builder documentDbConfig(Consumer<DocumentDbConfiguration.Builder> documentDbConfig) {
            return this.documentDbConfig((DocumentDbConfiguration)((DocumentDbConfiguration.Builder)DocumentDbConfiguration.builder().applyMutation(documentDbConfig)).build());
        }
    }
}

