/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a condition that must be met for a trigger to fire.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TriggerCondition implements SdkPojo, Serializable,
        ToCopyableBuilder<TriggerCondition.Builder, TriggerCondition> {
    private static final SdkField<String> ASSOCIATED_ALARM_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("associatedAlarmName").getter(getter(TriggerCondition::associatedAlarmName))
            .setter(setter(Builder::associatedAlarmName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedAlarmName").build())
            .build();

    private static final SdkField<String> CONDITION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("condition").getter(getter(TriggerCondition::conditionAsString)).setter(setter(Builder::condition))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("condition").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSOCIATED_ALARM_NAME_FIELD,
            CONDITION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String associatedAlarmName;

    private final String condition;

    private TriggerCondition(BuilderImpl builder) {
        this.associatedAlarmName = builder.associatedAlarmName;
        this.condition = builder.condition;
    }

    /**
     * <p>
     * The name of the CloudWatch alarm associated with the condition.
     * </p>
     * 
     * @return The name of the CloudWatch alarm associated with the condition.
     */
    public final String associatedAlarmName() {
        return associatedAlarmName;
    }

    /**
     * <p>
     * The condition that must be met. Valid values include ALARM and OK.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #condition} will
     * return {@link AlarmCondition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #conditionAsString}.
     * </p>
     * 
     * @return The condition that must be met. Valid values include ALARM and OK.
     * @see AlarmCondition
     */
    public final AlarmCondition condition() {
        return AlarmCondition.fromValue(condition);
    }

    /**
     * <p>
     * The condition that must be met. Valid values include ALARM and OK.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #condition} will
     * return {@link AlarmCondition#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #conditionAsString}.
     * </p>
     * 
     * @return The condition that must be met. Valid values include ALARM and OK.
     * @see AlarmCondition
     */
    public final String conditionAsString() {
        return condition;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(associatedAlarmName());
        hashCode = 31 * hashCode + Objects.hashCode(conditionAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TriggerCondition)) {
            return false;
        }
        TriggerCondition other = (TriggerCondition) obj;
        return Objects.equals(associatedAlarmName(), other.associatedAlarmName())
                && Objects.equals(conditionAsString(), other.conditionAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TriggerCondition").add("AssociatedAlarmName", associatedAlarmName())
                .add("Condition", conditionAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "associatedAlarmName":
            return Optional.ofNullable(clazz.cast(associatedAlarmName()));
        case "condition":
            return Optional.ofNullable(clazz.cast(conditionAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("associatedAlarmName", ASSOCIATED_ALARM_NAME_FIELD);
        map.put("condition", CONDITION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TriggerCondition, T> g) {
        return obj -> g.apply((TriggerCondition) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TriggerCondition> {
        /**
         * <p>
         * The name of the CloudWatch alarm associated with the condition.
         * </p>
         * 
         * @param associatedAlarmName
         *        The name of the CloudWatch alarm associated with the condition.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedAlarmName(String associatedAlarmName);

        /**
         * <p>
         * The condition that must be met. Valid values include ALARM and OK.
         * </p>
         * 
         * @param condition
         *        The condition that must be met. Valid values include ALARM and OK.
         * @see AlarmCondition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlarmCondition
         */
        Builder condition(String condition);

        /**
         * <p>
         * The condition that must be met. Valid values include ALARM and OK.
         * </p>
         * 
         * @param condition
         *        The condition that must be met. Valid values include ALARM and OK.
         * @see AlarmCondition
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AlarmCondition
         */
        Builder condition(AlarmCondition condition);
    }

    static final class BuilderImpl implements Builder {
        private String associatedAlarmName;

        private String condition;

        private BuilderImpl() {
        }

        private BuilderImpl(TriggerCondition model) {
            associatedAlarmName(model.associatedAlarmName);
            condition(model.condition);
        }

        public final String getAssociatedAlarmName() {
            return associatedAlarmName;
        }

        public final void setAssociatedAlarmName(String associatedAlarmName) {
            this.associatedAlarmName = associatedAlarmName;
        }

        @Override
        public final Builder associatedAlarmName(String associatedAlarmName) {
            this.associatedAlarmName = associatedAlarmName;
            return this;
        }

        public final String getCondition() {
            return condition;
        }

        public final void setCondition(String condition) {
            this.condition = condition;
        }

        @Override
        public final Builder condition(String condition) {
            this.condition = condition;
            return this;
        }

        @Override
        public final Builder condition(AlarmCondition condition) {
            this.condition(condition == null ? null : condition.toString());
            return this;
        }

        @Override
        public TriggerCondition build() {
            return new TriggerCondition(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
