/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The service for a cross account role.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Service implements SdkPojo, Serializable, ToCopyableBuilder<Service.Builder, Service> {
    private static final SdkField<String> CROSS_ACCOUNT_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("crossAccountRole").getter(getter(Service::crossAccountRole)).setter(setter(Builder::crossAccountRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("crossAccountRole").build()).build();

    private static final SdkField<String> EXTERNAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("externalId").getter(getter(Service::externalId)).setter(setter(Builder::externalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("externalId").build()).build();

    private static final SdkField<String> CLUSTER_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("clusterArn").getter(getter(Service::clusterArn)).setter(setter(Builder::clusterArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("clusterArn").build()).build();

    private static final SdkField<String> SERVICE_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("serviceArn").getter(getter(Service::serviceArn)).setter(setter(Builder::serviceArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceArn").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CROSS_ACCOUNT_ROLE_FIELD,
            EXTERNAL_ID_FIELD, CLUSTER_ARN_FIELD, SERVICE_ARN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String crossAccountRole;

    private final String externalId;

    private final String clusterArn;

    private final String serviceArn;

    private Service(BuilderImpl builder) {
        this.crossAccountRole = builder.crossAccountRole;
        this.externalId = builder.externalId;
        this.clusterArn = builder.clusterArn;
        this.serviceArn = builder.serviceArn;
    }

    /**
     * <p>
     * The cross account role for a service.
     * </p>
     * 
     * @return The cross account role for a service.
     */
    public final String crossAccountRole() {
        return crossAccountRole;
    }

    /**
     * <p>
     * The external ID (secret key) for the service.
     * </p>
     * 
     * @return The external ID (secret key) for the service.
     */
    public final String externalId() {
        return externalId;
    }

    /**
     * <p>
     * The cluster Amazon Resource Name (ARN) for a service.
     * </p>
     * 
     * @return The cluster Amazon Resource Name (ARN) for a service.
     */
    public final String clusterArn() {
        return clusterArn;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) for a service.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) for a service.
     */
    public final String serviceArn() {
        return serviceArn;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(crossAccountRole());
        hashCode = 31 * hashCode + Objects.hashCode(externalId());
        hashCode = 31 * hashCode + Objects.hashCode(clusterArn());
        hashCode = 31 * hashCode + Objects.hashCode(serviceArn());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Service)) {
            return false;
        }
        Service other = (Service) obj;
        return Objects.equals(crossAccountRole(), other.crossAccountRole()) && Objects.equals(externalId(), other.externalId())
                && Objects.equals(clusterArn(), other.clusterArn()) && Objects.equals(serviceArn(), other.serviceArn());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Service").add("CrossAccountRole", crossAccountRole()).add("ExternalId", externalId())
                .add("ClusterArn", clusterArn()).add("ServiceArn", serviceArn()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "crossAccountRole":
            return Optional.ofNullable(clazz.cast(crossAccountRole()));
        case "externalId":
            return Optional.ofNullable(clazz.cast(externalId()));
        case "clusterArn":
            return Optional.ofNullable(clazz.cast(clusterArn()));
        case "serviceArn":
            return Optional.ofNullable(clazz.cast(serviceArn()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("crossAccountRole", CROSS_ACCOUNT_ROLE_FIELD);
        map.put("externalId", EXTERNAL_ID_FIELD);
        map.put("clusterArn", CLUSTER_ARN_FIELD);
        map.put("serviceArn", SERVICE_ARN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Service, T> g) {
        return obj -> g.apply((Service) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Service> {
        /**
         * <p>
         * The cross account role for a service.
         * </p>
         * 
         * @param crossAccountRole
         *        The cross account role for a service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder crossAccountRole(String crossAccountRole);

        /**
         * <p>
         * The external ID (secret key) for the service.
         * </p>
         * 
         * @param externalId
         *        The external ID (secret key) for the service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder externalId(String externalId);

        /**
         * <p>
         * The cluster Amazon Resource Name (ARN) for a service.
         * </p>
         * 
         * @param clusterArn
         *        The cluster Amazon Resource Name (ARN) for a service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clusterArn(String clusterArn);

        /**
         * <p>
         * The Amazon Resource Name (ARN) for a service.
         * </p>
         * 
         * @param serviceArn
         *        The Amazon Resource Name (ARN) for a service.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceArn(String serviceArn);
    }

    static final class BuilderImpl implements Builder {
        private String crossAccountRole;

        private String externalId;

        private String clusterArn;

        private String serviceArn;

        private BuilderImpl() {
        }

        private BuilderImpl(Service model) {
            crossAccountRole(model.crossAccountRole);
            externalId(model.externalId);
            clusterArn(model.clusterArn);
            serviceArn(model.serviceArn);
        }

        public final String getCrossAccountRole() {
            return crossAccountRole;
        }

        public final void setCrossAccountRole(String crossAccountRole) {
            this.crossAccountRole = crossAccountRole;
        }

        @Override
        public final Builder crossAccountRole(String crossAccountRole) {
            this.crossAccountRole = crossAccountRole;
            return this;
        }

        public final String getExternalId() {
            return externalId;
        }

        public final void setExternalId(String externalId) {
            this.externalId = externalId;
        }

        @Override
        public final Builder externalId(String externalId) {
            this.externalId = externalId;
            return this;
        }

        public final String getClusterArn() {
            return clusterArn;
        }

        public final void setClusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
        }

        @Override
        public final Builder clusterArn(String clusterArn) {
            this.clusterArn = clusterArn;
            return this;
        }

        public final String getServiceArn() {
            return serviceArn;
        }

        public final void setServiceArn(String serviceArn) {
            this.serviceArn = serviceArn;
        }

        @Override
        public final Builder serviceArn(String serviceArn) {
            this.serviceArn = serviceArn;
            return this;
        }

        @Override
        public Service build() {
            return new Service(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
