/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;

@Generated("software.amazon.awssdk:codegen")
final class Route53HealthCheckListCopier {
    static List<Route53HealthCheck> copy(Collection<? extends Route53HealthCheck> route53HealthCheckListParam) {
        List<Route53HealthCheck> list;
        if (route53HealthCheckListParam == null || route53HealthCheckListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Route53HealthCheck> modifiableList = new ArrayList<>(route53HealthCheckListParam.size());
            route53HealthCheckListParam.forEach(entry -> {
                modifiableList.add(entry);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Route53HealthCheck> copyFromBuilder(Collection<? extends Route53HealthCheck.Builder> route53HealthCheckListParam) {
        List<Route53HealthCheck> list;
        if (route53HealthCheckListParam == null || route53HealthCheckListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Route53HealthCheck> modifiableList = new ArrayList<>(route53HealthCheckListParam.size());
            route53HealthCheckListParam.forEach(entry -> {
                Route53HealthCheck member = entry == null ? null : entry.build();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }

    static List<Route53HealthCheck.Builder> copyToBuilder(Collection<? extends Route53HealthCheck> route53HealthCheckListParam) {
        List<Route53HealthCheck.Builder> list;
        if (route53HealthCheckListParam == null || route53HealthCheckListParam instanceof SdkAutoConstructList) {
            list = DefaultSdkAutoConstructList.getInstance();
        } else {
            List<Route53HealthCheck.Builder> modifiableList = new ArrayList<>(route53HealthCheckListParam.size());
            route53HealthCheckListParam.forEach(entry -> {
                Route53HealthCheck.Builder member = entry == null ? null : entry.toBuilder();
                modifiableList.add(member);
            });
            list = Collections.unmodifiableList(modifiableList);
        }
        return list;
    }
}
