/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.arcregionswitch.model.MinimalWorkflow;
import software.amazon.awssdk.services.arcregionswitch.model.ResourceWarningStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ResourceWarning
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ResourceWarning> {
    private static final SdkField<MinimalWorkflow> WORKFLOW_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("workflow").getter(ResourceWarning.getter(ResourceWarning::workflow)).setter(ResourceWarning.setter(Builder::workflow)).constructor(MinimalWorkflow::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflow").build()}).build();
    private static final SdkField<String> VERSION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("version").getter(ResourceWarning.getter(ResourceWarning::version)).setter(ResourceWarning.setter(Builder::version)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("version").build()}).build();
    private static final SdkField<String> STEP_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("stepName").getter(ResourceWarning.getter(ResourceWarning::stepName)).setter(ResourceWarning.setter(Builder::stepName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepName").build()}).build();
    private static final SdkField<String> RESOURCE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("resourceArn").getter(ResourceWarning.getter(ResourceWarning::resourceArn)).setter(ResourceWarning.setter(Builder::resourceArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceArn").build()}).build();
    private static final SdkField<String> WARNING_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("warningStatus").getter(ResourceWarning.getter(ResourceWarning::warningStatusAsString)).setter(ResourceWarning.setter(Builder::warningStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warningStatus").build()}).build();
    private static final SdkField<Instant> WARNING_UPDATED_TIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("warningUpdatedTime").getter(ResourceWarning.getter(ResourceWarning::warningUpdatedTime)).setter(ResourceWarning.setter(Builder::warningUpdatedTime)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warningUpdatedTime").build()}).build();
    private static final SdkField<String> WARNING_MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("warningMessage").getter(ResourceWarning.getter(ResourceWarning::warningMessage)).setter(ResourceWarning.setter(Builder::warningMessage)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("warningMessage").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKFLOW_FIELD, VERSION_FIELD, STEP_NAME_FIELD, RESOURCE_ARN_FIELD, WARNING_STATUS_FIELD, WARNING_UPDATED_TIME_FIELD, WARNING_MESSAGE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ResourceWarning.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final MinimalWorkflow workflow;
    private final String version;
    private final String stepName;
    private final String resourceArn;
    private final String warningStatus;
    private final Instant warningUpdatedTime;
    private final String warningMessage;

    private ResourceWarning(BuilderImpl builder) {
        this.workflow = builder.workflow;
        this.version = builder.version;
        this.stepName = builder.stepName;
        this.resourceArn = builder.resourceArn;
        this.warningStatus = builder.warningStatus;
        this.warningUpdatedTime = builder.warningUpdatedTime;
        this.warningMessage = builder.warningMessage;
    }

    public final MinimalWorkflow workflow() {
        return this.workflow;
    }

    public final String version() {
        return this.version;
    }

    public final String stepName() {
        return this.stepName;
    }

    public final String resourceArn() {
        return this.resourceArn;
    }

    public final ResourceWarningStatus warningStatus() {
        return ResourceWarningStatus.fromValue(this.warningStatus);
    }

    public final String warningStatusAsString() {
        return this.warningStatus;
    }

    public final Instant warningUpdatedTime() {
        return this.warningUpdatedTime;
    }

    public final String warningMessage() {
        return this.warningMessage;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workflow());
        hashCode = 31 * hashCode + Objects.hashCode(this.version());
        hashCode = 31 * hashCode + Objects.hashCode(this.stepName());
        hashCode = 31 * hashCode + Objects.hashCode(this.resourceArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.warningStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.warningUpdatedTime());
        hashCode = 31 * hashCode + Objects.hashCode(this.warningMessage());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ResourceWarning)) {
            return false;
        }
        ResourceWarning other = (ResourceWarning)obj;
        return Objects.equals(this.workflow(), other.workflow()) && Objects.equals(this.version(), other.version()) && Objects.equals(this.stepName(), other.stepName()) && Objects.equals(this.resourceArn(), other.resourceArn()) && Objects.equals(this.warningStatusAsString(), other.warningStatusAsString()) && Objects.equals(this.warningUpdatedTime(), other.warningUpdatedTime()) && Objects.equals(this.warningMessage(), other.warningMessage());
    }

    public final String toString() {
        return ToString.builder((String)"ResourceWarning").add("Workflow", (Object)this.workflow()).add("Version", (Object)this.version()).add("StepName", (Object)this.stepName()).add("ResourceArn", (Object)this.resourceArn()).add("WarningStatus", (Object)this.warningStatusAsString()).add("WarningUpdatedTime", (Object)this.warningUpdatedTime()).add("WarningMessage", (Object)this.warningMessage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workflow": {
                return Optional.ofNullable(clazz.cast(this.workflow()));
            }
            case "version": {
                return Optional.ofNullable(clazz.cast(this.version()));
            }
            case "stepName": {
                return Optional.ofNullable(clazz.cast(this.stepName()));
            }
            case "resourceArn": {
                return Optional.ofNullable(clazz.cast(this.resourceArn()));
            }
            case "warningStatus": {
                return Optional.ofNullable(clazz.cast(this.warningStatusAsString()));
            }
            case "warningUpdatedTime": {
                return Optional.ofNullable(clazz.cast(this.warningUpdatedTime()));
            }
            case "warningMessage": {
                return Optional.ofNullable(clazz.cast(this.warningMessage()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workflow", WORKFLOW_FIELD);
        map.put("version", VERSION_FIELD);
        map.put("stepName", STEP_NAME_FIELD);
        map.put("resourceArn", RESOURCE_ARN_FIELD);
        map.put("warningStatus", WARNING_STATUS_FIELD);
        map.put("warningUpdatedTime", WARNING_UPDATED_TIME_FIELD);
        map.put("warningMessage", WARNING_MESSAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ResourceWarning, T> g) {
        return obj -> g.apply((ResourceWarning)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private MinimalWorkflow workflow;
        private String version;
        private String stepName;
        private String resourceArn;
        private String warningStatus;
        private Instant warningUpdatedTime;
        private String warningMessage;

        private BuilderImpl() {
        }

        private BuilderImpl(ResourceWarning model) {
            this.workflow(model.workflow);
            this.version(model.version);
            this.stepName(model.stepName);
            this.resourceArn(model.resourceArn);
            this.warningStatus(model.warningStatus);
            this.warningUpdatedTime(model.warningUpdatedTime);
            this.warningMessage(model.warningMessage);
        }

        public final MinimalWorkflow.Builder getWorkflow() {
            return this.workflow != null ? this.workflow.toBuilder() : null;
        }

        public final void setWorkflow(MinimalWorkflow.BuilderImpl workflow) {
            this.workflow = workflow != null ? workflow.build() : null;
        }

        @Override
        public final Builder workflow(MinimalWorkflow workflow) {
            this.workflow = workflow;
            return this;
        }

        public final String getVersion() {
            return this.version;
        }

        public final void setVersion(String version) {
            this.version = version;
        }

        @Override
        public final Builder version(String version) {
            this.version = version;
            return this;
        }

        public final String getStepName() {
            return this.stepName;
        }

        public final void setStepName(String stepName) {
            this.stepName = stepName;
        }

        @Override
        public final Builder stepName(String stepName) {
            this.stepName = stepName;
            return this;
        }

        public final String getResourceArn() {
            return this.resourceArn;
        }

        public final void setResourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
        }

        @Override
        public final Builder resourceArn(String resourceArn) {
            this.resourceArn = resourceArn;
            return this;
        }

        public final String getWarningStatus() {
            return this.warningStatus;
        }

        public final void setWarningStatus(String warningStatus) {
            this.warningStatus = warningStatus;
        }

        @Override
        public final Builder warningStatus(String warningStatus) {
            this.warningStatus = warningStatus;
            return this;
        }

        @Override
        public final Builder warningStatus(ResourceWarningStatus warningStatus) {
            this.warningStatus(warningStatus == null ? null : warningStatus.toString());
            return this;
        }

        public final Instant getWarningUpdatedTime() {
            return this.warningUpdatedTime;
        }

        public final void setWarningUpdatedTime(Instant warningUpdatedTime) {
            this.warningUpdatedTime = warningUpdatedTime;
        }

        @Override
        public final Builder warningUpdatedTime(Instant warningUpdatedTime) {
            this.warningUpdatedTime = warningUpdatedTime;
            return this;
        }

        public final String getWarningMessage() {
            return this.warningMessage;
        }

        public final void setWarningMessage(String warningMessage) {
            this.warningMessage = warningMessage;
        }

        @Override
        public final Builder warningMessage(String warningMessage) {
            this.warningMessage = warningMessage;
            return this;
        }

        public ResourceWarning build() {
            return new ResourceWarning(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ResourceWarning> {
        public Builder workflow(MinimalWorkflow var1);

        default public Builder workflow(Consumer<MinimalWorkflow.Builder> workflow) {
            return this.workflow((MinimalWorkflow)((MinimalWorkflow.Builder)MinimalWorkflow.builder().applyMutation(workflow)).build());
        }

        public Builder version(String var1);

        public Builder stepName(String var1);

        public Builder resourceArn(String var1);

        public Builder warningStatus(String var1);

        public Builder warningStatus(ResourceWarningStatus var1);

        public Builder warningUpdatedTime(Instant var1);

        public Builder warningMessage(String var1);
    }
}

