/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.arcregionswitch.model.ArcRegionSwitchRequest;
import software.amazon.awssdk.services.arcregionswitch.model.ExecutionState;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListPlanExecutionsRequest
extends ArcRegionSwitchRequest
implements ToCopyableBuilder<Builder, ListPlanExecutionsRequest> {
    private static final SdkField<String> PLAN_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("planArn").getter(ListPlanExecutionsRequest.getter(ListPlanExecutionsRequest::planArn)).setter(ListPlanExecutionsRequest.setter(Builder::planArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planArn").build()}).build();
    private static final SdkField<Integer> MAX_RESULTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxResults").getter(ListPlanExecutionsRequest.getter(ListPlanExecutionsRequest::maxResults)).setter(ListPlanExecutionsRequest.setter(Builder::maxResults)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxResults").build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListPlanExecutionsRequest.getter(ListPlanExecutionsRequest::nextToken)).setter(ListPlanExecutionsRequest.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final SdkField<String> STATE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("state").getter(ListPlanExecutionsRequest.getter(ListPlanExecutionsRequest::stateAsString)).setter(ListPlanExecutionsRequest.setter(Builder::state)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("state").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAN_ARN_FIELD, MAX_RESULTS_FIELD, NEXT_TOKEN_FIELD, STATE_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListPlanExecutionsRequest.memberNameToFieldInitializer();
    private final String planArn;
    private final Integer maxResults;
    private final String nextToken;
    private final String state;

    private ListPlanExecutionsRequest(BuilderImpl builder) {
        super(builder);
        this.planArn = builder.planArn;
        this.maxResults = builder.maxResults;
        this.nextToken = builder.nextToken;
        this.state = builder.state;
    }

    public final String planArn() {
        return this.planArn;
    }

    public final Integer maxResults() {
        return this.maxResults;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public final ExecutionState state() {
        return ExecutionState.fromValue(this.state);
    }

    public final String stateAsString() {
        return this.state;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.planArn());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxResults());
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.stateAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListPlanExecutionsRequest)) {
            return false;
        }
        ListPlanExecutionsRequest other = (ListPlanExecutionsRequest)((Object)obj);
        return Objects.equals(this.planArn(), other.planArn()) && Objects.equals(this.maxResults(), other.maxResults()) && Objects.equals(this.nextToken(), other.nextToken()) && Objects.equals(this.stateAsString(), other.stateAsString());
    }

    public final String toString() {
        return ToString.builder((String)"ListPlanExecutionsRequest").add("PlanArn", (Object)this.planArn()).add("MaxResults", (Object)this.maxResults()).add("NextToken", (Object)this.nextToken()).add("State", (Object)this.stateAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "planArn": {
                return Optional.ofNullable(clazz.cast(this.planArn()));
            }
            case "maxResults": {
                return Optional.ofNullable(clazz.cast(this.maxResults()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
            case "state": {
                return Optional.ofNullable(clazz.cast(this.stateAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("planArn", PLAN_ARN_FIELD);
        map.put("maxResults", MAX_RESULTS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        map.put("state", STATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListPlanExecutionsRequest, T> g) {
        return obj -> g.apply((ListPlanExecutionsRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ArcRegionSwitchRequest.BuilderImpl
    implements Builder {
        private String planArn;
        private Integer maxResults;
        private String nextToken;
        private String state;

        private BuilderImpl() {
        }

        private BuilderImpl(ListPlanExecutionsRequest model) {
            super(model);
            this.planArn(model.planArn);
            this.maxResults(model.maxResults);
            this.nextToken(model.nextToken);
            this.state(model.state);
        }

        public final String getPlanArn() {
            return this.planArn;
        }

        public final void setPlanArn(String planArn) {
            this.planArn = planArn;
        }

        @Override
        public final Builder planArn(String planArn) {
            this.planArn = planArn;
            return this;
        }

        public final Integer getMaxResults() {
            return this.maxResults;
        }

        public final void setMaxResults(Integer maxResults) {
            this.maxResults = maxResults;
        }

        @Override
        public final Builder maxResults(Integer maxResults) {
            this.maxResults = maxResults;
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        public final String getState() {
            return this.state;
        }

        public final void setState(String state) {
            this.state = state;
        }

        @Override
        public final Builder state(String state) {
            this.state = state;
            return this;
        }

        @Override
        public final Builder state(ExecutionState state) {
            this.state(state == null ? null : state.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public ListPlanExecutionsRequest build() {
            return new ListPlanExecutionsRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ArcRegionSwitchRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListPlanExecutionsRequest> {
        public Builder planArn(String var1);

        public Builder maxResults(Integer var1);

        public Builder nextToken(String var1);

        public Builder state(String var1);

        public Builder state(ExecutionState var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

