/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.arcregionswitch.model.ArcRegionSwitchResponse;
import software.amazon.awssdk.services.arcregionswitch.model.Route53HealthCheck;
import software.amazon.awssdk.services.arcregionswitch.model.Route53HealthCheckListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ListRoute53HealthChecksResponse
extends ArcRegionSwitchResponse
implements ToCopyableBuilder<Builder, ListRoute53HealthChecksResponse> {
    private static final SdkField<List<Route53HealthCheck>> HEALTH_CHECKS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("healthChecks").getter(ListRoute53HealthChecksResponse.getter(ListRoute53HealthChecksResponse::healthChecks)).setter(ListRoute53HealthChecksResponse.setter(Builder::healthChecks)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthChecks").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Route53HealthCheck::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("nextToken").getter(ListRoute53HealthChecksResponse.getter(ListRoute53HealthChecksResponse::nextToken)).setter(ListRoute53HealthChecksResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTH_CHECKS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ListRoute53HealthChecksResponse.memberNameToFieldInitializer();
    private final List<Route53HealthCheck> healthChecks;
    private final String nextToken;

    private ListRoute53HealthChecksResponse(BuilderImpl builder) {
        super(builder);
        this.healthChecks = builder.healthChecks;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasHealthChecks() {
        return this.healthChecks != null && !(this.healthChecks instanceof SdkAutoConstructList);
    }

    public final List<Route53HealthCheck> healthChecks() {
        return this.healthChecks;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasHealthChecks() ? this.healthChecks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRoute53HealthChecksResponse)) {
            return false;
        }
        ListRoute53HealthChecksResponse other = (ListRoute53HealthChecksResponse)((Object)obj);
        return this.hasHealthChecks() == other.hasHealthChecks() && Objects.equals(this.healthChecks(), other.healthChecks()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"ListRoute53HealthChecksResponse").add("HealthChecks", this.hasHealthChecks() ? this.healthChecks() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "healthChecks": {
                return Optional.ofNullable(clazz.cast(this.healthChecks()));
            }
            case "nextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("healthChecks", HEALTH_CHECKS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRoute53HealthChecksResponse, T> g) {
        return obj -> g.apply((ListRoute53HealthChecksResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends ArcRegionSwitchResponse.BuilderImpl
    implements Builder {
        private List<Route53HealthCheck> healthChecks = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRoute53HealthChecksResponse model) {
            super(model);
            this.healthChecks(model.healthChecks);
            this.nextToken(model.nextToken);
        }

        public final List<Route53HealthCheck.Builder> getHealthChecks() {
            List<Route53HealthCheck.Builder> result = Route53HealthCheckListCopier.copyToBuilder(this.healthChecks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHealthChecks(Collection<Route53HealthCheck.BuilderImpl> healthChecks) {
            this.healthChecks = Route53HealthCheckListCopier.copyFromBuilder(healthChecks);
        }

        @Override
        public final Builder healthChecks(Collection<Route53HealthCheck> healthChecks) {
            this.healthChecks = Route53HealthCheckListCopier.copy(healthChecks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthChecks(Route53HealthCheck ... healthChecks) {
            this.healthChecks(Arrays.asList(healthChecks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthChecks(Consumer<Route53HealthCheck.Builder> ... healthChecks) {
            this.healthChecks(Stream.of(healthChecks).map(c -> (Route53HealthCheck)((Route53HealthCheck.Builder)Route53HealthCheck.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRoute53HealthChecksResponse build() {
            return new ListRoute53HealthChecksResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends ArcRegionSwitchResponse.Builder,
    SdkPojo,
    CopyableBuilder<Builder, ListRoute53HealthChecksResponse> {
        public Builder healthChecks(Collection<Route53HealthCheck> var1);

        public Builder healthChecks(Route53HealthCheck ... var1);

        public Builder healthChecks(Consumer<Route53HealthCheck.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

