/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.arcregionswitch.model.Asg;
import software.amazon.awssdk.services.arcregionswitch.model.AsgListCopier;
import software.amazon.awssdk.services.arcregionswitch.model.Ec2AsgCapacityMonitoringApproach;
import software.amazon.awssdk.services.arcregionswitch.model.Ec2Ungraceful;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class Ec2AsgCapacityIncreaseConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, Ec2AsgCapacityIncreaseConfiguration> {
    private static final SdkField<Integer> TIMEOUT_MINUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("timeoutMinutes").getter(Ec2AsgCapacityIncreaseConfiguration.getter(Ec2AsgCapacityIncreaseConfiguration::timeoutMinutes)).setter(Ec2AsgCapacityIncreaseConfiguration.setter(Builder::timeoutMinutes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timeoutMinutes").build()}).build();
    private static final SdkField<List<Asg>> ASGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("asgs").getter(Ec2AsgCapacityIncreaseConfiguration.getter(Ec2AsgCapacityIncreaseConfiguration::asgs)).setter(Ec2AsgCapacityIncreaseConfiguration.setter(Builder::asgs)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("asgs").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Asg::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<Ec2Ungraceful> UNGRACEFUL_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("ungraceful").getter(Ec2AsgCapacityIncreaseConfiguration.getter(Ec2AsgCapacityIncreaseConfiguration::ungraceful)).setter(Ec2AsgCapacityIncreaseConfiguration.setter(Builder::ungraceful)).constructor(Ec2Ungraceful::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ungraceful").build()}).build();
    private static final SdkField<Integer> TARGET_PERCENT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("targetPercent").getter(Ec2AsgCapacityIncreaseConfiguration.getter(Ec2AsgCapacityIncreaseConfiguration::targetPercent)).setter(Ec2AsgCapacityIncreaseConfiguration.setter(Builder::targetPercent)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetPercent").build()}).build();
    private static final SdkField<String> CAPACITY_MONITORING_APPROACH_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("capacityMonitoringApproach").getter(Ec2AsgCapacityIncreaseConfiguration.getter(Ec2AsgCapacityIncreaseConfiguration::capacityMonitoringApproachAsString)).setter(Ec2AsgCapacityIncreaseConfiguration.setter(Builder::capacityMonitoringApproach)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capacityMonitoringApproach").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TIMEOUT_MINUTES_FIELD, ASGS_FIELD, UNGRACEFUL_FIELD, TARGET_PERCENT_FIELD, CAPACITY_MONITORING_APPROACH_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Ec2AsgCapacityIncreaseConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final Integer timeoutMinutes;
    private final List<Asg> asgs;
    private final Ec2Ungraceful ungraceful;
    private final Integer targetPercent;
    private final String capacityMonitoringApproach;

    private Ec2AsgCapacityIncreaseConfiguration(BuilderImpl builder) {
        this.timeoutMinutes = builder.timeoutMinutes;
        this.asgs = builder.asgs;
        this.ungraceful = builder.ungraceful;
        this.targetPercent = builder.targetPercent;
        this.capacityMonitoringApproach = builder.capacityMonitoringApproach;
    }

    public final Integer timeoutMinutes() {
        return this.timeoutMinutes;
    }

    public final boolean hasAsgs() {
        return this.asgs != null && !(this.asgs instanceof SdkAutoConstructList);
    }

    public final List<Asg> asgs() {
        return this.asgs;
    }

    public final Ec2Ungraceful ungraceful() {
        return this.ungraceful;
    }

    public final Integer targetPercent() {
        return this.targetPercent;
    }

    public final Ec2AsgCapacityMonitoringApproach capacityMonitoringApproach() {
        return Ec2AsgCapacityMonitoringApproach.fromValue(this.capacityMonitoringApproach);
    }

    public final String capacityMonitoringApproachAsString() {
        return this.capacityMonitoringApproach;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.timeoutMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAsgs() ? this.asgs() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.ungraceful());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetPercent());
        hashCode = 31 * hashCode + Objects.hashCode(this.capacityMonitoringApproachAsString());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Ec2AsgCapacityIncreaseConfiguration)) {
            return false;
        }
        Ec2AsgCapacityIncreaseConfiguration other = (Ec2AsgCapacityIncreaseConfiguration)obj;
        return Objects.equals(this.timeoutMinutes(), other.timeoutMinutes()) && this.hasAsgs() == other.hasAsgs() && Objects.equals(this.asgs(), other.asgs()) && Objects.equals(this.ungraceful(), other.ungraceful()) && Objects.equals(this.targetPercent(), other.targetPercent()) && Objects.equals(this.capacityMonitoringApproachAsString(), other.capacityMonitoringApproachAsString());
    }

    public final String toString() {
        return ToString.builder((String)"Ec2AsgCapacityIncreaseConfiguration").add("TimeoutMinutes", (Object)this.timeoutMinutes()).add("Asgs", this.hasAsgs() ? this.asgs() : null).add("Ungraceful", (Object)this.ungraceful()).add("TargetPercent", (Object)this.targetPercent()).add("CapacityMonitoringApproach", (Object)this.capacityMonitoringApproachAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "timeoutMinutes": {
                return Optional.ofNullable(clazz.cast(this.timeoutMinutes()));
            }
            case "asgs": {
                return Optional.ofNullable(clazz.cast(this.asgs()));
            }
            case "ungraceful": {
                return Optional.ofNullable(clazz.cast(this.ungraceful()));
            }
            case "targetPercent": {
                return Optional.ofNullable(clazz.cast(this.targetPercent()));
            }
            case "capacityMonitoringApproach": {
                return Optional.ofNullable(clazz.cast(this.capacityMonitoringApproachAsString()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("timeoutMinutes", TIMEOUT_MINUTES_FIELD);
        map.put("asgs", ASGS_FIELD);
        map.put("ungraceful", UNGRACEFUL_FIELD);
        map.put("targetPercent", TARGET_PERCENT_FIELD);
        map.put("capacityMonitoringApproach", CAPACITY_MONITORING_APPROACH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Ec2AsgCapacityIncreaseConfiguration, T> g) {
        return obj -> g.apply((Ec2AsgCapacityIncreaseConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private Integer timeoutMinutes;
        private List<Asg> asgs = DefaultSdkAutoConstructList.getInstance();
        private Ec2Ungraceful ungraceful;
        private Integer targetPercent;
        private String capacityMonitoringApproach;

        private BuilderImpl() {
        }

        private BuilderImpl(Ec2AsgCapacityIncreaseConfiguration model) {
            this.timeoutMinutes(model.timeoutMinutes);
            this.asgs(model.asgs);
            this.ungraceful(model.ungraceful);
            this.targetPercent(model.targetPercent);
            this.capacityMonitoringApproach(model.capacityMonitoringApproach);
        }

        public final Integer getTimeoutMinutes() {
            return this.timeoutMinutes;
        }

        public final void setTimeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
        }

        @Override
        public final Builder timeoutMinutes(Integer timeoutMinutes) {
            this.timeoutMinutes = timeoutMinutes;
            return this;
        }

        public final List<Asg.Builder> getAsgs() {
            List<Asg.Builder> result = AsgListCopier.copyToBuilder(this.asgs);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAsgs(Collection<Asg.BuilderImpl> asgs) {
            this.asgs = AsgListCopier.copyFromBuilder(asgs);
        }

        @Override
        public final Builder asgs(Collection<Asg> asgs) {
            this.asgs = AsgListCopier.copy(asgs);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder asgs(Asg ... asgs) {
            this.asgs(Arrays.asList(asgs));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder asgs(Consumer<Asg.Builder> ... asgs) {
            this.asgs(Stream.of(asgs).map(c -> (Asg)((Asg.Builder)Asg.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final Ec2Ungraceful.Builder getUngraceful() {
            return this.ungraceful != null ? this.ungraceful.toBuilder() : null;
        }

        public final void setUngraceful(Ec2Ungraceful.BuilderImpl ungraceful) {
            this.ungraceful = ungraceful != null ? ungraceful.build() : null;
        }

        @Override
        public final Builder ungraceful(Ec2Ungraceful ungraceful) {
            this.ungraceful = ungraceful;
            return this;
        }

        public final Integer getTargetPercent() {
            return this.targetPercent;
        }

        public final void setTargetPercent(Integer targetPercent) {
            this.targetPercent = targetPercent;
        }

        @Override
        public final Builder targetPercent(Integer targetPercent) {
            this.targetPercent = targetPercent;
            return this;
        }

        public final String getCapacityMonitoringApproach() {
            return this.capacityMonitoringApproach;
        }

        public final void setCapacityMonitoringApproach(String capacityMonitoringApproach) {
            this.capacityMonitoringApproach = capacityMonitoringApproach;
        }

        @Override
        public final Builder capacityMonitoringApproach(String capacityMonitoringApproach) {
            this.capacityMonitoringApproach = capacityMonitoringApproach;
            return this;
        }

        @Override
        public final Builder capacityMonitoringApproach(Ec2AsgCapacityMonitoringApproach capacityMonitoringApproach) {
            this.capacityMonitoringApproach(capacityMonitoringApproach == null ? null : capacityMonitoringApproach.toString());
            return this;
        }

        public Ec2AsgCapacityIncreaseConfiguration build() {
            return new Ec2AsgCapacityIncreaseConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, Ec2AsgCapacityIncreaseConfiguration> {
        public Builder timeoutMinutes(Integer var1);

        public Builder asgs(Collection<Asg> var1);

        public Builder asgs(Asg ... var1);

        public Builder asgs(Consumer<Asg.Builder> ... var1);

        public Builder ungraceful(Ec2Ungraceful var1);

        default public Builder ungraceful(Consumer<Ec2Ungraceful.Builder> ungraceful) {
            return this.ungraceful((Ec2Ungraceful)((Ec2Ungraceful.Builder)Ec2Ungraceful.builder().applyMutation(ungraceful)).build());
        }

        public Builder targetPercent(Integer var1);

        public Builder capacityMonitoringApproach(String var1);

        public Builder capacityMonitoringApproach(Ec2AsgCapacityMonitoringApproach var1);
    }
}

