/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.arcregionswitch.ArcRegionSwitchClient;
import software.amazon.awssdk.services.arcregionswitch.internal.UserAgentUtils;
import software.amazon.awssdk.services.arcregionswitch.model.ExecutionEvent;
import software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionEventsRequest;
import software.amazon.awssdk.services.arcregionswitch.model.ListPlanExecutionEventsResponse;

public class ListPlanExecutionEventsIterable
implements SdkIterable<ListPlanExecutionEventsResponse> {
    private final ArcRegionSwitchClient client;
    private final ListPlanExecutionEventsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListPlanExecutionEventsIterable(ArcRegionSwitchClient client, ListPlanExecutionEventsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListPlanExecutionEventsResponseFetcher();
    }

    public Iterator<ListPlanExecutionEventsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<ExecutionEvent> items() {
        Function<ListPlanExecutionEventsResponse, Iterator> getIterator = response -> {
            if (response != null && response.items() != null) {
                return response.items().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListPlanExecutionEventsResponseFetcher
    implements SyncPageFetcher<ListPlanExecutionEventsResponse> {
        private ListPlanExecutionEventsResponseFetcher() {
        }

        public boolean hasNextPage(ListPlanExecutionEventsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListPlanExecutionEventsResponse nextPage(ListPlanExecutionEventsResponse previousPage) {
            if (previousPage == null) {
                return ListPlanExecutionEventsIterable.this.client.listPlanExecutionEvents(ListPlanExecutionEventsIterable.this.firstRequest);
            }
            return ListPlanExecutionEventsIterable.this.client.listPlanExecutionEvents((ListPlanExecutionEventsRequest)((Object)ListPlanExecutionEventsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

