/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents a workflow in a Region switch plan. A workflow defines a sequence of steps to execute during a Region
 * switch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Workflow implements SdkPojo, Serializable, ToCopyableBuilder<Workflow.Builder, Workflow> {
    private static final SdkField<List<Step>> STEPS_FIELD = SdkField
            .<List<Step>> builder(MarshallingType.LIST)
            .memberName("steps")
            .getter(getter(Workflow::steps))
            .setter(setter(Builder::steps))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("steps").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Step> builder(MarshallingType.SDK_POJO)
                                            .constructor(Step::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> WORKFLOW_TARGET_ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowTargetAction").getter(getter(Workflow::workflowTargetActionAsString))
            .setter(setter(Builder::workflowTargetAction))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowTargetAction").build())
            .build();

    private static final SdkField<String> WORKFLOW_TARGET_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowTargetRegion").getter(getter(Workflow::workflowTargetRegion))
            .setter(setter(Builder::workflowTargetRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowTargetRegion").build())
            .build();

    private static final SdkField<String> WORKFLOW_DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workflowDescription").getter(getter(Workflow::workflowDescription))
            .setter(setter(Builder::workflowDescription))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflowDescription").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEPS_FIELD,
            WORKFLOW_TARGET_ACTION_FIELD, WORKFLOW_TARGET_REGION_FIELD, WORKFLOW_DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<Step> steps;

    private final String workflowTargetAction;

    private final String workflowTargetRegion;

    private final String workflowDescription;

    private Workflow(BuilderImpl builder) {
        this.steps = builder.steps;
        this.workflowTargetAction = builder.workflowTargetAction;
        this.workflowTargetRegion = builder.workflowTargetRegion;
        this.workflowDescription = builder.workflowDescription;
    }

    /**
     * For responses, this returns true if the service returned a value for the Steps property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasSteps() {
        return steps != null && !(steps instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The steps that make up the workflow.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSteps} method.
     * </p>
     * 
     * @return The steps that make up the workflow.
     */
    public final List<Step> steps() {
        return steps;
    }

    /**
     * <p>
     * The action that the workflow performs. Valid values include ACTIVATE and DEACTIVATE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #workflowTargetAction} will return {@link WorkflowTargetAction#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #workflowTargetActionAsString}.
     * </p>
     * 
     * @return The action that the workflow performs. Valid values include ACTIVATE and DEACTIVATE.
     * @see WorkflowTargetAction
     */
    public final WorkflowTargetAction workflowTargetAction() {
        return WorkflowTargetAction.fromValue(workflowTargetAction);
    }

    /**
     * <p>
     * The action that the workflow performs. Valid values include ACTIVATE and DEACTIVATE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #workflowTargetAction} will return {@link WorkflowTargetAction#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #workflowTargetActionAsString}.
     * </p>
     * 
     * @return The action that the workflow performs. Valid values include ACTIVATE and DEACTIVATE.
     * @see WorkflowTargetAction
     */
    public final String workflowTargetActionAsString() {
        return workflowTargetAction;
    }

    /**
     * <p>
     * The Amazon Web Services Region that the workflow targets.
     * </p>
     * 
     * @return The Amazon Web Services Region that the workflow targets.
     */
    public final String workflowTargetRegion() {
        return workflowTargetRegion;
    }

    /**
     * <p>
     * The description of the workflow.
     * </p>
     * 
     * @return The description of the workflow.
     */
    public final String workflowDescription() {
        return workflowDescription;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasSteps() ? steps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(workflowTargetActionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workflowTargetRegion());
        hashCode = 31 * hashCode + Objects.hashCode(workflowDescription());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Workflow)) {
            return false;
        }
        Workflow other = (Workflow) obj;
        return hasSteps() == other.hasSteps() && Objects.equals(steps(), other.steps())
                && Objects.equals(workflowTargetActionAsString(), other.workflowTargetActionAsString())
                && Objects.equals(workflowTargetRegion(), other.workflowTargetRegion())
                && Objects.equals(workflowDescription(), other.workflowDescription());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Workflow").add("Steps", hasSteps() ? steps() : null)
                .add("WorkflowTargetAction", workflowTargetActionAsString()).add("WorkflowTargetRegion", workflowTargetRegion())
                .add("WorkflowDescription", workflowDescription()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "steps":
            return Optional.ofNullable(clazz.cast(steps()));
        case "workflowTargetAction":
            return Optional.ofNullable(clazz.cast(workflowTargetActionAsString()));
        case "workflowTargetRegion":
            return Optional.ofNullable(clazz.cast(workflowTargetRegion()));
        case "workflowDescription":
            return Optional.ofNullable(clazz.cast(workflowDescription()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("steps", STEPS_FIELD);
        map.put("workflowTargetAction", WORKFLOW_TARGET_ACTION_FIELD);
        map.put("workflowTargetRegion", WORKFLOW_TARGET_REGION_FIELD);
        map.put("workflowDescription", WORKFLOW_DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Workflow, T> g) {
        return obj -> g.apply((Workflow) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Workflow> {
        /**
         * <p>
         * The steps that make up the workflow.
         * </p>
         * 
         * @param steps
         *        The steps that make up the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(Collection<Step> steps);

        /**
         * <p>
         * The steps that make up the workflow.
         * </p>
         * 
         * @param steps
         *        The steps that make up the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder steps(Step... steps);

        /**
         * <p>
         * The steps that make up the workflow.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.arcregionswitch.model.Step.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.arcregionswitch.model.Step#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.arcregionswitch.model.Step.Builder#build()} is called immediately and
         * its result is passed to {@link #steps(List<Step>)}.
         * 
         * @param steps
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.arcregionswitch.model.Step.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #steps(java.util.Collection<Step>)
         */
        Builder steps(Consumer<Step.Builder>... steps);

        /**
         * <p>
         * The action that the workflow performs. Valid values include ACTIVATE and DEACTIVATE.
         * </p>
         * 
         * @param workflowTargetAction
         *        The action that the workflow performs. Valid values include ACTIVATE and DEACTIVATE.
         * @see WorkflowTargetAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowTargetAction
         */
        Builder workflowTargetAction(String workflowTargetAction);

        /**
         * <p>
         * The action that the workflow performs. Valid values include ACTIVATE and DEACTIVATE.
         * </p>
         * 
         * @param workflowTargetAction
         *        The action that the workflow performs. Valid values include ACTIVATE and DEACTIVATE.
         * @see WorkflowTargetAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowTargetAction
         */
        Builder workflowTargetAction(WorkflowTargetAction workflowTargetAction);

        /**
         * <p>
         * The Amazon Web Services Region that the workflow targets.
         * </p>
         * 
         * @param workflowTargetRegion
         *        The Amazon Web Services Region that the workflow targets.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowTargetRegion(String workflowTargetRegion);

        /**
         * <p>
         * The description of the workflow.
         * </p>
         * 
         * @param workflowDescription
         *        The description of the workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflowDescription(String workflowDescription);
    }

    static final class BuilderImpl implements Builder {
        private List<Step> steps = DefaultSdkAutoConstructList.getInstance();

        private String workflowTargetAction;

        private String workflowTargetRegion;

        private String workflowDescription;

        private BuilderImpl() {
        }

        private BuilderImpl(Workflow model) {
            steps(model.steps);
            workflowTargetAction(model.workflowTargetAction);
            workflowTargetRegion(model.workflowTargetRegion);
            workflowDescription(model.workflowDescription);
        }

        public final List<Step.Builder> getSteps() {
            List<Step.Builder> result = StepsCopier.copyToBuilder(this.steps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSteps(Collection<Step.BuilderImpl> steps) {
            this.steps = StepsCopier.copyFromBuilder(steps);
        }

        @Override
        public final Builder steps(Collection<Step> steps) {
            this.steps = StepsCopier.copy(steps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Step... steps) {
            steps(Arrays.asList(steps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder steps(Consumer<Step.Builder>... steps) {
            steps(Stream.of(steps).map(c -> Step.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getWorkflowTargetAction() {
            return workflowTargetAction;
        }

        public final void setWorkflowTargetAction(String workflowTargetAction) {
            this.workflowTargetAction = workflowTargetAction;
        }

        @Override
        public final Builder workflowTargetAction(String workflowTargetAction) {
            this.workflowTargetAction = workflowTargetAction;
            return this;
        }

        @Override
        public final Builder workflowTargetAction(WorkflowTargetAction workflowTargetAction) {
            this.workflowTargetAction(workflowTargetAction == null ? null : workflowTargetAction.toString());
            return this;
        }

        public final String getWorkflowTargetRegion() {
            return workflowTargetRegion;
        }

        public final void setWorkflowTargetRegion(String workflowTargetRegion) {
            this.workflowTargetRegion = workflowTargetRegion;
        }

        @Override
        public final Builder workflowTargetRegion(String workflowTargetRegion) {
            this.workflowTargetRegion = workflowTargetRegion;
            return this;
        }

        public final String getWorkflowDescription() {
            return workflowDescription;
        }

        public final void setWorkflowDescription(String workflowDescription) {
            this.workflowDescription = workflowDescription;
        }

        @Override
        public final Builder workflowDescription(String workflowDescription) {
            this.workflowDescription = workflowDescription;
            return this;
        }

        @Override
        public Workflow build() {
            return new Workflow(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
