/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Defines a condition that can automatically trigger the execution of a Region switch plan.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Trigger implements SdkPojo, Serializable, ToCopyableBuilder<Trigger.Builder, Trigger> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(Trigger::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<String> TARGET_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetRegion").getter(getter(Trigger::targetRegion)).setter(setter(Builder::targetRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRegion").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(Trigger::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<List<TriggerCondition>> CONDITIONS_FIELD = SdkField
            .<List<TriggerCondition>> builder(MarshallingType.LIST)
            .memberName("conditions")
            .getter(getter(Trigger::conditions))
            .setter(setter(Builder::conditions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("conditions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<TriggerCondition> builder(MarshallingType.SDK_POJO)
                                            .constructor(TriggerCondition::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> MIN_DELAY_MINUTES_BETWEEN_EXECUTIONS_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("minDelayMinutesBetweenExecutions")
            .getter(getter(Trigger::minDelayMinutesBetweenExecutions))
            .setter(setter(Builder::minDelayMinutesBetweenExecutions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("minDelayMinutesBetweenExecutions")
                    .build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            TARGET_REGION_FIELD, ACTION_FIELD, CONDITIONS_FIELD, MIN_DELAY_MINUTES_BETWEEN_EXECUTIONS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String description;

    private final String targetRegion;

    private final String action;

    private final List<TriggerCondition> conditions;

    private final Integer minDelayMinutesBetweenExecutions;

    private Trigger(BuilderImpl builder) {
        this.description = builder.description;
        this.targetRegion = builder.targetRegion;
        this.action = builder.action;
        this.conditions = builder.conditions;
        this.minDelayMinutesBetweenExecutions = builder.minDelayMinutesBetweenExecutions;
    }

    /**
     * <p>
     * The description for a trigger.
     * </p>
     * 
     * @return The description for a trigger.
     */
    public final String description() {
        return description;
    }

    /**
     * <p>
     * The Amazon Web Services Region for a trigger.
     * </p>
     * 
     * @return The Amazon Web Services Region for a trigger.
     */
    public final String targetRegion() {
        return targetRegion;
    }

    /**
     * <p>
     * The action to perform when the trigger fires. Valid values include ACTIVATE and DEACTIVATE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link WorkflowTargetAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return The action to perform when the trigger fires. Valid values include ACTIVATE and DEACTIVATE.
     * @see WorkflowTargetAction
     */
    public final WorkflowTargetAction action() {
        return WorkflowTargetAction.fromValue(action);
    }

    /**
     * <p>
     * The action to perform when the trigger fires. Valid values include ACTIVATE and DEACTIVATE.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link WorkflowTargetAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #actionAsString}.
     * </p>
     * 
     * @return The action to perform when the trigger fires. Valid values include ACTIVATE and DEACTIVATE.
     * @see WorkflowTargetAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * For responses, this returns true if the service returned a value for the Conditions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasConditions() {
        return conditions != null && !(conditions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The conditions that must be met for the trigger to fire.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasConditions} method.
     * </p>
     * 
     * @return The conditions that must be met for the trigger to fire.
     */
    public final List<TriggerCondition> conditions() {
        return conditions;
    }

    /**
     * <p>
     * The minimum time, in minutes, that must elapse between automatic executions of the plan.
     * </p>
     * 
     * @return The minimum time, in minutes, that must elapse between automatic executions of the plan.
     */
    public final Integer minDelayMinutesBetweenExecutions() {
        return minDelayMinutesBetweenExecutions;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(targetRegion());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasConditions() ? conditions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(minDelayMinutesBetweenExecutions());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Trigger)) {
            return false;
        }
        Trigger other = (Trigger) obj;
        return Objects.equals(description(), other.description()) && Objects.equals(targetRegion(), other.targetRegion())
                && Objects.equals(actionAsString(), other.actionAsString()) && hasConditions() == other.hasConditions()
                && Objects.equals(conditions(), other.conditions())
                && Objects.equals(minDelayMinutesBetweenExecutions(), other.minDelayMinutesBetweenExecutions());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Trigger").add("Description", description()).add("TargetRegion", targetRegion())
                .add("Action", actionAsString()).add("Conditions", hasConditions() ? conditions() : null)
                .add("MinDelayMinutesBetweenExecutions", minDelayMinutesBetweenExecutions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "targetRegion":
            return Optional.ofNullable(clazz.cast(targetRegion()));
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "conditions":
            return Optional.ofNullable(clazz.cast(conditions()));
        case "minDelayMinutesBetweenExecutions":
            return Optional.ofNullable(clazz.cast(minDelayMinutesBetweenExecutions()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("targetRegion", TARGET_REGION_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("conditions", CONDITIONS_FIELD);
        map.put("minDelayMinutesBetweenExecutions", MIN_DELAY_MINUTES_BETWEEN_EXECUTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Trigger, T> g) {
        return obj -> g.apply((Trigger) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Trigger> {
        /**
         * <p>
         * The description for a trigger.
         * </p>
         * 
         * @param description
         *        The description for a trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * The Amazon Web Services Region for a trigger.
         * </p>
         * 
         * @param targetRegion
         *        The Amazon Web Services Region for a trigger.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetRegion(String targetRegion);

        /**
         * <p>
         * The action to perform when the trigger fires. Valid values include ACTIVATE and DEACTIVATE.
         * </p>
         * 
         * @param action
         *        The action to perform when the trigger fires. Valid values include ACTIVATE and DEACTIVATE.
         * @see WorkflowTargetAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowTargetAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action to perform when the trigger fires. Valid values include ACTIVATE and DEACTIVATE.
         * </p>
         * 
         * @param action
         *        The action to perform when the trigger fires. Valid values include ACTIVATE and DEACTIVATE.
         * @see WorkflowTargetAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see WorkflowTargetAction
         */
        Builder action(WorkflowTargetAction action);

        /**
         * <p>
         * The conditions that must be met for the trigger to fire.
         * </p>
         * 
         * @param conditions
         *        The conditions that must be met for the trigger to fire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(Collection<TriggerCondition> conditions);

        /**
         * <p>
         * The conditions that must be met for the trigger to fire.
         * </p>
         * 
         * @param conditions
         *        The conditions that must be met for the trigger to fire.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder conditions(TriggerCondition... conditions);

        /**
         * <p>
         * The conditions that must be met for the trigger to fire.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.arcregionswitch.model.TriggerCondition.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.arcregionswitch.model.TriggerCondition#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.arcregionswitch.model.TriggerCondition.Builder#build()} is called
         * immediately and its result is passed to {@link #conditions(List<TriggerCondition>)}.
         * 
         * @param conditions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.arcregionswitch.model.TriggerCondition.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #conditions(java.util.Collection<TriggerCondition>)
         */
        Builder conditions(Consumer<TriggerCondition.Builder>... conditions);

        /**
         * <p>
         * The minimum time, in minutes, that must elapse between automatic executions of the plan.
         * </p>
         * 
         * @param minDelayMinutesBetweenExecutions
         *        The minimum time, in minutes, that must elapse between automatic executions of the plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder minDelayMinutesBetweenExecutions(Integer minDelayMinutesBetweenExecutions);
    }

    static final class BuilderImpl implements Builder {
        private String description;

        private String targetRegion;

        private String action;

        private List<TriggerCondition> conditions = DefaultSdkAutoConstructList.getInstance();

        private Integer minDelayMinutesBetweenExecutions;

        private BuilderImpl() {
        }

        private BuilderImpl(Trigger model) {
            description(model.description);
            targetRegion(model.targetRegion);
            action(model.action);
            conditions(model.conditions);
            minDelayMinutesBetweenExecutions(model.minDelayMinutesBetweenExecutions);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final String getTargetRegion() {
            return targetRegion;
        }

        public final void setTargetRegion(String targetRegion) {
            this.targetRegion = targetRegion;
        }

        @Override
        public final Builder targetRegion(String targetRegion) {
            this.targetRegion = targetRegion;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(WorkflowTargetAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final List<TriggerCondition.Builder> getConditions() {
            List<TriggerCondition.Builder> result = TriggerConditionListCopier.copyToBuilder(this.conditions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setConditions(Collection<TriggerCondition.BuilderImpl> conditions) {
            this.conditions = TriggerConditionListCopier.copyFromBuilder(conditions);
        }

        @Override
        public final Builder conditions(Collection<TriggerCondition> conditions) {
            this.conditions = TriggerConditionListCopier.copy(conditions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(TriggerCondition... conditions) {
            conditions(Arrays.asList(conditions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder conditions(Consumer<TriggerCondition.Builder>... conditions) {
            conditions(Stream.of(conditions).map(c -> TriggerCondition.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getMinDelayMinutesBetweenExecutions() {
            return minDelayMinutesBetweenExecutions;
        }

        public final void setMinDelayMinutesBetweenExecutions(Integer minDelayMinutesBetweenExecutions) {
            this.minDelayMinutesBetweenExecutions = minDelayMinutesBetweenExecutions;
        }

        @Override
        public final Builder minDelayMinutesBetweenExecutions(Integer minDelayMinutesBetweenExecutions) {
            this.minDelayMinutesBetweenExecutions = minDelayMinutesBetweenExecutions;
            return this;
        }

        @Override
        public Trigger build() {
            return new Trigger(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
