/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Represents the state of a step in a plan execution.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StepState implements SdkPojo, Serializable, ToCopyableBuilder<StepState.Builder, StepState> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(StepState::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(StepState::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime").getter(getter(StepState::startTime)).setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build()).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField.<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime").getter(getter(StepState::endTime)).setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build()).build();

    private static final SdkField<String> STEP_MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("stepMode").getter(getter(StepState::stepModeAsString)).setter(setter(Builder::stepMode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepMode").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, STATUS_FIELD,
            START_TIME_FIELD, END_TIME_FIELD, STEP_MODE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String status;

    private final Instant startTime;

    private final Instant endTime;

    private final String stepMode;

    private StepState(BuilderImpl builder) {
        this.name = builder.name;
        this.status = builder.status;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.stepMode = builder.stepMode;
    }

    /**
     * <p>
     * The name of a step in a workflow.
     * </p>
     * 
     * @return The name of a step in a workflow.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The status of a step in a workflow. For example, a status might be Completed or Pending Approval.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StepStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a step in a workflow. For example, a status might be Completed or Pending Approval.
     * @see StepStatus
     */
    public final StepStatus status() {
        return StepStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of a step in a workflow. For example, a status might be Completed or Pending Approval.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link StepStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #statusAsString}.
     * </p>
     * 
     * @return The status of a step in a workflow. For example, a status might be Completed or Pending Approval.
     * @see StepStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The timestamp when a step started execution.
     * </p>
     * 
     * @return The timestamp when a step started execution.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The timestamp when a step endeded execution.
     * </p>
     * 
     * @return The timestamp when a step endeded execution.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The mode for a step execution. The mode can be Graceful or Ungraceful.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stepMode} will
     * return {@link ExecutionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stepModeAsString}.
     * </p>
     * 
     * @return The mode for a step execution. The mode can be Graceful or Ungraceful.
     * @see ExecutionMode
     */
    public final ExecutionMode stepMode() {
        return ExecutionMode.fromValue(stepMode);
    }

    /**
     * <p>
     * The mode for a step execution. The mode can be Graceful or Ungraceful.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #stepMode} will
     * return {@link ExecutionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #stepModeAsString}.
     * </p>
     * 
     * @return The mode for a step execution. The mode can be Graceful or Ungraceful.
     * @see ExecutionMode
     */
    public final String stepModeAsString() {
        return stepMode;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(stepModeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepState)) {
            return false;
        }
        StepState other = (StepState) obj;
        return Objects.equals(name(), other.name()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(stepModeAsString(), other.stepModeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StepState").add("Name", name()).add("Status", statusAsString()).add("StartTime", startTime())
                .add("EndTime", endTime()).add("StepMode", stepModeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "stepMode":
            return Optional.ofNullable(clazz.cast(stepModeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("stepMode", STEP_MODE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StepState, T> g) {
        return obj -> g.apply((StepState) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StepState> {
        /**
         * <p>
         * The name of a step in a workflow.
         * </p>
         * 
         * @param name
         *        The name of a step in a workflow.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The status of a step in a workflow. For example, a status might be Completed or Pending Approval.
         * </p>
         * 
         * @param status
         *        The status of a step in a workflow. For example, a status might be Completed or Pending Approval.
         * @see StepStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of a step in a workflow. For example, a status might be Completed or Pending Approval.
         * </p>
         * 
         * @param status
         *        The status of a step in a workflow. For example, a status might be Completed or Pending Approval.
         * @see StepStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepStatus
         */
        Builder status(StepStatus status);

        /**
         * <p>
         * The timestamp when a step started execution.
         * </p>
         * 
         * @param startTime
         *        The timestamp when a step started execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The timestamp when a step endeded execution.
         * </p>
         * 
         * @param endTime
         *        The timestamp when a step endeded execution.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The mode for a step execution. The mode can be Graceful or Ungraceful.
         * </p>
         * 
         * @param stepMode
         *        The mode for a step execution. The mode can be Graceful or Ungraceful.
         * @see ExecutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionMode
         */
        Builder stepMode(String stepMode);

        /**
         * <p>
         * The mode for a step execution. The mode can be Graceful or Ungraceful.
         * </p>
         * 
         * @param stepMode
         *        The mode for a step execution. The mode can be Graceful or Ungraceful.
         * @see ExecutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionMode
         */
        Builder stepMode(ExecutionMode stepMode);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String status;

        private Instant startTime;

        private Instant endTime;

        private String stepMode;

        private BuilderImpl() {
        }

        private BuilderImpl(StepState model) {
            name(model.name);
            status(model.status);
            startTime(model.startTime);
            endTime(model.endTime);
            stepMode(model.stepMode);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(StepStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getStepMode() {
            return stepMode;
        }

        public final void setStepMode(String stepMode) {
            this.stepMode = stepMode;
        }

        @Override
        public final Builder stepMode(String stepMode) {
            this.stepMode = stepMode;
            return this;
        }

        @Override
        public final Builder stepMode(ExecutionMode stepMode) {
            this.stepMode(stepMode == null ? null : stepMode.toString());
            return this;
        }

        @Override
        public StepState build() {
            return new StepState(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
