/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartPlanExecutionRequest extends ArcRegionSwitchRequest implements
        ToCopyableBuilder<StartPlanExecutionRequest.Builder, StartPlanExecutionRequest> {
    private static final SdkField<String> PLAN_ARN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("planArn").getter(getter(StartPlanExecutionRequest::planArn)).setter(setter(Builder::planArn))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("planArn").build()).build();

    private static final SdkField<String> TARGET_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetRegion").getter(getter(StartPlanExecutionRequest::targetRegion))
            .setter(setter(Builder::targetRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetRegion").build()).build();

    private static final SdkField<String> ACTION_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("action")
            .getter(getter(StartPlanExecutionRequest::actionAsString)).setter(setter(Builder::action))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("action").build()).build();

    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("mode")
            .getter(getter(StartPlanExecutionRequest::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()).build();

    private static final SdkField<String> COMMENT_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("comment")
            .getter(getter(StartPlanExecutionRequest::comment)).setter(setter(Builder::comment))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("comment").build()).build();

    private static final SdkField<String> LATEST_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("latestVersion").getter(getter(StartPlanExecutionRequest::latestVersion))
            .setter(setter(Builder::latestVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("latestVersion").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(PLAN_ARN_FIELD,
            TARGET_REGION_FIELD, ACTION_FIELD, MODE_FIELD, COMMENT_FIELD, LATEST_VERSION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String planArn;

    private final String targetRegion;

    private final String action;

    private final String mode;

    private final String comment;

    private final String latestVersion;

    private StartPlanExecutionRequest(BuilderImpl builder) {
        super(builder);
        this.planArn = builder.planArn;
        this.targetRegion = builder.targetRegion;
        this.action = builder.action;
        this.mode = builder.mode;
        this.comment = builder.comment;
        this.latestVersion = builder.latestVersion;
    }

    /**
     * <p>
     * The Amazon Resource Name (ARN) of the plan to execute.
     * </p>
     * 
     * @return The Amazon Resource Name (ARN) of the plan to execute.
     */
    public final String planArn() {
        return planArn;
    }

    /**
     * <p>
     * The Amazon Web Services Region to target with this execution. This is the Region that traffic will be shifted to
     * or from, depending on the action.
     * </p>
     * 
     * @return The Amazon Web Services Region to target with this execution. This is the Region that traffic will be
     *         shifted to or from, depending on the action.
     */
    public final String targetRegion() {
        return targetRegion;
    }

    /**
     * <p>
     * The action to perform. Valid values are ACTIVATE (to shift traffic to the target Region) or DEACTIVATE (to shift
     * traffic away from the target Region).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ExecutionAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action to perform. Valid values are ACTIVATE (to shift traffic to the target Region) or DEACTIVATE
     *         (to shift traffic away from the target Region).
     * @see ExecutionAction
     */
    public final ExecutionAction action() {
        return ExecutionAction.fromValue(action);
    }

    /**
     * <p>
     * The action to perform. Valid values are ACTIVATE (to shift traffic to the target Region) or DEACTIVATE (to shift
     * traffic away from the target Region).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #action} will
     * return {@link ExecutionAction#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #actionAsString}.
     * </p>
     * 
     * @return The action to perform. Valid values are ACTIVATE (to shift traffic to the target Region) or DEACTIVATE
     *         (to shift traffic away from the target Region).
     * @see ExecutionAction
     */
    public final String actionAsString() {
        return action;
    }

    /**
     * <p>
     * The plan execution mode. Valid values are <code>Practice</code>, for testing without making actual changes, or
     * <code>Recovery</code>, for actual traffic shifting and application recovery.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ExecutionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The plan execution mode. Valid values are <code>Practice</code>, for testing without making actual
     *         changes, or <code>Recovery</code>, for actual traffic shifting and application recovery.
     * @see ExecutionMode
     */
    public final ExecutionMode mode() {
        return ExecutionMode.fromValue(mode);
    }

    /**
     * <p>
     * The plan execution mode. Valid values are <code>Practice</code>, for testing without making actual changes, or
     * <code>Recovery</code>, for actual traffic shifting and application recovery.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link ExecutionMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The plan execution mode. Valid values are <code>Practice</code>, for testing without making actual
     *         changes, or <code>Recovery</code>, for actual traffic shifting and application recovery.
     * @see ExecutionMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * An optional comment explaining why the plan execution is being started.
     * </p>
     * 
     * @return An optional comment explaining why the plan execution is being started.
     */
    public final String comment() {
        return comment;
    }

    /**
     * <p>
     * A boolean value indicating whether to use the latest version of the plan. If set to false, you must specify a
     * specific version.
     * </p>
     * 
     * @return A boolean value indicating whether to use the latest version of the plan. If set to false, you must
     *         specify a specific version.
     */
    public final String latestVersion() {
        return latestVersion;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(planArn());
        hashCode = 31 * hashCode + Objects.hashCode(targetRegion());
        hashCode = 31 * hashCode + Objects.hashCode(actionAsString());
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(comment());
        hashCode = 31 * hashCode + Objects.hashCode(latestVersion());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartPlanExecutionRequest)) {
            return false;
        }
        StartPlanExecutionRequest other = (StartPlanExecutionRequest) obj;
        return Objects.equals(planArn(), other.planArn()) && Objects.equals(targetRegion(), other.targetRegion())
                && Objects.equals(actionAsString(), other.actionAsString())
                && Objects.equals(modeAsString(), other.modeAsString()) && Objects.equals(comment(), other.comment())
                && Objects.equals(latestVersion(), other.latestVersion());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartPlanExecutionRequest").add("PlanArn", planArn()).add("TargetRegion", targetRegion())
                .add("Action", actionAsString()).add("Mode", modeAsString()).add("Comment", comment())
                .add("LatestVersion", latestVersion()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "planArn":
            return Optional.ofNullable(clazz.cast(planArn()));
        case "targetRegion":
            return Optional.ofNullable(clazz.cast(targetRegion()));
        case "action":
            return Optional.ofNullable(clazz.cast(actionAsString()));
        case "mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "comment":
            return Optional.ofNullable(clazz.cast(comment()));
        case "latestVersion":
            return Optional.ofNullable(clazz.cast(latestVersion()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("planArn", PLAN_ARN_FIELD);
        map.put("targetRegion", TARGET_REGION_FIELD);
        map.put("action", ACTION_FIELD);
        map.put("mode", MODE_FIELD);
        map.put("comment", COMMENT_FIELD);
        map.put("latestVersion", LATEST_VERSION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartPlanExecutionRequest, T> g) {
        return obj -> g.apply((StartPlanExecutionRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ArcRegionSwitchRequest.Builder, SdkPojo, CopyableBuilder<Builder, StartPlanExecutionRequest> {
        /**
         * <p>
         * The Amazon Resource Name (ARN) of the plan to execute.
         * </p>
         * 
         * @param planArn
         *        The Amazon Resource Name (ARN) of the plan to execute.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder planArn(String planArn);

        /**
         * <p>
         * The Amazon Web Services Region to target with this execution. This is the Region that traffic will be shifted
         * to or from, depending on the action.
         * </p>
         * 
         * @param targetRegion
         *        The Amazon Web Services Region to target with this execution. This is the Region that traffic will be
         *        shifted to or from, depending on the action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetRegion(String targetRegion);

        /**
         * <p>
         * The action to perform. Valid values are ACTIVATE (to shift traffic to the target Region) or DEACTIVATE (to
         * shift traffic away from the target Region).
         * </p>
         * 
         * @param action
         *        The action to perform. Valid values are ACTIVATE (to shift traffic to the target Region) or DEACTIVATE
         *        (to shift traffic away from the target Region).
         * @see ExecutionAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionAction
         */
        Builder action(String action);

        /**
         * <p>
         * The action to perform. Valid values are ACTIVATE (to shift traffic to the target Region) or DEACTIVATE (to
         * shift traffic away from the target Region).
         * </p>
         * 
         * @param action
         *        The action to perform. Valid values are ACTIVATE (to shift traffic to the target Region) or DEACTIVATE
         *        (to shift traffic away from the target Region).
         * @see ExecutionAction
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionAction
         */
        Builder action(ExecutionAction action);

        /**
         * <p>
         * The plan execution mode. Valid values are <code>Practice</code>, for testing without making actual changes,
         * or <code>Recovery</code>, for actual traffic shifting and application recovery.
         * </p>
         * 
         * @param mode
         *        The plan execution mode. Valid values are <code>Practice</code>, for testing without making actual
         *        changes, or <code>Recovery</code>, for actual traffic shifting and application recovery.
         * @see ExecutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The plan execution mode. Valid values are <code>Practice</code>, for testing without making actual changes,
         * or <code>Recovery</code>, for actual traffic shifting and application recovery.
         * </p>
         * 
         * @param mode
         *        The plan execution mode. Valid values are <code>Practice</code>, for testing without making actual
         *        changes, or <code>Recovery</code>, for actual traffic shifting and application recovery.
         * @see ExecutionMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ExecutionMode
         */
        Builder mode(ExecutionMode mode);

        /**
         * <p>
         * An optional comment explaining why the plan execution is being started.
         * </p>
         * 
         * @param comment
         *        An optional comment explaining why the plan execution is being started.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder comment(String comment);

        /**
         * <p>
         * A boolean value indicating whether to use the latest version of the plan. If set to false, you must specify a
         * specific version.
         * </p>
         * 
         * @param latestVersion
         *        A boolean value indicating whether to use the latest version of the plan. If set to false, you must
         *        specify a specific version.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder latestVersion(String latestVersion);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ArcRegionSwitchRequest.BuilderImpl implements Builder {
        private String planArn;

        private String targetRegion;

        private String action;

        private String mode;

        private String comment;

        private String latestVersion;

        private BuilderImpl() {
        }

        private BuilderImpl(StartPlanExecutionRequest model) {
            super(model);
            planArn(model.planArn);
            targetRegion(model.targetRegion);
            action(model.action);
            mode(model.mode);
            comment(model.comment);
            latestVersion(model.latestVersion);
        }

        public final String getPlanArn() {
            return planArn;
        }

        public final void setPlanArn(String planArn) {
            this.planArn = planArn;
        }

        @Override
        public final Builder planArn(String planArn) {
            this.planArn = planArn;
            return this;
        }

        public final String getTargetRegion() {
            return targetRegion;
        }

        public final void setTargetRegion(String targetRegion) {
            this.targetRegion = targetRegion;
        }

        @Override
        public final Builder targetRegion(String targetRegion) {
            this.targetRegion = targetRegion;
            return this;
        }

        public final String getAction() {
            return action;
        }

        public final void setAction(String action) {
            this.action = action;
        }

        @Override
        public final Builder action(String action) {
            this.action = action;
            return this;
        }

        @Override
        public final Builder action(ExecutionAction action) {
            this.action(action == null ? null : action.toString());
            return this;
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(ExecutionMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final String getComment() {
            return comment;
        }

        public final void setComment(String comment) {
            this.comment = comment;
        }

        @Override
        public final Builder comment(String comment) {
            this.comment = comment;
            return this;
        }

        public final String getLatestVersion() {
            return latestVersion;
        }

        public final void setLatestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
        }

        @Override
        public final Builder latestVersion(String latestVersion) {
            this.latestVersion = latestVersion;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartPlanExecutionRequest build() {
            return new StartPlanExecutionRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
