/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListRoute53HealthChecksResponse extends ArcRegionSwitchResponse implements
        ToCopyableBuilder<ListRoute53HealthChecksResponse.Builder, ListRoute53HealthChecksResponse> {
    private static final SdkField<List<Route53HealthCheck>> HEALTH_CHECKS_FIELD = SdkField
            .<List<Route53HealthCheck>> builder(MarshallingType.LIST)
            .memberName("healthChecks")
            .getter(getter(ListRoute53HealthChecksResponse::healthChecks))
            .setter(setter(Builder::healthChecks))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("healthChecks").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Route53HealthCheck> builder(MarshallingType.SDK_POJO)
                                            .constructor(Route53HealthCheck::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListRoute53HealthChecksResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(HEALTH_CHECKS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Route53HealthCheck> healthChecks;

    private final String nextToken;

    private ListRoute53HealthChecksResponse(BuilderImpl builder) {
        super(builder);
        this.healthChecks = builder.healthChecks;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the HealthChecks property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasHealthChecks() {
        return healthChecks != null && !(healthChecks instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * List of the health checks requested.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasHealthChecks} method.
     * </p>
     * 
     * @return List of the health checks requested.
     */
    public final List<Route53HealthCheck> healthChecks() {
        return healthChecks;
    }

    /**
     * <p>
     * Specifies that you want to receive the next page of results. Valid only if you received a <code>nextToken</code>
     * response in the previous request. If you did, it indicates that more output is available. Set this parameter to
     * the value provided by the previous call's <code>nextToken</code> response to request the next page of results.
     * </p>
     * 
     * @return Specifies that you want to receive the next page of results. Valid only if you received a
     *         <code>nextToken</code> response in the previous request. If you did, it indicates that more output is
     *         available. Set this parameter to the value provided by the previous call's <code>nextToken</code>
     *         response to request the next page of results.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasHealthChecks() ? healthChecks() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListRoute53HealthChecksResponse)) {
            return false;
        }
        ListRoute53HealthChecksResponse other = (ListRoute53HealthChecksResponse) obj;
        return hasHealthChecks() == other.hasHealthChecks() && Objects.equals(healthChecks(), other.healthChecks())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListRoute53HealthChecksResponse").add("HealthChecks", hasHealthChecks() ? healthChecks() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "healthChecks":
            return Optional.ofNullable(clazz.cast(healthChecks()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("healthChecks", HEALTH_CHECKS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListRoute53HealthChecksResponse, T> g) {
        return obj -> g.apply((ListRoute53HealthChecksResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ArcRegionSwitchResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListRoute53HealthChecksResponse> {
        /**
         * <p>
         * List of the health checks requested.
         * </p>
         * 
         * @param healthChecks
         *        List of the health checks requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthChecks(Collection<Route53HealthCheck> healthChecks);

        /**
         * <p>
         * List of the health checks requested.
         * </p>
         * 
         * @param healthChecks
         *        List of the health checks requested.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder healthChecks(Route53HealthCheck... healthChecks);

        /**
         * <p>
         * List of the health checks requested.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.arcregionswitch.model.Route53HealthCheck.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.arcregionswitch.model.Route53HealthCheck#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.arcregionswitch.model.Route53HealthCheck.Builder#build()} is called
         * immediately and its result is passed to {@link #healthChecks(List<Route53HealthCheck>)}.
         * 
         * @param healthChecks
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.arcregionswitch.model.Route53HealthCheck.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #healthChecks(java.util.Collection<Route53HealthCheck>)
         */
        Builder healthChecks(Consumer<Route53HealthCheck.Builder>... healthChecks);

        /**
         * <p>
         * Specifies that you want to receive the next page of results. Valid only if you received a
         * <code>nextToken</code> response in the previous request. If you did, it indicates that more output is
         * available. Set this parameter to the value provided by the previous call's <code>nextToken</code> response to
         * request the next page of results.
         * </p>
         * 
         * @param nextToken
         *        Specifies that you want to receive the next page of results. Valid only if you received a
         *        <code>nextToken</code> response in the previous request. If you did, it indicates that more output is
         *        available. Set this parameter to the value provided by the previous call's <code>nextToken</code>
         *        response to request the next page of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends ArcRegionSwitchResponse.BuilderImpl implements Builder {
        private List<Route53HealthCheck> healthChecks = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListRoute53HealthChecksResponse model) {
            super(model);
            healthChecks(model.healthChecks);
            nextToken(model.nextToken);
        }

        public final List<Route53HealthCheck.Builder> getHealthChecks() {
            List<Route53HealthCheck.Builder> result = Route53HealthCheckListCopier.copyToBuilder(this.healthChecks);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setHealthChecks(Collection<Route53HealthCheck.BuilderImpl> healthChecks) {
            this.healthChecks = Route53HealthCheckListCopier.copyFromBuilder(healthChecks);
        }

        @Override
        public final Builder healthChecks(Collection<Route53HealthCheck> healthChecks) {
            this.healthChecks = Route53HealthCheckListCopier.copy(healthChecks);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthChecks(Route53HealthCheck... healthChecks) {
            healthChecks(Arrays.asList(healthChecks));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder healthChecks(Consumer<Route53HealthCheck.Builder>... healthChecks) {
            healthChecks(Stream.of(healthChecks).map(c -> Route53HealthCheck.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListRoute53HealthChecksResponse build() {
            return new ListRoute53HealthChecksResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
