/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreatePlanRequest extends ArcRegionSwitchRequest implements
        ToCopyableBuilder<CreatePlanRequest.Builder, CreatePlanRequest> {
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreatePlanRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final SdkField<List<Workflow>> WORKFLOWS_FIELD = SdkField
            .<List<Workflow>> builder(MarshallingType.LIST)
            .memberName("workflows")
            .getter(getter(CreatePlanRequest::workflows))
            .setter(setter(Builder::workflows))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workflows").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Workflow> builder(MarshallingType.SDK_POJO)
                                            .constructor(Workflow::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> EXECUTION_ROLE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("executionRole").getter(getter(CreatePlanRequest::executionRole)).setter(setter(Builder::executionRole))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionRole").build()).build();

    private static final SdkField<Integer> RECOVERY_TIME_OBJECTIVE_MINUTES_FIELD = SdkField
            .<Integer> builder(MarshallingType.INTEGER)
            .memberName("recoveryTimeObjectiveMinutes")
            .getter(getter(CreatePlanRequest::recoveryTimeObjectiveMinutes))
            .setter(setter(Builder::recoveryTimeObjectiveMinutes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryTimeObjectiveMinutes")
                    .build()).build();

    private static final SdkField<Map<String, AssociatedAlarm>> ASSOCIATED_ALARMS_FIELD = SdkField
            .<Map<String, AssociatedAlarm>> builder(MarshallingType.MAP)
            .memberName("associatedAlarms")
            .getter(getter(CreatePlanRequest::associatedAlarms))
            .setter(setter(Builder::associatedAlarms))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("associatedAlarms").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AssociatedAlarm> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssociatedAlarm::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<List<Trigger>> TRIGGERS_FIELD = SdkField
            .<List<Trigger>> builder(MarshallingType.LIST)
            .memberName("triggers")
            .getter(getter(CreatePlanRequest::triggers))
            .setter(setter(Builder::triggers))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("triggers").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Trigger> builder(MarshallingType.SDK_POJO)
                                            .constructor(Trigger::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(CreatePlanRequest::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<List<String>> REGIONS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("regions")
            .getter(getter(CreatePlanRequest::regions))
            .setter(setter(Builder::regions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> RECOVERY_APPROACH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("recoveryApproach").getter(getter(CreatePlanRequest::recoveryApproachAsString))
            .setter(setter(Builder::recoveryApproach))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("recoveryApproach").build()).build();

    private static final SdkField<String> PRIMARY_REGION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("primaryRegion").getter(getter(CreatePlanRequest::primaryRegion)).setter(setter(Builder::primaryRegion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("primaryRegion").build()).build();

    private static final SdkField<Map<String, String>> TAGS_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("tags")
            .getter(getter(CreatePlanRequest::tags))
            .setter(setter(Builder::tags))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("tags").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DESCRIPTION_FIELD,
            WORKFLOWS_FIELD, EXECUTION_ROLE_FIELD, RECOVERY_TIME_OBJECTIVE_MINUTES_FIELD, ASSOCIATED_ALARMS_FIELD,
            TRIGGERS_FIELD, NAME_FIELD, REGIONS_FIELD, RECOVERY_APPROACH_FIELD, PRIMARY_REGION_FIELD, TAGS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String description;

    private final List<Workflow> workflows;

    private final String executionRole;

    private final Integer recoveryTimeObjectiveMinutes;

    private final Map<String, AssociatedAlarm> associatedAlarms;

    private final List<Trigger> triggers;

    private final String name;

    private final List<String> regions;

    private final String recoveryApproach;

    private final String primaryRegion;

    private final Map<String, String> tags;

    private CreatePlanRequest(BuilderImpl builder) {
        super(builder);
        this.description = builder.description;
        this.workflows = builder.workflows;
        this.executionRole = builder.executionRole;
        this.recoveryTimeObjectiveMinutes = builder.recoveryTimeObjectiveMinutes;
        this.associatedAlarms = builder.associatedAlarms;
        this.triggers = builder.triggers;
        this.name = builder.name;
        this.regions = builder.regions;
        this.recoveryApproach = builder.recoveryApproach;
        this.primaryRegion = builder.primaryRegion;
        this.tags = builder.tags;
    }

    /**
     * <p>
     * The description of a Region switch plan.
     * </p>
     * 
     * @return The description of a Region switch plan.
     */
    public final String description() {
        return description;
    }

    /**
     * For responses, this returns true if the service returned a value for the Workflows property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasWorkflows() {
        return workflows != null && !(workflows instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array of workflows included in a Region switch plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasWorkflows} method.
     * </p>
     * 
     * @return An array of workflows included in a Region switch plan.
     */
    public final List<Workflow> workflows() {
        return workflows;
    }

    /**
     * <p>
     * An execution role is a way to categorize a Region switch plan.
     * </p>
     * 
     * @return An execution role is a way to categorize a Region switch plan.
     */
    public final String executionRole() {
        return executionRole;
    }

    /**
     * <p>
     * Optionally, you can specify an recovery time objective for a Region switch plan, in minutes.
     * </p>
     * 
     * @return Optionally, you can specify an recovery time objective for a Region switch plan, in minutes.
     */
    public final Integer recoveryTimeObjectiveMinutes() {
        return recoveryTimeObjectiveMinutes;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssociatedAlarms property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssociatedAlarms() {
        return associatedAlarms != null && !(associatedAlarms instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The alarms associated with a Region switch plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssociatedAlarms} method.
     * </p>
     * 
     * @return The alarms associated with a Region switch plan.
     */
    public final Map<String, AssociatedAlarm> associatedAlarms() {
        return associatedAlarms;
    }

    /**
     * For responses, this returns true if the service returned a value for the Triggers property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasTriggers() {
        return triggers != null && !(triggers instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The triggers associated with a Region switch plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTriggers} method.
     * </p>
     * 
     * @return The triggers associated with a Region switch plan.
     */
    public final List<Trigger> triggers() {
        return triggers;
    }

    /**
     * <p>
     * The name of a Region switch plan.
     * </p>
     * 
     * @return The name of a Region switch plan.
     */
    public final String name() {
        return name;
    }

    /**
     * For responses, this returns true if the service returned a value for the Regions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasRegions() {
        return regions != null && !(regions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * An array that specifies the Amazon Web Services Regions for a Region switch plan. Specify two Regions.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasRegions} method.
     * </p>
     * 
     * @return An array that specifies the Amazon Web Services Regions for a Region switch plan. Specify two Regions.
     */
    public final List<String> regions() {
        return regions;
    }

    /**
     * <p>
     * The recovery approach for a Region switch plan, which can be active/active (activeActive) or active/passive
     * (activePassive).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recoveryApproach}
     * will return {@link RecoveryApproach#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #recoveryApproachAsString}.
     * </p>
     * 
     * @return The recovery approach for a Region switch plan, which can be active/active (activeActive) or
     *         active/passive (activePassive).
     * @see RecoveryApproach
     */
    public final RecoveryApproach recoveryApproach() {
        return RecoveryApproach.fromValue(recoveryApproach);
    }

    /**
     * <p>
     * The recovery approach for a Region switch plan, which can be active/active (activeActive) or active/passive
     * (activePassive).
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #recoveryApproach}
     * will return {@link RecoveryApproach#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #recoveryApproachAsString}.
     * </p>
     * 
     * @return The recovery approach for a Region switch plan, which can be active/active (activeActive) or
     *         active/passive (activePassive).
     * @see RecoveryApproach
     */
    public final String recoveryApproachAsString() {
        return recoveryApproach;
    }

    /**
     * <p>
     * The primary Amazon Web Services Region for the application. This is the Region where the application normally
     * runs before any Region switch occurs.
     * </p>
     * 
     * @return The primary Amazon Web Services Region for the application. This is the Region where the application
     *         normally runs before any Region switch occurs.
     */
    public final String primaryRegion() {
        return primaryRegion;
    }

    /**
     * For responses, this returns true if the service returned a value for the Tags property. This DOES NOT check that
     * the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is useful
     * because the SDK will never return a null collection or map, but you may need to differentiate between the service
     * returning nothing (or null) and the service returning an empty collection or map. For requests, this returns true
     * if a value for the property was specified in the request builder, and false if a value was not specified.
     */
    public final boolean hasTags() {
        return tags != null && !(tags instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The tags to apply to the Region switch plan.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTags} method.
     * </p>
     * 
     * @return The tags to apply to the Region switch plan.
     */
    public final Map<String, String> tags() {
        return tags;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(description());
        hashCode = 31 * hashCode + Objects.hashCode(hasWorkflows() ? workflows() : null);
        hashCode = 31 * hashCode + Objects.hashCode(executionRole());
        hashCode = 31 * hashCode + Objects.hashCode(recoveryTimeObjectiveMinutes());
        hashCode = 31 * hashCode + Objects.hashCode(hasAssociatedAlarms() ? associatedAlarms() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasTriggers() ? triggers() : null);
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(hasRegions() ? regions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(recoveryApproachAsString());
        hashCode = 31 * hashCode + Objects.hashCode(primaryRegion());
        hashCode = 31 * hashCode + Objects.hashCode(hasTags() ? tags() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreatePlanRequest)) {
            return false;
        }
        CreatePlanRequest other = (CreatePlanRequest) obj;
        return Objects.equals(description(), other.description()) && hasWorkflows() == other.hasWorkflows()
                && Objects.equals(workflows(), other.workflows()) && Objects.equals(executionRole(), other.executionRole())
                && Objects.equals(recoveryTimeObjectiveMinutes(), other.recoveryTimeObjectiveMinutes())
                && hasAssociatedAlarms() == other.hasAssociatedAlarms()
                && Objects.equals(associatedAlarms(), other.associatedAlarms()) && hasTriggers() == other.hasTriggers()
                && Objects.equals(triggers(), other.triggers()) && Objects.equals(name(), other.name())
                && hasRegions() == other.hasRegions() && Objects.equals(regions(), other.regions())
                && Objects.equals(recoveryApproachAsString(), other.recoveryApproachAsString())
                && Objects.equals(primaryRegion(), other.primaryRegion()) && hasTags() == other.hasTags()
                && Objects.equals(tags(), other.tags());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreatePlanRequest").add("Description", description())
                .add("Workflows", hasWorkflows() ? workflows() : null).add("ExecutionRole", executionRole())
                .add("RecoveryTimeObjectiveMinutes", recoveryTimeObjectiveMinutes())
                .add("AssociatedAlarms", hasAssociatedAlarms() ? associatedAlarms() : null)
                .add("Triggers", hasTriggers() ? triggers() : null).add("Name", name())
                .add("Regions", hasRegions() ? regions() : null).add("RecoveryApproach", recoveryApproachAsString())
                .add("PrimaryRegion", primaryRegion()).add("Tags", hasTags() ? tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        case "workflows":
            return Optional.ofNullable(clazz.cast(workflows()));
        case "executionRole":
            return Optional.ofNullable(clazz.cast(executionRole()));
        case "recoveryTimeObjectiveMinutes":
            return Optional.ofNullable(clazz.cast(recoveryTimeObjectiveMinutes()));
        case "associatedAlarms":
            return Optional.ofNullable(clazz.cast(associatedAlarms()));
        case "triggers":
            return Optional.ofNullable(clazz.cast(triggers()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "regions":
            return Optional.ofNullable(clazz.cast(regions()));
        case "recoveryApproach":
            return Optional.ofNullable(clazz.cast(recoveryApproachAsString()));
        case "primaryRegion":
            return Optional.ofNullable(clazz.cast(primaryRegion()));
        case "tags":
            return Optional.ofNullable(clazz.cast(tags()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("description", DESCRIPTION_FIELD);
        map.put("workflows", WORKFLOWS_FIELD);
        map.put("executionRole", EXECUTION_ROLE_FIELD);
        map.put("recoveryTimeObjectiveMinutes", RECOVERY_TIME_OBJECTIVE_MINUTES_FIELD);
        map.put("associatedAlarms", ASSOCIATED_ALARMS_FIELD);
        map.put("triggers", TRIGGERS_FIELD);
        map.put("name", NAME_FIELD);
        map.put("regions", REGIONS_FIELD);
        map.put("recoveryApproach", RECOVERY_APPROACH_FIELD);
        map.put("primaryRegion", PRIMARY_REGION_FIELD);
        map.put("tags", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreatePlanRequest, T> g) {
        return obj -> g.apply((CreatePlanRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends ArcRegionSwitchRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreatePlanRequest> {
        /**
         * <p>
         * The description of a Region switch plan.
         * </p>
         * 
         * @param description
         *        The description of a Region switch plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        /**
         * <p>
         * An array of workflows included in a Region switch plan.
         * </p>
         * 
         * @param workflows
         *        An array of workflows included in a Region switch plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflows(Collection<Workflow> workflows);

        /**
         * <p>
         * An array of workflows included in a Region switch plan.
         * </p>
         * 
         * @param workflows
         *        An array of workflows included in a Region switch plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workflows(Workflow... workflows);

        /**
         * <p>
         * An array of workflows included in a Region switch plan.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.arcregionswitch.model.Workflow.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.arcregionswitch.model.Workflow#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.arcregionswitch.model.Workflow.Builder#build()} is called immediately
         * and its result is passed to {@link #workflows(List<Workflow>)}.
         * 
         * @param workflows
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.arcregionswitch.model.Workflow.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workflows(java.util.Collection<Workflow>)
         */
        Builder workflows(Consumer<Workflow.Builder>... workflows);

        /**
         * <p>
         * An execution role is a way to categorize a Region switch plan.
         * </p>
         * 
         * @param executionRole
         *        An execution role is a way to categorize a Region switch plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionRole(String executionRole);

        /**
         * <p>
         * Optionally, you can specify an recovery time objective for a Region switch plan, in minutes.
         * </p>
         * 
         * @param recoveryTimeObjectiveMinutes
         *        Optionally, you can specify an recovery time objective for a Region switch plan, in minutes.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder recoveryTimeObjectiveMinutes(Integer recoveryTimeObjectiveMinutes);

        /**
         * <p>
         * The alarms associated with a Region switch plan.
         * </p>
         * 
         * @param associatedAlarms
         *        The alarms associated with a Region switch plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder associatedAlarms(Map<String, AssociatedAlarm> associatedAlarms);

        /**
         * <p>
         * The triggers associated with a Region switch plan.
         * </p>
         * 
         * @param triggers
         *        The triggers associated with a Region switch plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggers(Collection<Trigger> triggers);

        /**
         * <p>
         * The triggers associated with a Region switch plan.
         * </p>
         * 
         * @param triggers
         *        The triggers associated with a Region switch plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder triggers(Trigger... triggers);

        /**
         * <p>
         * The triggers associated with a Region switch plan.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.arcregionswitch.model.Trigger.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.arcregionswitch.model.Trigger#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.arcregionswitch.model.Trigger.Builder#build()} is called immediately
         * and its result is passed to {@link #triggers(List<Trigger>)}.
         * 
         * @param triggers
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.arcregionswitch.model.Trigger.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #triggers(java.util.Collection<Trigger>)
         */
        Builder triggers(Consumer<Trigger.Builder>... triggers);

        /**
         * <p>
         * The name of a Region switch plan.
         * </p>
         * 
         * @param name
         *        The name of a Region switch plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * An array that specifies the Amazon Web Services Regions for a Region switch plan. Specify two Regions.
         * </p>
         * 
         * @param regions
         *        An array that specifies the Amazon Web Services Regions for a Region switch plan. Specify two Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(Collection<String> regions);

        /**
         * <p>
         * An array that specifies the Amazon Web Services Regions for a Region switch plan. Specify two Regions.
         * </p>
         * 
         * @param regions
         *        An array that specifies the Amazon Web Services Regions for a Region switch plan. Specify two Regions.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regions(String... regions);

        /**
         * <p>
         * The recovery approach for a Region switch plan, which can be active/active (activeActive) or active/passive
         * (activePassive).
         * </p>
         * 
         * @param recoveryApproach
         *        The recovery approach for a Region switch plan, which can be active/active (activeActive) or
         *        active/passive (activePassive).
         * @see RecoveryApproach
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecoveryApproach
         */
        Builder recoveryApproach(String recoveryApproach);

        /**
         * <p>
         * The recovery approach for a Region switch plan, which can be active/active (activeActive) or active/passive
         * (activePassive).
         * </p>
         * 
         * @param recoveryApproach
         *        The recovery approach for a Region switch plan, which can be active/active (activeActive) or
         *        active/passive (activePassive).
         * @see RecoveryApproach
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RecoveryApproach
         */
        Builder recoveryApproach(RecoveryApproach recoveryApproach);

        /**
         * <p>
         * The primary Amazon Web Services Region for the application. This is the Region where the application normally
         * runs before any Region switch occurs.
         * </p>
         * 
         * @param primaryRegion
         *        The primary Amazon Web Services Region for the application. This is the Region where the application
         *        normally runs before any Region switch occurs.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder primaryRegion(String primaryRegion);

        /**
         * <p>
         * The tags to apply to the Region switch plan.
         * </p>
         * 
         * @param tags
         *        The tags to apply to the Region switch plan.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder tags(Map<String, String> tags);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends ArcRegionSwitchRequest.BuilderImpl implements Builder {
        private String description;

        private List<Workflow> workflows = DefaultSdkAutoConstructList.getInstance();

        private String executionRole;

        private Integer recoveryTimeObjectiveMinutes;

        private Map<String, AssociatedAlarm> associatedAlarms = DefaultSdkAutoConstructMap.getInstance();

        private List<Trigger> triggers = DefaultSdkAutoConstructList.getInstance();

        private String name;

        private List<String> regions = DefaultSdkAutoConstructList.getInstance();

        private String recoveryApproach;

        private String primaryRegion;

        private Map<String, String> tags = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CreatePlanRequest model) {
            super(model);
            description(model.description);
            workflows(model.workflows);
            executionRole(model.executionRole);
            recoveryTimeObjectiveMinutes(model.recoveryTimeObjectiveMinutes);
            associatedAlarms(model.associatedAlarms);
            triggers(model.triggers);
            name(model.name);
            regions(model.regions);
            recoveryApproach(model.recoveryApproach);
            primaryRegion(model.primaryRegion);
            tags(model.tags);
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Workflow.Builder> getWorkflows() {
            List<Workflow.Builder> result = WorkflowListCopier.copyToBuilder(this.workflows);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setWorkflows(Collection<Workflow.BuilderImpl> workflows) {
            this.workflows = WorkflowListCopier.copyFromBuilder(workflows);
        }

        @Override
        public final Builder workflows(Collection<Workflow> workflows) {
            this.workflows = WorkflowListCopier.copy(workflows);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(Workflow... workflows) {
            workflows(Arrays.asList(workflows));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder workflows(Consumer<Workflow.Builder>... workflows) {
            workflows(Stream.of(workflows).map(c -> Workflow.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getExecutionRole() {
            return executionRole;
        }

        public final void setExecutionRole(String executionRole) {
            this.executionRole = executionRole;
        }

        @Override
        public final Builder executionRole(String executionRole) {
            this.executionRole = executionRole;
            return this;
        }

        public final Integer getRecoveryTimeObjectiveMinutes() {
            return recoveryTimeObjectiveMinutes;
        }

        public final void setRecoveryTimeObjectiveMinutes(Integer recoveryTimeObjectiveMinutes) {
            this.recoveryTimeObjectiveMinutes = recoveryTimeObjectiveMinutes;
        }

        @Override
        public final Builder recoveryTimeObjectiveMinutes(Integer recoveryTimeObjectiveMinutes) {
            this.recoveryTimeObjectiveMinutes = recoveryTimeObjectiveMinutes;
            return this;
        }

        public final Map<String, AssociatedAlarm.Builder> getAssociatedAlarms() {
            Map<String, AssociatedAlarm.Builder> result = AssociatedAlarmMapCopier.copyToBuilder(this.associatedAlarms);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAssociatedAlarms(Map<String, AssociatedAlarm.BuilderImpl> associatedAlarms) {
            this.associatedAlarms = AssociatedAlarmMapCopier.copyFromBuilder(associatedAlarms);
        }

        @Override
        public final Builder associatedAlarms(Map<String, AssociatedAlarm> associatedAlarms) {
            this.associatedAlarms = AssociatedAlarmMapCopier.copy(associatedAlarms);
            return this;
        }

        public final List<Trigger.Builder> getTriggers() {
            List<Trigger.Builder> result = TriggerListCopier.copyToBuilder(this.triggers);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTriggers(Collection<Trigger.BuilderImpl> triggers) {
            this.triggers = TriggerListCopier.copyFromBuilder(triggers);
        }

        @Override
        public final Builder triggers(Collection<Trigger> triggers) {
            this.triggers = TriggerListCopier.copy(triggers);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Trigger... triggers) {
            triggers(Arrays.asList(triggers));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder triggers(Consumer<Trigger.Builder>... triggers) {
            triggers(Stream.of(triggers).map(c -> Trigger.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final Collection<String> getRegions() {
            if (regions instanceof SdkAutoConstructList) {
                return null;
            }
            return regions;
        }

        public final void setRegions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
        }

        @Override
        public final Builder regions(Collection<String> regions) {
            this.regions = RegionListCopier.copy(regions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder regions(String... regions) {
            regions(Arrays.asList(regions));
            return this;
        }

        public final String getRecoveryApproach() {
            return recoveryApproach;
        }

        public final void setRecoveryApproach(String recoveryApproach) {
            this.recoveryApproach = recoveryApproach;
        }

        @Override
        public final Builder recoveryApproach(String recoveryApproach) {
            this.recoveryApproach = recoveryApproach;
            return this;
        }

        @Override
        public final Builder recoveryApproach(RecoveryApproach recoveryApproach) {
            this.recoveryApproach(recoveryApproach == null ? null : recoveryApproach.toString());
            return this;
        }

        public final String getPrimaryRegion() {
            return primaryRegion;
        }

        public final void setPrimaryRegion(String primaryRegion) {
            this.primaryRegion = primaryRegion;
        }

        @Override
        public final Builder primaryRegion(String primaryRegion) {
            this.primaryRegion = primaryRegion;
            return this;
        }

        public final Map<String, String> getTags() {
            if (tags instanceof SdkAutoConstructMap) {
                return null;
            }
            return tags;
        }

        public final void setTags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
        }

        @Override
        public final Builder tags(Map<String, String> tags) {
            this.tags = TagsCopier.copy(tags);
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreatePlanRequest build() {
            return new CreatePlanRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
