/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.arcregionswitch.endpoints.internal;

import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletionException;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.awscore.AwsExecutionAttribute;
import software.amazon.awssdk.awscore.endpoints.AwsEndpointAttribute;
import software.amazon.awssdk.awscore.endpoints.authscheme.EndpointAuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4AuthScheme;
import software.amazon.awssdk.awscore.endpoints.authscheme.SigV4aAuthScheme;
import software.amazon.awssdk.core.SdkRequest;
import software.amazon.awssdk.core.SelectedAuthScheme;
import software.amazon.awssdk.core.exception.SdkClientException;
import software.amazon.awssdk.core.interceptor.Context;
import software.amazon.awssdk.core.interceptor.ExecutionAttributes;
import software.amazon.awssdk.core.interceptor.ExecutionInterceptor;
import software.amazon.awssdk.core.interceptor.SdkExecutionAttribute;
import software.amazon.awssdk.core.interceptor.SdkInternalExecutionAttribute;
import software.amazon.awssdk.core.metrics.CoreMetric;
import software.amazon.awssdk.endpoints.Endpoint;
import software.amazon.awssdk.http.SdkHttpRequest;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4HttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.AwsV4aHttpSigner;
import software.amazon.awssdk.http.auth.aws.signer.RegionSet;
import software.amazon.awssdk.http.auth.spi.scheme.AuthSchemeOption;
import software.amazon.awssdk.identity.spi.Identity;
import software.amazon.awssdk.services.arcregionswitch.endpoints.ArcRegionSwitchEndpointParams;
import software.amazon.awssdk.services.arcregionswitch.endpoints.ArcRegionSwitchEndpointProvider;
import software.amazon.awssdk.services.arcregionswitch.endpoints.internal.AwsEndpointProviderUtils;
import software.amazon.awssdk.utils.CollectionUtils;

@SdkInternalApi
public final class ArcRegionSwitchResolveEndpointInterceptor
implements ExecutionInterceptor {
    public SdkRequest modifyRequest(Context.ModifyRequest context, ExecutionAttributes executionAttributes) {
        SdkRequest result = context.request();
        if (AwsEndpointProviderUtils.endpointIsDiscovered(executionAttributes)) {
            return result;
        }
        ArcRegionSwitchEndpointProvider provider = (ArcRegionSwitchEndpointProvider)executionAttributes.getAttribute(SdkInternalExecutionAttribute.ENDPOINT_PROVIDER);
        try {
            Optional<String> hostPrefix;
            long resolveEndpointStart = System.nanoTime();
            ArcRegionSwitchEndpointParams endpointParams = ArcRegionSwitchResolveEndpointInterceptor.ruleParams(result, executionAttributes);
            Endpoint endpoint = provider.resolveEndpoint(endpointParams).join();
            Duration resolveEndpointDuration = Duration.ofNanos(System.nanoTime() - resolveEndpointStart);
            Optional metricCollector = executionAttributes.getOptionalAttribute(SdkExecutionAttribute.API_CALL_METRIC_COLLECTOR);
            metricCollector.ifPresent(mc -> mc.reportMetric(CoreMetric.ENDPOINT_RESOLVE_DURATION, (Object)resolveEndpointDuration));
            if (!AwsEndpointProviderUtils.disableHostPrefixInjection(executionAttributes) && (hostPrefix = ArcRegionSwitchResolveEndpointInterceptor.hostPrefix((String)executionAttributes.getAttribute(SdkExecutionAttribute.OPERATION_NAME), result)).isPresent()) {
                endpoint = AwsEndpointProviderUtils.addHostPrefix(endpoint, hostPrefix.get());
            }
            List endpointAuthSchemes = (List)endpoint.attribute(AwsEndpointAttribute.AUTH_SCHEMES);
            SelectedAuthScheme selectedAuthScheme = (SelectedAuthScheme)executionAttributes.getAttribute(SdkInternalExecutionAttribute.SELECTED_AUTH_SCHEME);
            if (endpointAuthSchemes != null && selectedAuthScheme != null) {
                selectedAuthScheme = this.authSchemeWithEndpointSignerProperties(endpointAuthSchemes, selectedAuthScheme);
                executionAttributes.putAttribute(SdkInternalExecutionAttribute.SELECTED_AUTH_SCHEME, selectedAuthScheme);
            }
            executionAttributes.putAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT, (Object)endpoint);
            this.setMetricValues(endpoint, executionAttributes);
            return result;
        }
        catch (CompletionException e) {
            Throwable cause = e.getCause();
            if (cause instanceof SdkClientException) {
                throw (SdkClientException)cause;
            }
            throw SdkClientException.create((String)"Endpoint resolution failed", (Throwable)cause);
        }
    }

    public SdkHttpRequest modifyHttpRequest(Context.ModifyHttpRequest context, ExecutionAttributes executionAttributes) {
        Endpoint resolvedEndpoint = (Endpoint)executionAttributes.getAttribute(SdkInternalExecutionAttribute.RESOLVED_ENDPOINT);
        if (resolvedEndpoint.headers().isEmpty()) {
            return context.httpRequest();
        }
        SdkHttpRequest.Builder httpRequestBuilder = (SdkHttpRequest.Builder)context.httpRequest().toBuilder();
        resolvedEndpoint.headers().forEach((name, values) -> values.forEach(v -> httpRequestBuilder.appendHeader(name, v)));
        return (SdkHttpRequest)httpRequestBuilder.build();
    }

    public static ArcRegionSwitchEndpointParams ruleParams(SdkRequest request, ExecutionAttributes executionAttributes) {
        ArcRegionSwitchEndpointParams.Builder builder = ArcRegionSwitchEndpointParams.builder();
        builder.useFips(AwsEndpointProviderUtils.fipsEnabledBuiltIn(executionAttributes));
        builder.endpoint(AwsEndpointProviderUtils.endpointBuiltIn(executionAttributes));
        builder.region(AwsEndpointProviderUtils.regionBuiltIn(executionAttributes));
        ArcRegionSwitchResolveEndpointInterceptor.setContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME), request);
        ArcRegionSwitchResolveEndpointInterceptor.setStaticContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME));
        ArcRegionSwitchResolveEndpointInterceptor.setOperationContextParams(builder, (String)executionAttributes.getAttribute(AwsExecutionAttribute.OPERATION_NAME), request);
        return builder.build();
    }

    private static void setContextParams(ArcRegionSwitchEndpointParams.Builder params, String operationName, SdkRequest request) {
    }

    private static void setStaticContextParams(ArcRegionSwitchEndpointParams.Builder params, String operationName) {
        switch (operationName) {
            case "CreatePlan": {
                ArcRegionSwitchResolveEndpointInterceptor.createPlanStaticContextParams(params);
                break;
            }
            case "DeletePlan": {
                ArcRegionSwitchResolveEndpointInterceptor.deletePlanStaticContextParams(params);
                break;
            }
            case "GetPlan": {
                ArcRegionSwitchResolveEndpointInterceptor.getPlanStaticContextParams(params);
                break;
            }
            case "ListPlans": {
                ArcRegionSwitchResolveEndpointInterceptor.listPlansStaticContextParams(params);
                break;
            }
            case "ListRoute53HealthChecks": {
                ArcRegionSwitchResolveEndpointInterceptor.listRoute53HealthChecksStaticContextParams(params);
                break;
            }
            case "ListTagsForResource": {
                ArcRegionSwitchResolveEndpointInterceptor.listTagsForResourceStaticContextParams(params);
                break;
            }
            case "TagResource": {
                ArcRegionSwitchResolveEndpointInterceptor.tagResourceStaticContextParams(params);
                break;
            }
            case "UntagResource": {
                ArcRegionSwitchResolveEndpointInterceptor.untagResourceStaticContextParams(params);
                break;
            }
            case "UpdatePlan": {
                ArcRegionSwitchResolveEndpointInterceptor.updatePlanStaticContextParams(params);
                break;
            }
        }
    }

    private static void createPlanStaticContextParams(ArcRegionSwitchEndpointParams.Builder params) {
        params.useControlPlaneEndpoint(true);
    }

    private static void deletePlanStaticContextParams(ArcRegionSwitchEndpointParams.Builder params) {
        params.useControlPlaneEndpoint(true);
    }

    private static void getPlanStaticContextParams(ArcRegionSwitchEndpointParams.Builder params) {
        params.useControlPlaneEndpoint(true);
    }

    private static void listPlansStaticContextParams(ArcRegionSwitchEndpointParams.Builder params) {
        params.useControlPlaneEndpoint(true);
    }

    private static void listRoute53HealthChecksStaticContextParams(ArcRegionSwitchEndpointParams.Builder params) {
        params.useControlPlaneEndpoint(true);
    }

    private static void listTagsForResourceStaticContextParams(ArcRegionSwitchEndpointParams.Builder params) {
        params.useControlPlaneEndpoint(true);
    }

    private static void tagResourceStaticContextParams(ArcRegionSwitchEndpointParams.Builder params) {
        params.useControlPlaneEndpoint(true);
    }

    private static void untagResourceStaticContextParams(ArcRegionSwitchEndpointParams.Builder params) {
        params.useControlPlaneEndpoint(true);
    }

    private static void updatePlanStaticContextParams(ArcRegionSwitchEndpointParams.Builder params) {
        params.useControlPlaneEndpoint(true);
    }

    private <T extends Identity> SelectedAuthScheme<T> authSchemeWithEndpointSignerProperties(List<EndpointAuthScheme> endpointAuthSchemes, SelectedAuthScheme<T> selectedAuthScheme) {
        for (EndpointAuthScheme endpointAuthScheme : endpointAuthSchemes) {
            if (!endpointAuthScheme.schemeId().equals(selectedAuthScheme.authSchemeOption().schemeId())) continue;
            AuthSchemeOption.Builder option = (AuthSchemeOption.Builder)selectedAuthScheme.authSchemeOption().toBuilder();
            if (endpointAuthScheme instanceof SigV4AuthScheme) {
                SigV4AuthScheme v4AuthScheme = (SigV4AuthScheme)endpointAuthScheme;
                if (v4AuthScheme.isDisableDoubleEncodingSet()) {
                    option.putSignerProperty(AwsV4HttpSigner.DOUBLE_URL_ENCODE, (Object)(!v4AuthScheme.disableDoubleEncoding() ? 1 : 0));
                }
                if (v4AuthScheme.signingRegion() != null) {
                    option.putSignerProperty(AwsV4HttpSigner.REGION_NAME, (Object)v4AuthScheme.signingRegion());
                }
                if (v4AuthScheme.signingName() != null) {
                    option.putSignerProperty(AwsV4HttpSigner.SERVICE_SIGNING_NAME, (Object)v4AuthScheme.signingName());
                }
                return new SelectedAuthScheme(selectedAuthScheme.identity(), selectedAuthScheme.signer(), (AuthSchemeOption)option.build());
            }
            if (endpointAuthScheme instanceof SigV4aAuthScheme) {
                SigV4aAuthScheme v4aAuthScheme = (SigV4aAuthScheme)endpointAuthScheme;
                if (v4aAuthScheme.isDisableDoubleEncodingSet()) {
                    option.putSignerProperty(AwsV4aHttpSigner.DOUBLE_URL_ENCODE, (Object)(!v4aAuthScheme.disableDoubleEncoding() ? 1 : 0));
                }
                if (!CollectionUtils.isNullOrEmpty((Collection)v4aAuthScheme.signingRegionSet())) {
                    RegionSet regionSet = RegionSet.create((Collection)v4aAuthScheme.signingRegionSet());
                    option.putSignerProperty(AwsV4aHttpSigner.REGION_SET, (Object)regionSet);
                }
                if (v4aAuthScheme.signingName() != null) {
                    option.putSignerProperty(AwsV4aHttpSigner.SERVICE_SIGNING_NAME, (Object)v4aAuthScheme.signingName());
                }
                return new SelectedAuthScheme(selectedAuthScheme.identity(), selectedAuthScheme.signer(), (AuthSchemeOption)option.build());
            }
            throw new IllegalArgumentException("Endpoint auth scheme '" + endpointAuthScheme.name() + "' cannot be mapped to the SDK auth scheme. Was it declared in the service's model?");
        }
        return selectedAuthScheme;
    }

    private static void setOperationContextParams(ArcRegionSwitchEndpointParams.Builder params, String operationName, SdkRequest request) {
    }

    private static Optional<String> hostPrefix(String operationName, SdkRequest request) {
        return Optional.empty();
    }

    private void setMetricValues(Endpoint endpoint, ExecutionAttributes executionAttributes) {
        if (endpoint.attribute(AwsEndpointAttribute.METRIC_VALUES) != null) {
            executionAttributes.getOptionalAttribute(SdkInternalExecutionAttribute.BUSINESS_METRICS).ifPresent(metrics -> ((List)endpoint.attribute(AwsEndpointAttribute.METRIC_VALUES)).forEach(v -> metrics.addMetric(v)));
        }
    }
}

