/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.utils.internal.EnumUtils;

@Generated("software.amazon.awssdk:codegen")
public enum ExecutionBlockType {
    CUSTOM_ACTION_LAMBDA("CustomActionLambda"),

    MANUAL_APPROVAL("ManualApproval"),

    AURORA_GLOBAL_DATABASE("AuroraGlobalDatabase"),

    EC2_AUTO_SCALING("EC2AutoScaling"),

    ARC_ROUTING_CONTROL("ARCRoutingControl"),

    ARC_REGION_SWITCH_PLAN("ARCRegionSwitchPlan"),

    PARALLEL("Parallel"),

    ECS_SERVICE_SCALING("ECSServiceScaling"),

    EKS_RESOURCE_SCALING("EKSResourceScaling"),

    ROUTE53_HEALTH_CHECK("Route53HealthCheck"),

    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, ExecutionBlockType> VALUE_MAP = EnumUtils.uniqueIndex(ExecutionBlockType.class,
            ExecutionBlockType::toString);

    private final String value;

    private ExecutionBlockType(String value) {
        this.value = value;
    }

    @Override
    public String toString() {
        return String.valueOf(value);
    }

    /**
     * Use this in place of valueOf to convert the raw string returned by the service into the enum value.
     *
     * @param value
     *        real value
     * @return ExecutionBlockType corresponding to the value
     */
    public static ExecutionBlockType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    /**
     * Use this in place of {@link #values()} to return a {@link Set} of all values known to the SDK. This will return
     * all known enum values except {@link #UNKNOWN_TO_SDK_VERSION}.
     *
     * @return a {@link Set} of known {@link ExecutionBlockType}s
     */
    public static Set<ExecutionBlockType> knownValues() {
        Set<ExecutionBlockType> knownValues = EnumSet.allOf(ExecutionBlockType.class);
        knownValues.remove(UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }
}
