/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.arcregionswitch.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Execution block configurations for a workflow in a Region switch plan. An execution block represents a specific type
 * of action to perform during a Region switch.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ExecutionBlockConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ExecutionBlockConfiguration.Builder, ExecutionBlockConfiguration> {
    private static final SdkField<CustomActionLambdaConfiguration> CUSTOM_ACTION_LAMBDA_CONFIG_FIELD = SdkField
            .<CustomActionLambdaConfiguration> builder(MarshallingType.SDK_POJO).memberName("customActionLambdaConfig")
            .getter(getter(ExecutionBlockConfiguration::customActionLambdaConfig))
            .setter(setter(Builder::customActionLambdaConfig)).constructor(CustomActionLambdaConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customActionLambdaConfig").build())
            .build();

    private static final SdkField<Ec2AsgCapacityIncreaseConfiguration> EC2_ASG_CAPACITY_INCREASE_CONFIG_FIELD = SdkField
            .<Ec2AsgCapacityIncreaseConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("ec2AsgCapacityIncreaseConfig")
            .getter(getter(ExecutionBlockConfiguration::ec2AsgCapacityIncreaseConfig))
            .setter(setter(Builder::ec2AsgCapacityIncreaseConfig))
            .constructor(Ec2AsgCapacityIncreaseConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ec2AsgCapacityIncreaseConfig")
                    .build()).build();

    private static final SdkField<ExecutionApprovalConfiguration> EXECUTION_APPROVAL_CONFIG_FIELD = SdkField
            .<ExecutionApprovalConfiguration> builder(MarshallingType.SDK_POJO).memberName("executionApprovalConfig")
            .getter(getter(ExecutionBlockConfiguration::executionApprovalConfig))
            .setter(setter(Builder::executionApprovalConfig)).constructor(ExecutionApprovalConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("executionApprovalConfig").build())
            .build();

    private static final SdkField<ArcRoutingControlConfiguration> ARC_ROUTING_CONTROL_CONFIG_FIELD = SdkField
            .<ArcRoutingControlConfiguration> builder(MarshallingType.SDK_POJO).memberName("arcRoutingControlConfig")
            .getter(getter(ExecutionBlockConfiguration::arcRoutingControlConfig))
            .setter(setter(Builder::arcRoutingControlConfig)).constructor(ArcRoutingControlConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("arcRoutingControlConfig").build())
            .build();

    private static final SdkField<GlobalAuroraConfiguration> GLOBAL_AURORA_CONFIG_FIELD = SdkField
            .<GlobalAuroraConfiguration> builder(MarshallingType.SDK_POJO).memberName("globalAuroraConfig")
            .getter(getter(ExecutionBlockConfiguration::globalAuroraConfig)).setter(setter(Builder::globalAuroraConfig))
            .constructor(GlobalAuroraConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("globalAuroraConfig").build())
            .build();

    private static final SdkField<ParallelExecutionBlockConfiguration> PARALLEL_CONFIG_FIELD = SdkField
            .<ParallelExecutionBlockConfiguration> builder(MarshallingType.SDK_POJO).memberName("parallelConfig")
            .getter(getter(ExecutionBlockConfiguration::parallelConfig)).setter(setter(Builder::parallelConfig))
            .constructor(ParallelExecutionBlockConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parallelConfig").build()).build();

    private static final SdkField<RegionSwitchPlanConfiguration> REGION_SWITCH_PLAN_CONFIG_FIELD = SdkField
            .<RegionSwitchPlanConfiguration> builder(MarshallingType.SDK_POJO).memberName("regionSwitchPlanConfig")
            .getter(getter(ExecutionBlockConfiguration::regionSwitchPlanConfig)).setter(setter(Builder::regionSwitchPlanConfig))
            .constructor(RegionSwitchPlanConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("regionSwitchPlanConfig").build())
            .build();

    private static final SdkField<EcsCapacityIncreaseConfiguration> ECS_CAPACITY_INCREASE_CONFIG_FIELD = SdkField
            .<EcsCapacityIncreaseConfiguration> builder(MarshallingType.SDK_POJO).memberName("ecsCapacityIncreaseConfig")
            .getter(getter(ExecutionBlockConfiguration::ecsCapacityIncreaseConfig))
            .setter(setter(Builder::ecsCapacityIncreaseConfig)).constructor(EcsCapacityIncreaseConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("ecsCapacityIncreaseConfig").build())
            .build();

    private static final SdkField<EksResourceScalingConfiguration> EKS_RESOURCE_SCALING_CONFIG_FIELD = SdkField
            .<EksResourceScalingConfiguration> builder(MarshallingType.SDK_POJO).memberName("eksResourceScalingConfig")
            .getter(getter(ExecutionBlockConfiguration::eksResourceScalingConfig))
            .setter(setter(Builder::eksResourceScalingConfig)).constructor(EksResourceScalingConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("eksResourceScalingConfig").build())
            .build();

    private static final SdkField<Route53HealthCheckConfiguration> ROUTE53_HEALTH_CHECK_CONFIG_FIELD = SdkField
            .<Route53HealthCheckConfiguration> builder(MarshallingType.SDK_POJO).memberName("route53HealthCheckConfig")
            .getter(getter(ExecutionBlockConfiguration::route53HealthCheckConfig))
            .setter(setter(Builder::route53HealthCheckConfig)).constructor(Route53HealthCheckConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("route53HealthCheckConfig").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            CUSTOM_ACTION_LAMBDA_CONFIG_FIELD, EC2_ASG_CAPACITY_INCREASE_CONFIG_FIELD, EXECUTION_APPROVAL_CONFIG_FIELD,
            ARC_ROUTING_CONTROL_CONFIG_FIELD, GLOBAL_AURORA_CONFIG_FIELD, PARALLEL_CONFIG_FIELD, REGION_SWITCH_PLAN_CONFIG_FIELD,
            ECS_CAPACITY_INCREASE_CONFIG_FIELD, EKS_RESOURCE_SCALING_CONFIG_FIELD, ROUTE53_HEALTH_CHECK_CONFIG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CustomActionLambdaConfiguration customActionLambdaConfig;

    private final Ec2AsgCapacityIncreaseConfiguration ec2AsgCapacityIncreaseConfig;

    private final ExecutionApprovalConfiguration executionApprovalConfig;

    private final ArcRoutingControlConfiguration arcRoutingControlConfig;

    private final GlobalAuroraConfiguration globalAuroraConfig;

    private final ParallelExecutionBlockConfiguration parallelConfig;

    private final RegionSwitchPlanConfiguration regionSwitchPlanConfig;

    private final EcsCapacityIncreaseConfiguration ecsCapacityIncreaseConfig;

    private final EksResourceScalingConfiguration eksResourceScalingConfig;

    private final Route53HealthCheckConfiguration route53HealthCheckConfig;

    private final Type type;

    private ExecutionBlockConfiguration(BuilderImpl builder) {
        this.customActionLambdaConfig = builder.customActionLambdaConfig;
        this.ec2AsgCapacityIncreaseConfig = builder.ec2AsgCapacityIncreaseConfig;
        this.executionApprovalConfig = builder.executionApprovalConfig;
        this.arcRoutingControlConfig = builder.arcRoutingControlConfig;
        this.globalAuroraConfig = builder.globalAuroraConfig;
        this.parallelConfig = builder.parallelConfig;
        this.regionSwitchPlanConfig = builder.regionSwitchPlanConfig;
        this.ecsCapacityIncreaseConfig = builder.ecsCapacityIncreaseConfig;
        this.eksResourceScalingConfig = builder.eksResourceScalingConfig;
        this.route53HealthCheckConfig = builder.route53HealthCheckConfig;
        this.type = builder.type;
    }

    /**
     * <p>
     * An Amazon Web Services Lambda execution block.
     * </p>
     * 
     * @return An Amazon Web Services Lambda execution block.
     */
    public final CustomActionLambdaConfiguration customActionLambdaConfig() {
        return customActionLambdaConfig;
    }

    /**
     * <p>
     * An EC2 Auto Scaling group execution block.
     * </p>
     * 
     * @return An EC2 Auto Scaling group execution block.
     */
    public final Ec2AsgCapacityIncreaseConfiguration ec2AsgCapacityIncreaseConfig() {
        return ec2AsgCapacityIncreaseConfig;
    }

    /**
     * <p>
     * A manual approval execution block.
     * </p>
     * 
     * @return A manual approval execution block.
     */
    public final ExecutionApprovalConfiguration executionApprovalConfig() {
        return executionApprovalConfig;
    }

    /**
     * <p>
     * An ARC routing control execution block.
     * </p>
     * 
     * @return An ARC routing control execution block.
     */
    public final ArcRoutingControlConfiguration arcRoutingControlConfig() {
        return arcRoutingControlConfig;
    }

    /**
     * <p>
     * An Aurora Global Database execution block.
     * </p>
     * 
     * @return An Aurora Global Database execution block.
     */
    public final GlobalAuroraConfiguration globalAuroraConfig() {
        return globalAuroraConfig;
    }

    /**
     * <p>
     * A parallel configuration execution block.
     * </p>
     * 
     * @return A parallel configuration execution block.
     */
    public final ParallelExecutionBlockConfiguration parallelConfig() {
        return parallelConfig;
    }

    /**
     * <p>
     * A Region switch plan execution block.
     * </p>
     * 
     * @return A Region switch plan execution block.
     */
    public final RegionSwitchPlanConfiguration regionSwitchPlanConfig() {
        return regionSwitchPlanConfig;
    }

    /**
     * <p>
     * The capacity increase specified for the configuration.
     * </p>
     * 
     * @return The capacity increase specified for the configuration.
     */
    public final EcsCapacityIncreaseConfiguration ecsCapacityIncreaseConfig() {
        return ecsCapacityIncreaseConfig;
    }

    /**
     * <p>
     * An Amazon Web Services EKS resource scaling execution block.
     * </p>
     * 
     * @return An Amazon Web Services EKS resource scaling execution block.
     */
    public final EksResourceScalingConfiguration eksResourceScalingConfig() {
        return eksResourceScalingConfig;
    }

    /**
     * <p>
     * The Amazon Route 53 health check configuration.
     * </p>
     * 
     * @return The Amazon Route 53 health check configuration.
     */
    public final Route53HealthCheckConfiguration route53HealthCheckConfig() {
        return route53HealthCheckConfig;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customActionLambdaConfig());
        hashCode = 31 * hashCode + Objects.hashCode(ec2AsgCapacityIncreaseConfig());
        hashCode = 31 * hashCode + Objects.hashCode(executionApprovalConfig());
        hashCode = 31 * hashCode + Objects.hashCode(arcRoutingControlConfig());
        hashCode = 31 * hashCode + Objects.hashCode(globalAuroraConfig());
        hashCode = 31 * hashCode + Objects.hashCode(parallelConfig());
        hashCode = 31 * hashCode + Objects.hashCode(regionSwitchPlanConfig());
        hashCode = 31 * hashCode + Objects.hashCode(ecsCapacityIncreaseConfig());
        hashCode = 31 * hashCode + Objects.hashCode(eksResourceScalingConfig());
        hashCode = 31 * hashCode + Objects.hashCode(route53HealthCheckConfig());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ExecutionBlockConfiguration)) {
            return false;
        }
        ExecutionBlockConfiguration other = (ExecutionBlockConfiguration) obj;
        return Objects.equals(customActionLambdaConfig(), other.customActionLambdaConfig())
                && Objects.equals(ec2AsgCapacityIncreaseConfig(), other.ec2AsgCapacityIncreaseConfig())
                && Objects.equals(executionApprovalConfig(), other.executionApprovalConfig())
                && Objects.equals(arcRoutingControlConfig(), other.arcRoutingControlConfig())
                && Objects.equals(globalAuroraConfig(), other.globalAuroraConfig())
                && Objects.equals(parallelConfig(), other.parallelConfig())
                && Objects.equals(regionSwitchPlanConfig(), other.regionSwitchPlanConfig())
                && Objects.equals(ecsCapacityIncreaseConfig(), other.ecsCapacityIncreaseConfig())
                && Objects.equals(eksResourceScalingConfig(), other.eksResourceScalingConfig())
                && Objects.equals(route53HealthCheckConfig(), other.route53HealthCheckConfig());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ExecutionBlockConfiguration").add("CustomActionLambdaConfig", customActionLambdaConfig())
                .add("Ec2AsgCapacityIncreaseConfig", ec2AsgCapacityIncreaseConfig())
                .add("ExecutionApprovalConfig", executionApprovalConfig())
                .add("ArcRoutingControlConfig", arcRoutingControlConfig()).add("GlobalAuroraConfig", globalAuroraConfig())
                .add("ParallelConfig", parallelConfig()).add("RegionSwitchPlanConfig", regionSwitchPlanConfig())
                .add("EcsCapacityIncreaseConfig", ecsCapacityIncreaseConfig())
                .add("EksResourceScalingConfig", eksResourceScalingConfig())
                .add("Route53HealthCheckConfig", route53HealthCheckConfig()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customActionLambdaConfig":
            return Optional.ofNullable(clazz.cast(customActionLambdaConfig()));
        case "ec2AsgCapacityIncreaseConfig":
            return Optional.ofNullable(clazz.cast(ec2AsgCapacityIncreaseConfig()));
        case "executionApprovalConfig":
            return Optional.ofNullable(clazz.cast(executionApprovalConfig()));
        case "arcRoutingControlConfig":
            return Optional.ofNullable(clazz.cast(arcRoutingControlConfig()));
        case "globalAuroraConfig":
            return Optional.ofNullable(clazz.cast(globalAuroraConfig()));
        case "parallelConfig":
            return Optional.ofNullable(clazz.cast(parallelConfig()));
        case "regionSwitchPlanConfig":
            return Optional.ofNullable(clazz.cast(regionSwitchPlanConfig()));
        case "ecsCapacityIncreaseConfig":
            return Optional.ofNullable(clazz.cast(ecsCapacityIncreaseConfig()));
        case "eksResourceScalingConfig":
            return Optional.ofNullable(clazz.cast(eksResourceScalingConfig()));
        case "route53HealthCheckConfig":
            return Optional.ofNullable(clazz.cast(route53HealthCheckConfig()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #customActionLambdaConfig()} initialized to the given value.
     *
     * <p>
     * An Amazon Web Services Lambda execution block.
     * </p>
     * 
     * @param customActionLambdaConfig
     *        An Amazon Web Services Lambda execution block.
     */
    public static ExecutionBlockConfiguration fromCustomActionLambdaConfig(
            CustomActionLambdaConfiguration customActionLambdaConfig) {
        return builder().customActionLambdaConfig(customActionLambdaConfig).build();
    }

    /**
     * Create an instance of this class with {@link #customActionLambdaConfig()} initialized to the given value.
     *
     * <p>
     * An Amazon Web Services Lambda execution block.
     * </p>
     * 
     * @param customActionLambdaConfig
     *        An Amazon Web Services Lambda execution block.
     */
    public static ExecutionBlockConfiguration fromCustomActionLambdaConfig(
            Consumer<CustomActionLambdaConfiguration.Builder> customActionLambdaConfig) {
        CustomActionLambdaConfiguration.Builder builder = CustomActionLambdaConfiguration.builder();
        customActionLambdaConfig.accept(builder);
        return fromCustomActionLambdaConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ec2AsgCapacityIncreaseConfig()} initialized to the given value.
     *
     * <p>
     * An EC2 Auto Scaling group execution block.
     * </p>
     * 
     * @param ec2AsgCapacityIncreaseConfig
     *        An EC2 Auto Scaling group execution block.
     */
    public static ExecutionBlockConfiguration fromEc2AsgCapacityIncreaseConfig(
            Ec2AsgCapacityIncreaseConfiguration ec2AsgCapacityIncreaseConfig) {
        return builder().ec2AsgCapacityIncreaseConfig(ec2AsgCapacityIncreaseConfig).build();
    }

    /**
     * Create an instance of this class with {@link #ec2AsgCapacityIncreaseConfig()} initialized to the given value.
     *
     * <p>
     * An EC2 Auto Scaling group execution block.
     * </p>
     * 
     * @param ec2AsgCapacityIncreaseConfig
     *        An EC2 Auto Scaling group execution block.
     */
    public static ExecutionBlockConfiguration fromEc2AsgCapacityIncreaseConfig(
            Consumer<Ec2AsgCapacityIncreaseConfiguration.Builder> ec2AsgCapacityIncreaseConfig) {
        Ec2AsgCapacityIncreaseConfiguration.Builder builder = Ec2AsgCapacityIncreaseConfiguration.builder();
        ec2AsgCapacityIncreaseConfig.accept(builder);
        return fromEc2AsgCapacityIncreaseConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #executionApprovalConfig()} initialized to the given value.
     *
     * <p>
     * A manual approval execution block.
     * </p>
     * 
     * @param executionApprovalConfig
     *        A manual approval execution block.
     */
    public static ExecutionBlockConfiguration fromExecutionApprovalConfig(ExecutionApprovalConfiguration executionApprovalConfig) {
        return builder().executionApprovalConfig(executionApprovalConfig).build();
    }

    /**
     * Create an instance of this class with {@link #executionApprovalConfig()} initialized to the given value.
     *
     * <p>
     * A manual approval execution block.
     * </p>
     * 
     * @param executionApprovalConfig
     *        A manual approval execution block.
     */
    public static ExecutionBlockConfiguration fromExecutionApprovalConfig(
            Consumer<ExecutionApprovalConfiguration.Builder> executionApprovalConfig) {
        ExecutionApprovalConfiguration.Builder builder = ExecutionApprovalConfiguration.builder();
        executionApprovalConfig.accept(builder);
        return fromExecutionApprovalConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #arcRoutingControlConfig()} initialized to the given value.
     *
     * <p>
     * An ARC routing control execution block.
     * </p>
     * 
     * @param arcRoutingControlConfig
     *        An ARC routing control execution block.
     */
    public static ExecutionBlockConfiguration fromArcRoutingControlConfig(ArcRoutingControlConfiguration arcRoutingControlConfig) {
        return builder().arcRoutingControlConfig(arcRoutingControlConfig).build();
    }

    /**
     * Create an instance of this class with {@link #arcRoutingControlConfig()} initialized to the given value.
     *
     * <p>
     * An ARC routing control execution block.
     * </p>
     * 
     * @param arcRoutingControlConfig
     *        An ARC routing control execution block.
     */
    public static ExecutionBlockConfiguration fromArcRoutingControlConfig(
            Consumer<ArcRoutingControlConfiguration.Builder> arcRoutingControlConfig) {
        ArcRoutingControlConfiguration.Builder builder = ArcRoutingControlConfiguration.builder();
        arcRoutingControlConfig.accept(builder);
        return fromArcRoutingControlConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #globalAuroraConfig()} initialized to the given value.
     *
     * <p>
     * An Aurora Global Database execution block.
     * </p>
     * 
     * @param globalAuroraConfig
     *        An Aurora Global Database execution block.
     */
    public static ExecutionBlockConfiguration fromGlobalAuroraConfig(GlobalAuroraConfiguration globalAuroraConfig) {
        return builder().globalAuroraConfig(globalAuroraConfig).build();
    }

    /**
     * Create an instance of this class with {@link #globalAuroraConfig()} initialized to the given value.
     *
     * <p>
     * An Aurora Global Database execution block.
     * </p>
     * 
     * @param globalAuroraConfig
     *        An Aurora Global Database execution block.
     */
    public static ExecutionBlockConfiguration fromGlobalAuroraConfig(
            Consumer<GlobalAuroraConfiguration.Builder> globalAuroraConfig) {
        GlobalAuroraConfiguration.Builder builder = GlobalAuroraConfiguration.builder();
        globalAuroraConfig.accept(builder);
        return fromGlobalAuroraConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #parallelConfig()} initialized to the given value.
     *
     * <p>
     * A parallel configuration execution block.
     * </p>
     * 
     * @param parallelConfig
     *        A parallel configuration execution block.
     */
    public static ExecutionBlockConfiguration fromParallelConfig(ParallelExecutionBlockConfiguration parallelConfig) {
        return builder().parallelConfig(parallelConfig).build();
    }

    /**
     * Create an instance of this class with {@link #parallelConfig()} initialized to the given value.
     *
     * <p>
     * A parallel configuration execution block.
     * </p>
     * 
     * @param parallelConfig
     *        A parallel configuration execution block.
     */
    public static ExecutionBlockConfiguration fromParallelConfig(
            Consumer<ParallelExecutionBlockConfiguration.Builder> parallelConfig) {
        ParallelExecutionBlockConfiguration.Builder builder = ParallelExecutionBlockConfiguration.builder();
        parallelConfig.accept(builder);
        return fromParallelConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #regionSwitchPlanConfig()} initialized to the given value.
     *
     * <p>
     * A Region switch plan execution block.
     * </p>
     * 
     * @param regionSwitchPlanConfig
     *        A Region switch plan execution block.
     */
    public static ExecutionBlockConfiguration fromRegionSwitchPlanConfig(RegionSwitchPlanConfiguration regionSwitchPlanConfig) {
        return builder().regionSwitchPlanConfig(regionSwitchPlanConfig).build();
    }

    /**
     * Create an instance of this class with {@link #regionSwitchPlanConfig()} initialized to the given value.
     *
     * <p>
     * A Region switch plan execution block.
     * </p>
     * 
     * @param regionSwitchPlanConfig
     *        A Region switch plan execution block.
     */
    public static ExecutionBlockConfiguration fromRegionSwitchPlanConfig(
            Consumer<RegionSwitchPlanConfiguration.Builder> regionSwitchPlanConfig) {
        RegionSwitchPlanConfiguration.Builder builder = RegionSwitchPlanConfiguration.builder();
        regionSwitchPlanConfig.accept(builder);
        return fromRegionSwitchPlanConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #ecsCapacityIncreaseConfig()} initialized to the given value.
     *
     * <p>
     * The capacity increase specified for the configuration.
     * </p>
     * 
     * @param ecsCapacityIncreaseConfig
     *        The capacity increase specified for the configuration.
     */
    public static ExecutionBlockConfiguration fromEcsCapacityIncreaseConfig(
            EcsCapacityIncreaseConfiguration ecsCapacityIncreaseConfig) {
        return builder().ecsCapacityIncreaseConfig(ecsCapacityIncreaseConfig).build();
    }

    /**
     * Create an instance of this class with {@link #ecsCapacityIncreaseConfig()} initialized to the given value.
     *
     * <p>
     * The capacity increase specified for the configuration.
     * </p>
     * 
     * @param ecsCapacityIncreaseConfig
     *        The capacity increase specified for the configuration.
     */
    public static ExecutionBlockConfiguration fromEcsCapacityIncreaseConfig(
            Consumer<EcsCapacityIncreaseConfiguration.Builder> ecsCapacityIncreaseConfig) {
        EcsCapacityIncreaseConfiguration.Builder builder = EcsCapacityIncreaseConfiguration.builder();
        ecsCapacityIncreaseConfig.accept(builder);
        return fromEcsCapacityIncreaseConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #eksResourceScalingConfig()} initialized to the given value.
     *
     * <p>
     * An Amazon Web Services EKS resource scaling execution block.
     * </p>
     * 
     * @param eksResourceScalingConfig
     *        An Amazon Web Services EKS resource scaling execution block.
     */
    public static ExecutionBlockConfiguration fromEksResourceScalingConfig(
            EksResourceScalingConfiguration eksResourceScalingConfig) {
        return builder().eksResourceScalingConfig(eksResourceScalingConfig).build();
    }

    /**
     * Create an instance of this class with {@link #eksResourceScalingConfig()} initialized to the given value.
     *
     * <p>
     * An Amazon Web Services EKS resource scaling execution block.
     * </p>
     * 
     * @param eksResourceScalingConfig
     *        An Amazon Web Services EKS resource scaling execution block.
     */
    public static ExecutionBlockConfiguration fromEksResourceScalingConfig(
            Consumer<EksResourceScalingConfiguration.Builder> eksResourceScalingConfig) {
        EksResourceScalingConfiguration.Builder builder = EksResourceScalingConfiguration.builder();
        eksResourceScalingConfig.accept(builder);
        return fromEksResourceScalingConfig(builder.build());
    }

    /**
     * Create an instance of this class with {@link #route53HealthCheckConfig()} initialized to the given value.
     *
     * <p>
     * The Amazon Route 53 health check configuration.
     * </p>
     * 
     * @param route53HealthCheckConfig
     *        The Amazon Route 53 health check configuration.
     */
    public static ExecutionBlockConfiguration fromRoute53HealthCheckConfig(
            Route53HealthCheckConfiguration route53HealthCheckConfig) {
        return builder().route53HealthCheckConfig(route53HealthCheckConfig).build();
    }

    /**
     * Create an instance of this class with {@link #route53HealthCheckConfig()} initialized to the given value.
     *
     * <p>
     * The Amazon Route 53 health check configuration.
     * </p>
     * 
     * @param route53HealthCheckConfig
     *        The Amazon Route 53 health check configuration.
     */
    public static ExecutionBlockConfiguration fromRoute53HealthCheckConfig(
            Consumer<Route53HealthCheckConfiguration.Builder> route53HealthCheckConfig) {
        Route53HealthCheckConfiguration.Builder builder = Route53HealthCheckConfiguration.builder();
        route53HealthCheckConfig.accept(builder);
        return fromRoute53HealthCheckConfig(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("customActionLambdaConfig", CUSTOM_ACTION_LAMBDA_CONFIG_FIELD);
        map.put("ec2AsgCapacityIncreaseConfig", EC2_ASG_CAPACITY_INCREASE_CONFIG_FIELD);
        map.put("executionApprovalConfig", EXECUTION_APPROVAL_CONFIG_FIELD);
        map.put("arcRoutingControlConfig", ARC_ROUTING_CONTROL_CONFIG_FIELD);
        map.put("globalAuroraConfig", GLOBAL_AURORA_CONFIG_FIELD);
        map.put("parallelConfig", PARALLEL_CONFIG_FIELD);
        map.put("regionSwitchPlanConfig", REGION_SWITCH_PLAN_CONFIG_FIELD);
        map.put("ecsCapacityIncreaseConfig", ECS_CAPACITY_INCREASE_CONFIG_FIELD);
        map.put("eksResourceScalingConfig", EKS_RESOURCE_SCALING_CONFIG_FIELD);
        map.put("route53HealthCheckConfig", ROUTE53_HEALTH_CHECK_CONFIG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ExecutionBlockConfiguration, T> g) {
        return obj -> g.apply((ExecutionBlockConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ExecutionBlockConfiguration> {
        /**
         * <p>
         * An Amazon Web Services Lambda execution block.
         * </p>
         * 
         * @param customActionLambdaConfig
         *        An Amazon Web Services Lambda execution block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customActionLambdaConfig(CustomActionLambdaConfiguration customActionLambdaConfig);

        /**
         * <p>
         * An Amazon Web Services Lambda execution block.
         * </p>
         * This is a convenience method that creates an instance of the {@link CustomActionLambdaConfiguration.Builder}
         * avoiding the need to create one manually via {@link CustomActionLambdaConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomActionLambdaConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #customActionLambdaConfig(CustomActionLambdaConfiguration)}.
         * 
         * @param customActionLambdaConfig
         *        a consumer that will call methods on {@link CustomActionLambdaConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customActionLambdaConfig(CustomActionLambdaConfiguration)
         */
        default Builder customActionLambdaConfig(Consumer<CustomActionLambdaConfiguration.Builder> customActionLambdaConfig) {
            return customActionLambdaConfig(CustomActionLambdaConfiguration.builder().applyMutation(customActionLambdaConfig)
                    .build());
        }

        /**
         * <p>
         * An EC2 Auto Scaling group execution block.
         * </p>
         * 
         * @param ec2AsgCapacityIncreaseConfig
         *        An EC2 Auto Scaling group execution block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ec2AsgCapacityIncreaseConfig(Ec2AsgCapacityIncreaseConfiguration ec2AsgCapacityIncreaseConfig);

        /**
         * <p>
         * An EC2 Auto Scaling group execution block.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link Ec2AsgCapacityIncreaseConfiguration.Builder} avoiding the need to create one manually via
         * {@link Ec2AsgCapacityIncreaseConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Ec2AsgCapacityIncreaseConfiguration.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #ec2AsgCapacityIncreaseConfig(Ec2AsgCapacityIncreaseConfiguration)}.
         * 
         * @param ec2AsgCapacityIncreaseConfig
         *        a consumer that will call methods on {@link Ec2AsgCapacityIncreaseConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ec2AsgCapacityIncreaseConfig(Ec2AsgCapacityIncreaseConfiguration)
         */
        default Builder ec2AsgCapacityIncreaseConfig(
                Consumer<Ec2AsgCapacityIncreaseConfiguration.Builder> ec2AsgCapacityIncreaseConfig) {
            return ec2AsgCapacityIncreaseConfig(Ec2AsgCapacityIncreaseConfiguration.builder()
                    .applyMutation(ec2AsgCapacityIncreaseConfig).build());
        }

        /**
         * <p>
         * A manual approval execution block.
         * </p>
         * 
         * @param executionApprovalConfig
         *        A manual approval execution block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder executionApprovalConfig(ExecutionApprovalConfiguration executionApprovalConfig);

        /**
         * <p>
         * A manual approval execution block.
         * </p>
         * This is a convenience method that creates an instance of the {@link ExecutionApprovalConfiguration.Builder}
         * avoiding the need to create one manually via {@link ExecutionApprovalConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ExecutionApprovalConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #executionApprovalConfig(ExecutionApprovalConfiguration)}.
         * 
         * @param executionApprovalConfig
         *        a consumer that will call methods on {@link ExecutionApprovalConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #executionApprovalConfig(ExecutionApprovalConfiguration)
         */
        default Builder executionApprovalConfig(Consumer<ExecutionApprovalConfiguration.Builder> executionApprovalConfig) {
            return executionApprovalConfig(ExecutionApprovalConfiguration.builder().applyMutation(executionApprovalConfig)
                    .build());
        }

        /**
         * <p>
         * An ARC routing control execution block.
         * </p>
         * 
         * @param arcRoutingControlConfig
         *        An ARC routing control execution block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder arcRoutingControlConfig(ArcRoutingControlConfiguration arcRoutingControlConfig);

        /**
         * <p>
         * An ARC routing control execution block.
         * </p>
         * This is a convenience method that creates an instance of the {@link ArcRoutingControlConfiguration.Builder}
         * avoiding the need to create one manually via {@link ArcRoutingControlConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ArcRoutingControlConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #arcRoutingControlConfig(ArcRoutingControlConfiguration)}.
         * 
         * @param arcRoutingControlConfig
         *        a consumer that will call methods on {@link ArcRoutingControlConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #arcRoutingControlConfig(ArcRoutingControlConfiguration)
         */
        default Builder arcRoutingControlConfig(Consumer<ArcRoutingControlConfiguration.Builder> arcRoutingControlConfig) {
            return arcRoutingControlConfig(ArcRoutingControlConfiguration.builder().applyMutation(arcRoutingControlConfig)
                    .build());
        }

        /**
         * <p>
         * An Aurora Global Database execution block.
         * </p>
         * 
         * @param globalAuroraConfig
         *        An Aurora Global Database execution block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder globalAuroraConfig(GlobalAuroraConfiguration globalAuroraConfig);

        /**
         * <p>
         * An Aurora Global Database execution block.
         * </p>
         * This is a convenience method that creates an instance of the {@link GlobalAuroraConfiguration.Builder}
         * avoiding the need to create one manually via {@link GlobalAuroraConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link GlobalAuroraConfiguration.Builder#build()} is called immediately
         * and its result is passed to {@link #globalAuroraConfig(GlobalAuroraConfiguration)}.
         * 
         * @param globalAuroraConfig
         *        a consumer that will call methods on {@link GlobalAuroraConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #globalAuroraConfig(GlobalAuroraConfiguration)
         */
        default Builder globalAuroraConfig(Consumer<GlobalAuroraConfiguration.Builder> globalAuroraConfig) {
            return globalAuroraConfig(GlobalAuroraConfiguration.builder().applyMutation(globalAuroraConfig).build());
        }

        /**
         * <p>
         * A parallel configuration execution block.
         * </p>
         * 
         * @param parallelConfig
         *        A parallel configuration execution block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parallelConfig(ParallelExecutionBlockConfiguration parallelConfig);

        /**
         * <p>
         * A parallel configuration execution block.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ParallelExecutionBlockConfiguration.Builder} avoiding the need to create one manually via
         * {@link ParallelExecutionBlockConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParallelExecutionBlockConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #parallelConfig(ParallelExecutionBlockConfiguration)}.
         * 
         * @param parallelConfig
         *        a consumer that will call methods on {@link ParallelExecutionBlockConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parallelConfig(ParallelExecutionBlockConfiguration)
         */
        default Builder parallelConfig(Consumer<ParallelExecutionBlockConfiguration.Builder> parallelConfig) {
            return parallelConfig(ParallelExecutionBlockConfiguration.builder().applyMutation(parallelConfig).build());
        }

        /**
         * <p>
         * A Region switch plan execution block.
         * </p>
         * 
         * @param regionSwitchPlanConfig
         *        A Region switch plan execution block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder regionSwitchPlanConfig(RegionSwitchPlanConfiguration regionSwitchPlanConfig);

        /**
         * <p>
         * A Region switch plan execution block.
         * </p>
         * This is a convenience method that creates an instance of the {@link RegionSwitchPlanConfiguration.Builder}
         * avoiding the need to create one manually via {@link RegionSwitchPlanConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link RegionSwitchPlanConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #regionSwitchPlanConfig(RegionSwitchPlanConfiguration)}.
         * 
         * @param regionSwitchPlanConfig
         *        a consumer that will call methods on {@link RegionSwitchPlanConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #regionSwitchPlanConfig(RegionSwitchPlanConfiguration)
         */
        default Builder regionSwitchPlanConfig(Consumer<RegionSwitchPlanConfiguration.Builder> regionSwitchPlanConfig) {
            return regionSwitchPlanConfig(RegionSwitchPlanConfiguration.builder().applyMutation(regionSwitchPlanConfig).build());
        }

        /**
         * <p>
         * The capacity increase specified for the configuration.
         * </p>
         * 
         * @param ecsCapacityIncreaseConfig
         *        The capacity increase specified for the configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder ecsCapacityIncreaseConfig(EcsCapacityIncreaseConfiguration ecsCapacityIncreaseConfig);

        /**
         * <p>
         * The capacity increase specified for the configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link EcsCapacityIncreaseConfiguration.Builder}
         * avoiding the need to create one manually via {@link EcsCapacityIncreaseConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EcsCapacityIncreaseConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #ecsCapacityIncreaseConfig(EcsCapacityIncreaseConfiguration)}.
         * 
         * @param ecsCapacityIncreaseConfig
         *        a consumer that will call methods on {@link EcsCapacityIncreaseConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #ecsCapacityIncreaseConfig(EcsCapacityIncreaseConfiguration)
         */
        default Builder ecsCapacityIncreaseConfig(Consumer<EcsCapacityIncreaseConfiguration.Builder> ecsCapacityIncreaseConfig) {
            return ecsCapacityIncreaseConfig(EcsCapacityIncreaseConfiguration.builder().applyMutation(ecsCapacityIncreaseConfig)
                    .build());
        }

        /**
         * <p>
         * An Amazon Web Services EKS resource scaling execution block.
         * </p>
         * 
         * @param eksResourceScalingConfig
         *        An Amazon Web Services EKS resource scaling execution block.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder eksResourceScalingConfig(EksResourceScalingConfiguration eksResourceScalingConfig);

        /**
         * <p>
         * An Amazon Web Services EKS resource scaling execution block.
         * </p>
         * This is a convenience method that creates an instance of the {@link EksResourceScalingConfiguration.Builder}
         * avoiding the need to create one manually via {@link EksResourceScalingConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link EksResourceScalingConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #eksResourceScalingConfig(EksResourceScalingConfiguration)}.
         * 
         * @param eksResourceScalingConfig
         *        a consumer that will call methods on {@link EksResourceScalingConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #eksResourceScalingConfig(EksResourceScalingConfiguration)
         */
        default Builder eksResourceScalingConfig(Consumer<EksResourceScalingConfiguration.Builder> eksResourceScalingConfig) {
            return eksResourceScalingConfig(EksResourceScalingConfiguration.builder().applyMutation(eksResourceScalingConfig)
                    .build());
        }

        /**
         * <p>
         * The Amazon Route 53 health check configuration.
         * </p>
         * 
         * @param route53HealthCheckConfig
         *        The Amazon Route 53 health check configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder route53HealthCheckConfig(Route53HealthCheckConfiguration route53HealthCheckConfig);

        /**
         * <p>
         * The Amazon Route 53 health check configuration.
         * </p>
         * This is a convenience method that creates an instance of the {@link Route53HealthCheckConfiguration.Builder}
         * avoiding the need to create one manually via {@link Route53HealthCheckConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Route53HealthCheckConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #route53HealthCheckConfig(Route53HealthCheckConfiguration)}.
         * 
         * @param route53HealthCheckConfig
         *        a consumer that will call methods on {@link Route53HealthCheckConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #route53HealthCheckConfig(Route53HealthCheckConfiguration)
         */
        default Builder route53HealthCheckConfig(Consumer<Route53HealthCheckConfiguration.Builder> route53HealthCheckConfig) {
            return route53HealthCheckConfig(Route53HealthCheckConfiguration.builder().applyMutation(route53HealthCheckConfig)
                    .build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CustomActionLambdaConfiguration customActionLambdaConfig;

        private Ec2AsgCapacityIncreaseConfiguration ec2AsgCapacityIncreaseConfig;

        private ExecutionApprovalConfiguration executionApprovalConfig;

        private ArcRoutingControlConfiguration arcRoutingControlConfig;

        private GlobalAuroraConfiguration globalAuroraConfig;

        private ParallelExecutionBlockConfiguration parallelConfig;

        private RegionSwitchPlanConfiguration regionSwitchPlanConfig;

        private EcsCapacityIncreaseConfiguration ecsCapacityIncreaseConfig;

        private EksResourceScalingConfiguration eksResourceScalingConfig;

        private Route53HealthCheckConfiguration route53HealthCheckConfig;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(ExecutionBlockConfiguration model) {
            customActionLambdaConfig(model.customActionLambdaConfig);
            ec2AsgCapacityIncreaseConfig(model.ec2AsgCapacityIncreaseConfig);
            executionApprovalConfig(model.executionApprovalConfig);
            arcRoutingControlConfig(model.arcRoutingControlConfig);
            globalAuroraConfig(model.globalAuroraConfig);
            parallelConfig(model.parallelConfig);
            regionSwitchPlanConfig(model.regionSwitchPlanConfig);
            ecsCapacityIncreaseConfig(model.ecsCapacityIncreaseConfig);
            eksResourceScalingConfig(model.eksResourceScalingConfig);
            route53HealthCheckConfig(model.route53HealthCheckConfig);
        }

        public final CustomActionLambdaConfiguration.Builder getCustomActionLambdaConfig() {
            return customActionLambdaConfig != null ? customActionLambdaConfig.toBuilder() : null;
        }

        public final void setCustomActionLambdaConfig(CustomActionLambdaConfiguration.BuilderImpl customActionLambdaConfig) {
            Object oldValue = this.customActionLambdaConfig;
            this.customActionLambdaConfig = customActionLambdaConfig != null ? customActionLambdaConfig.build() : null;
            handleUnionValueChange(Type.CUSTOM_ACTION_LAMBDA_CONFIG, oldValue, this.customActionLambdaConfig);
        }

        @Override
        public final Builder customActionLambdaConfig(CustomActionLambdaConfiguration customActionLambdaConfig) {
            Object oldValue = this.customActionLambdaConfig;
            this.customActionLambdaConfig = customActionLambdaConfig;
            handleUnionValueChange(Type.CUSTOM_ACTION_LAMBDA_CONFIG, oldValue, this.customActionLambdaConfig);
            return this;
        }

        public final Ec2AsgCapacityIncreaseConfiguration.Builder getEc2AsgCapacityIncreaseConfig() {
            return ec2AsgCapacityIncreaseConfig != null ? ec2AsgCapacityIncreaseConfig.toBuilder() : null;
        }

        public final void setEc2AsgCapacityIncreaseConfig(
                Ec2AsgCapacityIncreaseConfiguration.BuilderImpl ec2AsgCapacityIncreaseConfig) {
            Object oldValue = this.ec2AsgCapacityIncreaseConfig;
            this.ec2AsgCapacityIncreaseConfig = ec2AsgCapacityIncreaseConfig != null ? ec2AsgCapacityIncreaseConfig.build()
                    : null;
            handleUnionValueChange(Type.EC2_ASG_CAPACITY_INCREASE_CONFIG, oldValue, this.ec2AsgCapacityIncreaseConfig);
        }

        @Override
        public final Builder ec2AsgCapacityIncreaseConfig(Ec2AsgCapacityIncreaseConfiguration ec2AsgCapacityIncreaseConfig) {
            Object oldValue = this.ec2AsgCapacityIncreaseConfig;
            this.ec2AsgCapacityIncreaseConfig = ec2AsgCapacityIncreaseConfig;
            handleUnionValueChange(Type.EC2_ASG_CAPACITY_INCREASE_CONFIG, oldValue, this.ec2AsgCapacityIncreaseConfig);
            return this;
        }

        public final ExecutionApprovalConfiguration.Builder getExecutionApprovalConfig() {
            return executionApprovalConfig != null ? executionApprovalConfig.toBuilder() : null;
        }

        public final void setExecutionApprovalConfig(ExecutionApprovalConfiguration.BuilderImpl executionApprovalConfig) {
            Object oldValue = this.executionApprovalConfig;
            this.executionApprovalConfig = executionApprovalConfig != null ? executionApprovalConfig.build() : null;
            handleUnionValueChange(Type.EXECUTION_APPROVAL_CONFIG, oldValue, this.executionApprovalConfig);
        }

        @Override
        public final Builder executionApprovalConfig(ExecutionApprovalConfiguration executionApprovalConfig) {
            Object oldValue = this.executionApprovalConfig;
            this.executionApprovalConfig = executionApprovalConfig;
            handleUnionValueChange(Type.EXECUTION_APPROVAL_CONFIG, oldValue, this.executionApprovalConfig);
            return this;
        }

        public final ArcRoutingControlConfiguration.Builder getArcRoutingControlConfig() {
            return arcRoutingControlConfig != null ? arcRoutingControlConfig.toBuilder() : null;
        }

        public final void setArcRoutingControlConfig(ArcRoutingControlConfiguration.BuilderImpl arcRoutingControlConfig) {
            Object oldValue = this.arcRoutingControlConfig;
            this.arcRoutingControlConfig = arcRoutingControlConfig != null ? arcRoutingControlConfig.build() : null;
            handleUnionValueChange(Type.ARC_ROUTING_CONTROL_CONFIG, oldValue, this.arcRoutingControlConfig);
        }

        @Override
        public final Builder arcRoutingControlConfig(ArcRoutingControlConfiguration arcRoutingControlConfig) {
            Object oldValue = this.arcRoutingControlConfig;
            this.arcRoutingControlConfig = arcRoutingControlConfig;
            handleUnionValueChange(Type.ARC_ROUTING_CONTROL_CONFIG, oldValue, this.arcRoutingControlConfig);
            return this;
        }

        public final GlobalAuroraConfiguration.Builder getGlobalAuroraConfig() {
            return globalAuroraConfig != null ? globalAuroraConfig.toBuilder() : null;
        }

        public final void setGlobalAuroraConfig(GlobalAuroraConfiguration.BuilderImpl globalAuroraConfig) {
            Object oldValue = this.globalAuroraConfig;
            this.globalAuroraConfig = globalAuroraConfig != null ? globalAuroraConfig.build() : null;
            handleUnionValueChange(Type.GLOBAL_AURORA_CONFIG, oldValue, this.globalAuroraConfig);
        }

        @Override
        public final Builder globalAuroraConfig(GlobalAuroraConfiguration globalAuroraConfig) {
            Object oldValue = this.globalAuroraConfig;
            this.globalAuroraConfig = globalAuroraConfig;
            handleUnionValueChange(Type.GLOBAL_AURORA_CONFIG, oldValue, this.globalAuroraConfig);
            return this;
        }

        public final ParallelExecutionBlockConfiguration.Builder getParallelConfig() {
            return parallelConfig != null ? parallelConfig.toBuilder() : null;
        }

        public final void setParallelConfig(ParallelExecutionBlockConfiguration.BuilderImpl parallelConfig) {
            Object oldValue = this.parallelConfig;
            this.parallelConfig = parallelConfig != null ? parallelConfig.build() : null;
            handleUnionValueChange(Type.PARALLEL_CONFIG, oldValue, this.parallelConfig);
        }

        @Override
        public final Builder parallelConfig(ParallelExecutionBlockConfiguration parallelConfig) {
            Object oldValue = this.parallelConfig;
            this.parallelConfig = parallelConfig;
            handleUnionValueChange(Type.PARALLEL_CONFIG, oldValue, this.parallelConfig);
            return this;
        }

        public final RegionSwitchPlanConfiguration.Builder getRegionSwitchPlanConfig() {
            return regionSwitchPlanConfig != null ? regionSwitchPlanConfig.toBuilder() : null;
        }

        public final void setRegionSwitchPlanConfig(RegionSwitchPlanConfiguration.BuilderImpl regionSwitchPlanConfig) {
            Object oldValue = this.regionSwitchPlanConfig;
            this.regionSwitchPlanConfig = regionSwitchPlanConfig != null ? regionSwitchPlanConfig.build() : null;
            handleUnionValueChange(Type.REGION_SWITCH_PLAN_CONFIG, oldValue, this.regionSwitchPlanConfig);
        }

        @Override
        public final Builder regionSwitchPlanConfig(RegionSwitchPlanConfiguration regionSwitchPlanConfig) {
            Object oldValue = this.regionSwitchPlanConfig;
            this.regionSwitchPlanConfig = regionSwitchPlanConfig;
            handleUnionValueChange(Type.REGION_SWITCH_PLAN_CONFIG, oldValue, this.regionSwitchPlanConfig);
            return this;
        }

        public final EcsCapacityIncreaseConfiguration.Builder getEcsCapacityIncreaseConfig() {
            return ecsCapacityIncreaseConfig != null ? ecsCapacityIncreaseConfig.toBuilder() : null;
        }

        public final void setEcsCapacityIncreaseConfig(EcsCapacityIncreaseConfiguration.BuilderImpl ecsCapacityIncreaseConfig) {
            Object oldValue = this.ecsCapacityIncreaseConfig;
            this.ecsCapacityIncreaseConfig = ecsCapacityIncreaseConfig != null ? ecsCapacityIncreaseConfig.build() : null;
            handleUnionValueChange(Type.ECS_CAPACITY_INCREASE_CONFIG, oldValue, this.ecsCapacityIncreaseConfig);
        }

        @Override
        public final Builder ecsCapacityIncreaseConfig(EcsCapacityIncreaseConfiguration ecsCapacityIncreaseConfig) {
            Object oldValue = this.ecsCapacityIncreaseConfig;
            this.ecsCapacityIncreaseConfig = ecsCapacityIncreaseConfig;
            handleUnionValueChange(Type.ECS_CAPACITY_INCREASE_CONFIG, oldValue, this.ecsCapacityIncreaseConfig);
            return this;
        }

        public final EksResourceScalingConfiguration.Builder getEksResourceScalingConfig() {
            return eksResourceScalingConfig != null ? eksResourceScalingConfig.toBuilder() : null;
        }

        public final void setEksResourceScalingConfig(EksResourceScalingConfiguration.BuilderImpl eksResourceScalingConfig) {
            Object oldValue = this.eksResourceScalingConfig;
            this.eksResourceScalingConfig = eksResourceScalingConfig != null ? eksResourceScalingConfig.build() : null;
            handleUnionValueChange(Type.EKS_RESOURCE_SCALING_CONFIG, oldValue, this.eksResourceScalingConfig);
        }

        @Override
        public final Builder eksResourceScalingConfig(EksResourceScalingConfiguration eksResourceScalingConfig) {
            Object oldValue = this.eksResourceScalingConfig;
            this.eksResourceScalingConfig = eksResourceScalingConfig;
            handleUnionValueChange(Type.EKS_RESOURCE_SCALING_CONFIG, oldValue, this.eksResourceScalingConfig);
            return this;
        }

        public final Route53HealthCheckConfiguration.Builder getRoute53HealthCheckConfig() {
            return route53HealthCheckConfig != null ? route53HealthCheckConfig.toBuilder() : null;
        }

        public final void setRoute53HealthCheckConfig(Route53HealthCheckConfiguration.BuilderImpl route53HealthCheckConfig) {
            Object oldValue = this.route53HealthCheckConfig;
            this.route53HealthCheckConfig = route53HealthCheckConfig != null ? route53HealthCheckConfig.build() : null;
            handleUnionValueChange(Type.ROUTE53_HEALTH_CHECK_CONFIG, oldValue, this.route53HealthCheckConfig);
        }

        @Override
        public final Builder route53HealthCheckConfig(Route53HealthCheckConfiguration route53HealthCheckConfig) {
            Object oldValue = this.route53HealthCheckConfig;
            this.route53HealthCheckConfig = route53HealthCheckConfig;
            handleUnionValueChange(Type.ROUTE53_HEALTH_CHECK_CONFIG, oldValue, this.route53HealthCheckConfig);
            return this;
        }

        @Override
        public ExecutionBlockConfiguration build() {
            return new ExecutionBlockConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see ExecutionBlockConfiguration#type()
     */
    public enum Type {
        CUSTOM_ACTION_LAMBDA_CONFIG,

        EC2_ASG_CAPACITY_INCREASE_CONFIG,

        EXECUTION_APPROVAL_CONFIG,

        ARC_ROUTING_CONTROL_CONFIG,

        GLOBAL_AURORA_CONFIG,

        PARALLEL_CONFIG,

        REGION_SWITCH_PLAN_CONFIG,

        ECS_CAPACITY_INCREASE_CONFIG,

        EKS_RESOURCE_SCALING_CONFIG,

        ROUTE53_HEALTH_CHECK_CONFIG,

        UNKNOWN_TO_SDK_VERSION
    }
}
