/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apptest.AppTestAsyncClient;
import software.amazon.awssdk.services.apptest.internal.UserAgentUtils;
import software.amazon.awssdk.services.apptest.model.ListTestConfigurationsRequest;
import software.amazon.awssdk.services.apptest.model.ListTestConfigurationsResponse;
import software.amazon.awssdk.services.apptest.model.TestConfigurationSummary;

public class ListTestConfigurationsPublisher
implements SdkPublisher<ListTestConfigurationsResponse> {
    private final AppTestAsyncClient client;
    private final ListTestConfigurationsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListTestConfigurationsPublisher(AppTestAsyncClient client, ListTestConfigurationsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListTestConfigurationsPublisher(AppTestAsyncClient client, ListTestConfigurationsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListTestConfigurationsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListTestConfigurationsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<TestConfigurationSummary> testConfigurations() {
        Function<ListTestConfigurationsResponse, Iterator> getIterator = response -> {
            if (response != null && response.testConfigurations() != null) {
                return response.testConfigurations().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListTestConfigurationsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListTestConfigurationsResponseFetcher
    implements AsyncPageFetcher<ListTestConfigurationsResponse> {
        private ListTestConfigurationsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestConfigurationsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListTestConfigurationsResponse> nextPage(ListTestConfigurationsResponse previousPage) {
            if (previousPage == null) {
                return ListTestConfigurationsPublisher.this.client.listTestConfigurations(ListTestConfigurationsPublisher.this.firstRequest);
            }
            return ListTestConfigurationsPublisher.this.client.listTestConfigurations((ListTestConfigurationsRequest)((Object)ListTestConfigurationsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

