/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.apptest.model.AppTestRequest;
import software.amazon.awssdk.services.apptest.model.Step;
import software.amazon.awssdk.services.apptest.model.StepListCopier;
import software.amazon.awssdk.services.apptest.model.TestCases;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateTestSuiteRequest
extends AppTestRequest
implements ToCopyableBuilder<Builder, UpdateTestSuiteRequest> {
    private static final SdkField<String> TEST_SUITE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("testSuiteId").getter(UpdateTestSuiteRequest.getter(UpdateTestSuiteRequest::testSuiteId)).setter(UpdateTestSuiteRequest.setter(Builder::testSuiteId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("testSuiteId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("description").getter(UpdateTestSuiteRequest.getter(UpdateTestSuiteRequest::description)).setter(UpdateTestSuiteRequest.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()}).build();
    private static final SdkField<List<Step>> BEFORE_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("beforeSteps").getter(UpdateTestSuiteRequest.getter(UpdateTestSuiteRequest::beforeSteps)).setter(UpdateTestSuiteRequest.setter(Builder::beforeSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("beforeSteps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Step::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<Step>> AFTER_STEPS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("afterSteps").getter(UpdateTestSuiteRequest.getter(UpdateTestSuiteRequest::afterSteps)).setter(UpdateTestSuiteRequest.setter(Builder::afterSteps)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("afterSteps").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Step::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<TestCases> TEST_CASES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("testCases").getter(UpdateTestSuiteRequest.getter(UpdateTestSuiteRequest::testCases)).setter(UpdateTestSuiteRequest.setter(Builder::testCases)).constructor(TestCases::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("testCases").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEST_SUITE_ID_FIELD, DESCRIPTION_FIELD, BEFORE_STEPS_FIELD, AFTER_STEPS_FIELD, TEST_CASES_FIELD));
    private final String testSuiteId;
    private final String description;
    private final List<Step> beforeSteps;
    private final List<Step> afterSteps;
    private final TestCases testCases;

    private UpdateTestSuiteRequest(BuilderImpl builder) {
        super(builder);
        this.testSuiteId = builder.testSuiteId;
        this.description = builder.description;
        this.beforeSteps = builder.beforeSteps;
        this.afterSteps = builder.afterSteps;
        this.testCases = builder.testCases;
    }

    public final String testSuiteId() {
        return this.testSuiteId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasBeforeSteps() {
        return this.beforeSteps != null && !(this.beforeSteps instanceof SdkAutoConstructList);
    }

    public final List<Step> beforeSteps() {
        return this.beforeSteps;
    }

    public final boolean hasAfterSteps() {
        return this.afterSteps != null && !(this.afterSteps instanceof SdkAutoConstructList);
    }

    public final List<Step> afterSteps() {
        return this.afterSteps;
    }

    public final TestCases testCases() {
        return this.testCases;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.testSuiteId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasBeforeSteps() ? this.beforeSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAfterSteps() ? this.afterSteps() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.testCases());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateTestSuiteRequest)) {
            return false;
        }
        UpdateTestSuiteRequest other = (UpdateTestSuiteRequest)((Object)obj);
        return Objects.equals(this.testSuiteId(), other.testSuiteId()) && Objects.equals(this.description(), other.description()) && this.hasBeforeSteps() == other.hasBeforeSteps() && Objects.equals(this.beforeSteps(), other.beforeSteps()) && this.hasAfterSteps() == other.hasAfterSteps() && Objects.equals(this.afterSteps(), other.afterSteps()) && Objects.equals(this.testCases(), other.testCases());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateTestSuiteRequest").add("TestSuiteId", (Object)this.testSuiteId()).add("Description", (Object)this.description()).add("BeforeSteps", this.hasBeforeSteps() ? this.beforeSteps() : null).add("AfterSteps", this.hasAfterSteps() ? this.afterSteps() : null).add("TestCases", (Object)this.testCases()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "testSuiteId": {
                return Optional.ofNullable(clazz.cast(this.testSuiteId()));
            }
            case "description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "beforeSteps": {
                return Optional.ofNullable(clazz.cast(this.beforeSteps()));
            }
            case "afterSteps": {
                return Optional.ofNullable(clazz.cast(this.afterSteps()));
            }
            case "testCases": {
                return Optional.ofNullable(clazz.cast(this.testCases()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<UpdateTestSuiteRequest, T> g) {
        return obj -> g.apply((UpdateTestSuiteRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppTestRequest.BuilderImpl
    implements Builder {
        private String testSuiteId;
        private String description;
        private List<Step> beforeSteps = DefaultSdkAutoConstructList.getInstance();
        private List<Step> afterSteps = DefaultSdkAutoConstructList.getInstance();
        private TestCases testCases;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateTestSuiteRequest model) {
            super(model);
            this.testSuiteId(model.testSuiteId);
            this.description(model.description);
            this.beforeSteps(model.beforeSteps);
            this.afterSteps(model.afterSteps);
            this.testCases(model.testCases);
        }

        public final String getTestSuiteId() {
            return this.testSuiteId;
        }

        public final void setTestSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
        }

        @Override
        public final Builder testSuiteId(String testSuiteId) {
            this.testSuiteId = testSuiteId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Step.Builder> getBeforeSteps() {
            List<Step.Builder> result = StepListCopier.copyToBuilder(this.beforeSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setBeforeSteps(Collection<Step.BuilderImpl> beforeSteps) {
            this.beforeSteps = StepListCopier.copyFromBuilder(beforeSteps);
        }

        @Override
        public final Builder beforeSteps(Collection<Step> beforeSteps) {
            this.beforeSteps = StepListCopier.copy(beforeSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder beforeSteps(Step ... beforeSteps) {
            this.beforeSteps(Arrays.asList(beforeSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder beforeSteps(Consumer<Step.Builder> ... beforeSteps) {
            this.beforeSteps(Stream.of(beforeSteps).map(c -> (Step)((Step.Builder)Step.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<Step.Builder> getAfterSteps() {
            List<Step.Builder> result = StepListCopier.copyToBuilder(this.afterSteps);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAfterSteps(Collection<Step.BuilderImpl> afterSteps) {
            this.afterSteps = StepListCopier.copyFromBuilder(afterSteps);
        }

        @Override
        public final Builder afterSteps(Collection<Step> afterSteps) {
            this.afterSteps = StepListCopier.copy(afterSteps);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder afterSteps(Step ... afterSteps) {
            this.afterSteps(Arrays.asList(afterSteps));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder afterSteps(Consumer<Step.Builder> ... afterSteps) {
            this.afterSteps(Stream.of(afterSteps).map(c -> (Step)((Step.Builder)Step.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final TestCases.Builder getTestCases() {
            return this.testCases != null ? this.testCases.toBuilder() : null;
        }

        public final void setTestCases(TestCases.BuilderImpl testCases) {
            this.testCases = testCases != null ? testCases.build() : null;
        }

        @Override
        public final Builder testCases(TestCases testCases) {
            this.testCases = testCases;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateTestSuiteRequest build() {
            return new UpdateTestSuiteRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends AppTestRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateTestSuiteRequest> {
        public Builder testSuiteId(String var1);

        public Builder description(String var1);

        public Builder beforeSteps(Collection<Step> var1);

        public Builder beforeSteps(Step ... var1);

        public Builder beforeSteps(Consumer<Step.Builder> ... var1);

        public Builder afterSteps(Collection<Step> var1);

        public Builder afterSteps(Step ... var1);

        public Builder afterSteps(Consumer<Step.Builder> ... var1);

        public Builder testCases(TestCases var1);

        default public Builder testCases(Consumer<TestCases.Builder> testCases) {
            return this.testCases((TestCases)((TestCases.Builder)TestCases.builder().applyMutation(testCases)).build());
        }

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

