/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.apptest.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.apptest.AppTestClient;
import software.amazon.awssdk.services.apptest.internal.UserAgentUtils;
import software.amazon.awssdk.services.apptest.model.ListTestRunStepsRequest;
import software.amazon.awssdk.services.apptest.model.ListTestRunStepsResponse;
import software.amazon.awssdk.services.apptest.model.TestRunStepSummary;

public class ListTestRunStepsIterable
implements SdkIterable<ListTestRunStepsResponse> {
    private final AppTestClient client;
    private final ListTestRunStepsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListTestRunStepsIterable(AppTestClient client, ListTestRunStepsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListTestRunStepsResponseFetcher();
    }

    public Iterator<ListTestRunStepsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<TestRunStepSummary> testRunSteps() {
        Function<ListTestRunStepsResponse, Iterator> getIterator = response -> {
            if (response != null && response.testRunSteps() != null) {
                return response.testRunSteps().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListTestRunStepsResponseFetcher
    implements SyncPageFetcher<ListTestRunStepsResponse> {
        private ListTestRunStepsResponseFetcher() {
        }

        public boolean hasNextPage(ListTestRunStepsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListTestRunStepsResponse nextPage(ListTestRunStepsResponse previousPage) {
            if (previousPage == null) {
                return ListTestRunStepsIterable.this.client.listTestRunSteps(ListTestRunStepsIterable.this.firstRequest);
            }
            return ListTestRunStepsIterable.this.client.listTestRunSteps((ListTestRunStepsRequest)((Object)ListTestRunStepsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

