/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class RdsHttpEndpointConfig
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, RdsHttpEndpointConfig> {
    private static final SdkField<String> AWS_REGION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RdsHttpEndpointConfig.getter(RdsHttpEndpointConfig::awsRegion)).setter(RdsHttpEndpointConfig.setter(Builder::awsRegion)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsRegion").build()}).build();
    private static final SdkField<String> DB_CLUSTER_IDENTIFIER_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RdsHttpEndpointConfig.getter(RdsHttpEndpointConfig::dbClusterIdentifier)).setter(RdsHttpEndpointConfig.setter(Builder::dbClusterIdentifier)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dbClusterIdentifier").build()}).build();
    private static final SdkField<String> DATABASE_NAME_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RdsHttpEndpointConfig.getter(RdsHttpEndpointConfig::databaseName)).setter(RdsHttpEndpointConfig.setter(Builder::databaseName)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("databaseName").build()}).build();
    private static final SdkField<String> SCHEMA_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RdsHttpEndpointConfig.getter(RdsHttpEndpointConfig::schema)).setter(RdsHttpEndpointConfig.setter(Builder::schema)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schema").build()}).build();
    private static final SdkField<String> AWS_SECRET_STORE_ARN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).getter(RdsHttpEndpointConfig.getter(RdsHttpEndpointConfig::awsSecretStoreArn)).setter(RdsHttpEndpointConfig.setter(Builder::awsSecretStoreArn)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("awsSecretStoreArn").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AWS_REGION_FIELD, DB_CLUSTER_IDENTIFIER_FIELD, DATABASE_NAME_FIELD, SCHEMA_FIELD, AWS_SECRET_STORE_ARN_FIELD));
    private static final long serialVersionUID = 1L;
    private final String awsRegion;
    private final String dbClusterIdentifier;
    private final String databaseName;
    private final String schema;
    private final String awsSecretStoreArn;

    private RdsHttpEndpointConfig(BuilderImpl builder) {
        this.awsRegion = builder.awsRegion;
        this.dbClusterIdentifier = builder.dbClusterIdentifier;
        this.databaseName = builder.databaseName;
        this.schema = builder.schema;
        this.awsSecretStoreArn = builder.awsSecretStoreArn;
    }

    public String awsRegion() {
        return this.awsRegion;
    }

    public String dbClusterIdentifier() {
        return this.dbClusterIdentifier;
    }

    public String databaseName() {
        return this.databaseName;
    }

    public String schema() {
        return this.schema;
    }

    public String awsSecretStoreArn() {
        return this.awsSecretStoreArn;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.awsRegion());
        hashCode = 31 * hashCode + Objects.hashCode(this.dbClusterIdentifier());
        hashCode = 31 * hashCode + Objects.hashCode(this.databaseName());
        hashCode = 31 * hashCode + Objects.hashCode(this.schema());
        hashCode = 31 * hashCode + Objects.hashCode(this.awsSecretStoreArn());
        return hashCode;
    }

    public boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof RdsHttpEndpointConfig)) {
            return false;
        }
        RdsHttpEndpointConfig other = (RdsHttpEndpointConfig)obj;
        return Objects.equals(this.awsRegion(), other.awsRegion()) && Objects.equals(this.dbClusterIdentifier(), other.dbClusterIdentifier()) && Objects.equals(this.databaseName(), other.databaseName()) && Objects.equals(this.schema(), other.schema()) && Objects.equals(this.awsSecretStoreArn(), other.awsSecretStoreArn());
    }

    public String toString() {
        return ToString.builder((String)"RdsHttpEndpointConfig").add("AwsRegion", (Object)this.awsRegion()).add("DbClusterIdentifier", (Object)this.dbClusterIdentifier()).add("DatabaseName", (Object)this.databaseName()).add("Schema", (Object)this.schema()).add("AwsSecretStoreArn", (Object)this.awsSecretStoreArn()).build();
    }

    public <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "awsRegion": {
                return Optional.ofNullable(clazz.cast(this.awsRegion()));
            }
            case "dbClusterIdentifier": {
                return Optional.ofNullable(clazz.cast(this.dbClusterIdentifier()));
            }
            case "databaseName": {
                return Optional.ofNullable(clazz.cast(this.databaseName()));
            }
            case "schema": {
                return Optional.ofNullable(clazz.cast(this.schema()));
            }
            case "awsSecretStoreArn": {
                return Optional.ofNullable(clazz.cast(this.awsSecretStoreArn()));
            }
        }
        return Optional.empty();
    }

    public List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    private static <T> Function<Object, T> getter(Function<RdsHttpEndpointConfig, T> g) {
        return obj -> g.apply((RdsHttpEndpointConfig)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String awsRegion;
        private String dbClusterIdentifier;
        private String databaseName;
        private String schema;
        private String awsSecretStoreArn;

        private BuilderImpl() {
        }

        private BuilderImpl(RdsHttpEndpointConfig model) {
            this.awsRegion(model.awsRegion);
            this.dbClusterIdentifier(model.dbClusterIdentifier);
            this.databaseName(model.databaseName);
            this.schema(model.schema);
            this.awsSecretStoreArn(model.awsSecretStoreArn);
        }

        public final String getAwsRegion() {
            return this.awsRegion;
        }

        @Override
        public final Builder awsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
            return this;
        }

        public final void setAwsRegion(String awsRegion) {
            this.awsRegion = awsRegion;
        }

        public final String getDbClusterIdentifier() {
            return this.dbClusterIdentifier;
        }

        @Override
        public final Builder dbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
            return this;
        }

        public final void setDbClusterIdentifier(String dbClusterIdentifier) {
            this.dbClusterIdentifier = dbClusterIdentifier;
        }

        public final String getDatabaseName() {
            return this.databaseName;
        }

        @Override
        public final Builder databaseName(String databaseName) {
            this.databaseName = databaseName;
            return this;
        }

        public final void setDatabaseName(String databaseName) {
            this.databaseName = databaseName;
        }

        public final String getSchema() {
            return this.schema;
        }

        @Override
        public final Builder schema(String schema) {
            this.schema = schema;
            return this;
        }

        public final void setSchema(String schema) {
            this.schema = schema;
        }

        public final String getAwsSecretStoreArn() {
            return this.awsSecretStoreArn;
        }

        @Override
        public final Builder awsSecretStoreArn(String awsSecretStoreArn) {
            this.awsSecretStoreArn = awsSecretStoreArn;
            return this;
        }

        public final void setAwsSecretStoreArn(String awsSecretStoreArn) {
            this.awsSecretStoreArn = awsSecretStoreArn;
        }

        public RdsHttpEndpointConfig build() {
            return new RdsHttpEndpointConfig(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, RdsHttpEndpointConfig> {
        public Builder awsRegion(String var1);

        public Builder dbClusterIdentifier(String var1);

        public Builder databaseName(String var1);

        public Builder schema(String var1);

        public Builder awsSecretStoreArn(String var1);
    }
}

