/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum TypeDefinitionFormat {
    SDL("SDL"),
    JSON("JSON"),
    UNKNOWN_TO_SDK_VERSION(null);

    private final String value;

    private TypeDefinitionFormat(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static TypeDefinitionFormat fromValue(String value) {
        if (value == null) {
            return null;
        }
        return Stream.of(TypeDefinitionFormat.values()).filter(e -> e.toString().equals(value)).findFirst().orElse(UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<TypeDefinitionFormat> knownValues() {
        return Stream.of(TypeDefinitionFormat.values()).filter(v -> v != UNKNOWN_TO_SDK_VERSION).collect(Collectors.toSet());
    }
}

