/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.appsync.model.AppSyncRequest;
import software.amazon.awssdk.services.appsync.model.AppSyncRuntime;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluateCodeRequest
extends AppSyncRequest
implements ToCopyableBuilder<Builder, EvaluateCodeRequest> {
    private static final SdkField<AppSyncRuntime> RUNTIME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("runtime").getter(EvaluateCodeRequest.getter(EvaluateCodeRequest::runtime)).setter(EvaluateCodeRequest.setter(Builder::runtime)).constructor(AppSyncRuntime::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtime").build()}).build();
    private static final SdkField<String> CODE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("code").getter(EvaluateCodeRequest.getter(EvaluateCodeRequest::code)).setter(EvaluateCodeRequest.setter(Builder::code)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("code").build()}).build();
    private static final SdkField<String> CONTEXT_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("context").getter(EvaluateCodeRequest.getter(EvaluateCodeRequest::context)).setter(EvaluateCodeRequest.setter(Builder::context)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build()}).build();
    private static final SdkField<String> FUNCTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("function").getter(EvaluateCodeRequest.getter(EvaluateCodeRequest::function)).setter(EvaluateCodeRequest.setter(Builder::function)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("function").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(RUNTIME_FIELD, CODE_FIELD, CONTEXT_FIELD, FUNCTION_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = EvaluateCodeRequest.memberNameToFieldInitializer();
    private final AppSyncRuntime runtime;
    private final String code;
    private final String context;
    private final String function;

    private EvaluateCodeRequest(BuilderImpl builder) {
        super(builder);
        this.runtime = builder.runtime;
        this.code = builder.code;
        this.context = builder.context;
        this.function = builder.function;
    }

    public final AppSyncRuntime runtime() {
        return this.runtime;
    }

    public final String code() {
        return this.code;
    }

    public final String context() {
        return this.context;
    }

    public final String function() {
        return this.function;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.runtime());
        hashCode = 31 * hashCode + Objects.hashCode(this.code());
        hashCode = 31 * hashCode + Objects.hashCode(this.context());
        hashCode = 31 * hashCode + Objects.hashCode(this.function());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateCodeRequest)) {
            return false;
        }
        EvaluateCodeRequest other = (EvaluateCodeRequest)((Object)obj);
        return Objects.equals(this.runtime(), other.runtime()) && Objects.equals(this.code(), other.code()) && Objects.equals(this.context(), other.context()) && Objects.equals(this.function(), other.function());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluateCodeRequest").add("Runtime", (Object)this.runtime()).add("Code", (Object)this.code()).add("Context", (Object)this.context()).add("Function", (Object)this.function()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "runtime": {
                return Optional.ofNullable(clazz.cast(this.runtime()));
            }
            case "code": {
                return Optional.ofNullable(clazz.cast(this.code()));
            }
            case "context": {
                return Optional.ofNullable(clazz.cast(this.context()));
            }
            case "function": {
                return Optional.ofNullable(clazz.cast(this.function()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("runtime", RUNTIME_FIELD);
        map.put("code", CODE_FIELD);
        map.put("context", CONTEXT_FIELD);
        map.put("function", FUNCTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<EvaluateCodeRequest, T> g) {
        return obj -> g.apply((EvaluateCodeRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends AppSyncRequest.BuilderImpl
    implements Builder {
        private AppSyncRuntime runtime;
        private String code;
        private String context;
        private String function;

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateCodeRequest model) {
            super(model);
            this.runtime(model.runtime);
            this.code(model.code);
            this.context(model.context);
            this.function(model.function);
        }

        public final AppSyncRuntime.Builder getRuntime() {
            return this.runtime != null ? this.runtime.toBuilder() : null;
        }

        public final void setRuntime(AppSyncRuntime.BuilderImpl runtime) {
            this.runtime = runtime != null ? runtime.build() : null;
        }

        @Override
        public final Builder runtime(AppSyncRuntime runtime) {
            this.runtime = runtime;
            return this;
        }

        public final String getCode() {
            return this.code;
        }

        public final void setCode(String code) {
            this.code = code;
        }

        @Override
        public final Builder code(String code) {
            this.code = code;
            return this;
        }

        public final String getContext() {
            return this.context;
        }

        public final void setContext(String context) {
            this.context = context;
        }

        @Override
        public final Builder context(String context) {
            this.context = context;
            return this;
        }

        public final String getFunction() {
            return this.function;
        }

        public final void setFunction(String function) {
            this.function = function;
        }

        @Override
        public final Builder function(String function) {
            this.function = function;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public EvaluateCodeRequest build() {
            return new EvaluateCodeRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends AppSyncRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, EvaluateCodeRequest> {
        public Builder runtime(AppSyncRuntime var1);

        default public Builder runtime(Consumer<AppSyncRuntime.Builder> runtime) {
            return this.runtime((AppSyncRuntime)((AppSyncRuntime.Builder)AppSyncRuntime.builder().applyMutation(runtime)).build());
        }

        public Builder code(String var1);

        public Builder context(String var1);

        public Builder function(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

