/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.appsync.AppSyncAsyncClient;
import software.amazon.awssdk.services.appsync.internal.UserAgentUtils;
import software.amazon.awssdk.services.appsync.model.ListResolversByFunctionRequest;
import software.amazon.awssdk.services.appsync.model.ListResolversByFunctionResponse;
import software.amazon.awssdk.services.appsync.model.Resolver;

public class ListResolversByFunctionPublisher
implements SdkPublisher<ListResolversByFunctionResponse> {
    private final AppSyncAsyncClient client;
    private final ListResolversByFunctionRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListResolversByFunctionPublisher(AppSyncAsyncClient client, ListResolversByFunctionRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListResolversByFunctionPublisher(AppSyncAsyncClient client, ListResolversByFunctionRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListResolversByFunctionResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListResolversByFunctionResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<Resolver> resolvers() {
        Function<ListResolversByFunctionResponse, Iterator> getIterator = response -> {
            if (response != null && response.resolvers() != null) {
                return response.resolvers().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListResolversByFunctionResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListResolversByFunctionResponseFetcher
    implements AsyncPageFetcher<ListResolversByFunctionResponse> {
        private ListResolversByFunctionResponseFetcher() {
        }

        public boolean hasNextPage(ListResolversByFunctionResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListResolversByFunctionResponse> nextPage(ListResolversByFunctionResponse previousPage) {
            if (previousPage == null) {
                return ListResolversByFunctionPublisher.this.client.listResolversByFunction(ListResolversByFunctionPublisher.this.firstRequest);
            }
            return ListResolversByFunctionPublisher.this.client.listResolversByFunction((ListResolversByFunctionRequest)((Object)ListResolversByFunctionPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

