/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.appsync.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.appsync.model.CodeError;
import software.amazon.awssdk.services.appsync.model.CodeErrorsCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class EvaluateCodeErrorDetail
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, EvaluateCodeErrorDetail> {
    private static final SdkField<String> MESSAGE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("message").getter(EvaluateCodeErrorDetail.getter(EvaluateCodeErrorDetail::message)).setter(EvaluateCodeErrorDetail.setter(Builder::message)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("message").build()}).build();
    private static final SdkField<List<CodeError>> CODE_ERRORS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("codeErrors").getter(EvaluateCodeErrorDetail.getter(EvaluateCodeErrorDetail::codeErrors)).setter(EvaluateCodeErrorDetail.setter(Builder::codeErrors)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("codeErrors").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(CodeError::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MESSAGE_FIELD, CODE_ERRORS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = Collections.unmodifiableMap(new HashMap<String, SdkField<?>>(){
        {
            this.put("message", MESSAGE_FIELD);
            this.put("codeErrors", CODE_ERRORS_FIELD);
        }
    });
    private static final long serialVersionUID = 1L;
    private final String message;
    private final List<CodeError> codeErrors;

    private EvaluateCodeErrorDetail(BuilderImpl builder) {
        this.message = builder.message;
        this.codeErrors = builder.codeErrors;
    }

    public final String message() {
        return this.message;
    }

    public final boolean hasCodeErrors() {
        return this.codeErrors != null && !(this.codeErrors instanceof SdkAutoConstructList);
    }

    public final List<CodeError> codeErrors() {
        return this.codeErrors;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.message());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCodeErrors() ? this.codeErrors() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof EvaluateCodeErrorDetail)) {
            return false;
        }
        EvaluateCodeErrorDetail other = (EvaluateCodeErrorDetail)obj;
        return Objects.equals(this.message(), other.message()) && this.hasCodeErrors() == other.hasCodeErrors() && Objects.equals(this.codeErrors(), other.codeErrors());
    }

    public final String toString() {
        return ToString.builder((String)"EvaluateCodeErrorDetail").add("Message", (Object)this.message()).add("CodeErrors", this.hasCodeErrors() ? this.codeErrors() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "message": {
                return Optional.ofNullable(clazz.cast(this.message()));
            }
            case "codeErrors": {
                return Optional.ofNullable(clazz.cast(this.codeErrors()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static <T> Function<Object, T> getter(Function<EvaluateCodeErrorDetail, T> g) {
        return obj -> g.apply((EvaluateCodeErrorDetail)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String message;
        private List<CodeError> codeErrors = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(EvaluateCodeErrorDetail model) {
            this.message(model.message);
            this.codeErrors(model.codeErrors);
        }

        public final String getMessage() {
            return this.message;
        }

        public final void setMessage(String message) {
            this.message = message;
        }

        @Override
        public final Builder message(String message) {
            this.message = message;
            return this;
        }

        public final List<CodeError.Builder> getCodeErrors() {
            List<CodeError.Builder> result = CodeErrorsCopier.copyToBuilder(this.codeErrors);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCodeErrors(Collection<CodeError.BuilderImpl> codeErrors) {
            this.codeErrors = CodeErrorsCopier.copyFromBuilder(codeErrors);
        }

        @Override
        public final Builder codeErrors(Collection<CodeError> codeErrors) {
            this.codeErrors = CodeErrorsCopier.copy(codeErrors);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeErrors(CodeError ... codeErrors) {
            this.codeErrors(Arrays.asList(codeErrors));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder codeErrors(Consumer<CodeError.Builder> ... codeErrors) {
            this.codeErrors(Stream.of(codeErrors).map(c -> (CodeError)((CodeError.Builder)CodeError.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public EvaluateCodeErrorDetail build() {
            return new EvaluateCodeErrorDetail(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, EvaluateCodeErrorDetail> {
        public Builder message(String var1);

        public Builder codeErrors(Collection<CodeError> var1);

        public Builder codeErrors(CodeError ... var1);

        public Builder codeErrors(Consumer<CodeError.Builder> ... var1);
    }
}

